/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dzxm
 */

// BitmapDataのhistogramってどんなのか実験。
// 
// とりあえずperlinNoiseをhistogramしてみる。
// 
// resetを押すとBitmapDataが新しくなります。
// 上の数字はnumOctaves
// 下はチェックを入れるとfractalNoiseがtrueになります
// 
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
    public class FlashTest extends Sprite {
		private var bmpdata:BitmapData;
		private var tfoutput:TextField;
		private var view:Sprite;
		private var input:Object;
        public function FlashTest() {
			bmpdata = new BitmapData(100, 100, false);
			addChild(new Bitmap(bmpdata));
			
			tfoutput = createTextfield();
			tfoutput.type = "input";
			tfoutput.y = 100;
			
			addChild(view = new Sprite());
			view.y = stage.stageHeight;
			
			var btn:Sprite = new Sprite();
			addChild(btn);
			btn.x = 120;
			btn.graphics.beginFill(0xE0E0E0);
			btn.graphics.drawRect(0, 0, 50, 20);
			btn.graphics.endFill();
			var t:TextField;
			btn.addChild(t = new TextField());
			t.text = "reset";
			t.autoSize = "left";
			btn.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void { reset(); } );
			
			input = new Object;
			input.numOctaves = t = createTextfield();
			t.x = 120;
			t.y = 30;
			t.type = "input";
			t.text = "2";
			input.fractalNoise = true;
			addChild(btn = new Sprite());
			btn.x = 120;
			btn.y = 60;
			btn.graphics.beginFill(0x808080);
			btn.graphics.drawRect(0, 0, 20, 20);
			var sp:Sprite = new Sprite();
			btn.addChild(sp);
			sp.graphics.beginFill(0xFFFFFF);
			sp.graphics.drawRect(5, 5, 10, 10);
			btn.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void
			{
				sp.visible = !sp.visible;
				input.fractalNoise = sp.visible;
			});
			
			reset();
        }
		
		private function createTextfield():TextField
		{
			var t:TextField = new TextField;
			addChild(t);
			t.background = true;
			t.backgroundColor = 0xE0E0E0;
			t.autoSize = "left";
			return t;
		}
		
		private function reset():void
		{
			var data:Array = new Array();
			data[0] = Number(input.numOctaves.text);
			data[1] = input.fractalNoise;
			bmpdata.perlinNoise(50, 50, data[0], Math.random() * 0xFFFFFFFF, false, data[1]);
			
			var vec:Vector.<Vector.<Number>> = bmpdata.histogram(bmpdata.rect);
			tfoutput.text = "";
			tfoutput.appendText("r:"+vec[0].toString() + "\n");
			tfoutput.appendText("g:"+vec[1].toString() + "\n");
			tfoutput.appendText("b:" + vec[2].toString());
			
			var g:Graphics = view.graphics;
			g.clear();
			g.lineStyle( -1, 0);
			g.moveTo(0, 0);
			g.lineTo(255, 0);
			g.endFill();
			
			for (var c:int = 0; c < 3; c++)
			{
				g.lineStyle( -1, 0xFF0000 >> (c * 8));
				g.moveTo(0, -vec[c][0]);
				for (var i:int = 0; i < 256; i++)
					g.lineTo(i, -vec[c][i]);
				g.endFill();
			}
		}
    }
}