/**
 * Copyright yarhalla1 ( http://wonderfl.net/user/yarhalla1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dzd8
 */

// forked from yarhalla1's Simple Color Pallette
package {
    import flash.display.Sprite;
    import flash.display.*;
    import flash.events.MouseEvent;
    import flash.events.DataEvent;
    import flash.filters.*;
    import flash.geom.*;
    //TODO
    // Gradation
    // Load Pallete
    // Edit Color
    // 

    public class ColorPickerYh extends Sprite {
        private var size:int = 14;
        private var colors:Array = [
           '0x000000', '0xFF0000', '0xFF8800',
           '0xFFFF00', '0x88FF00', '0x00FF00', '0x00FF88', '0x00FFFF',
           '0x0088FF', '0x0000FF', '0x8800FF', '0xFF00FF', '0xFFFFFF',
           '0x000000', '0xFF0000', '0xFF8800',
           '0xFFFF00', '0x88FF00', '0x00FF00', '0x00FF88', '0x00FFFF',
           '0x0088FF', '0x0000FF', '0x8800FF', '0xFF00FF', '0xFFFFFF',
           '0x000000', '0xFF0000', '0xFF8800',
           '0xFFFF00', '0x88FF00', '0x00FF00', '0x00FF88', '0x00FFFF',
           '0x0088FF', '0x0000FF', '0x8800FF', '0xFF00FF', '0xFFFFFF',
           '0x000000', '0xFF0000', '0xFF8800',
           '0xFFFF00', '0x88FF00', '0x00FF00', '0x00FF88', '0x00FFFF',
           '0x0088FF', '0x0000FF', '0x8800FF', '0xFF00FF', '0xFFFFFF',
                      '0xFFFF00', '0x88FF00', '0x00FF00', '0x00FF88', '0x00FFFF',
           '0x0088FF', '0x0000FF', '0x8800FF', '0xFF00FF', '0xFFFFFF','0x8800FF', '0xFF00FF', '0xFFFFFF',
       ];
       
        private var spr:Sprite = new Sprite();
        private var selectedIndex:int = 0;

        private function Redraw():void{
            spr.graphics.clear();

            var count:int = 0;
            for each(var color:int in colors){
                spr.graphics.beginFill(colors[count], 1);
                spr.graphics.drawRect((count & 15) * size, (count >> 4) * size, size , size );
                spr.graphics.endFill();
                spr.filters = [new DropShadowFilter(2, 45, 0x0, 1, 2, 2, .3, 1, true)];
                count++;
            }
            
            spr.filters = [new DropShadowFilter(2, 45, 0x0, 1, 2, 2, .9, 1, true)];
            spr.graphics.lineStyle (1, 0xFFFFFF, 1.0);
            spr.graphics.beginFill(0xFF0000, 0);
            spr.graphics.drawRect((selectedIndex & 15) * size, (selectedIndex >> 4) * size, size , size );
            spr.graphics.endFill();
        }
        
      private function onColorPicked(event:MouseEvent):void{
        var cx:int = event.localX / size;
        var cy:int = event.localY / size;
        
        var coloridx:int = cy * 16 + cx;
        selectedIndex = coloridx;
        
        selectedColor.graphics.clear();
        selectedColor.graphics.beginFill(colors[coloridx], 1);
        selectedColor.graphics.drawRect(0, 0, 32, 32);
        selectedColor.graphics.endFill();
        
        Redraw();
      }
      
      

      private var selectedColor:Sprite = new Sprite();
        
      public function ColorPickerYh() {
        selectedColor.filters = [new DropShadowFilter(2, 45, 0x0, 1, 2, 2, .7, 1, true)];
        addChild(selectedColor);
        
        Redraw();
        spr.buttonMode = true;
        addChild(spr);
        spr.y = 34;
        spr.addEventListener(MouseEvent.CLICK, onColorPicked);
      }
    }
}