/**
 * Copyright PAPER104 ( http://wonderfl.net/user/PAPER104 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dzVh
 */

// forked from Scmiz's arc
package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var sprite:Sprite = new Sprite();
            sprite.x = 232.5;//円の中心X
            sprite.y = 232.5;//円の中心Y
            
            var centerX:Number = 0;//回転する円の中心X
            var centerY:Number = 0;//回転する円の中心Y
            var radius:Number = 232.5;//半径
            var num:uint = 12;//描かれる円を分割する変数
            var step:Number = 360 / num;//描かれる三角形の角度
            var split:uint = 7;//？？？
            var layer:uint = 10;//同心円を描く個数の変数
            for (var index:uint = 0; index < num; ++index ) {
                    drawStripeArc(sprite, (index % 2 == 0), centerX, centerY, radius, step * index, (step * index) + step + 5, split, layer);
            }
            this.addChild(sprite);
            
            this.addEventListener(Event.ENTER_FRAME, function(e:Event):void{
                sprite.rotationZ += 0.5;//円の回転する角度（速さ）
            });
        }
        
        private function drawStripeArc(sprite:Sprite, outBlack:Boolean, x:Number, y:Number, radius:Number, startDeg:Number, endDeg:Number, split:uint, layer:uint):void {
            for (var index:uint = 0; index < layer; ++index) {
                var color:uint = 0xff0000;
                if (outBlack) {
                    if ((index % 2) == 1) color = 0x000000;                
                }
                else {
                    if ((index % 2) == 1) color = 0xff0000;              
                    else color = 0x000000;
                }             
                sprite.graphics.beginFill(color);
                drawArc(sprite, x, y, radius * (1.0 - (index / layer)), startDeg, endDeg, split);
                sprite.graphics.endFill();                
            }
        }

        
        private function drawArc(sprite:Sprite, x:Number, y:Number, radius:Number, startDeg:Number, endDeg:Number, split:uint):void {
            sprite.graphics.moveTo(x, y);
            for (var index:uint = 0; index < split; ++index) {
                var deg:Number = -(startDeg + ((endDeg - startDeg) * (Number)(index / split)));
                var rad:Number = (Math.PI * 2 * deg) / 360;
                sprite.graphics.lineTo(x + (Math.cos(rad) * radius), y + (Math.sin(rad) * radius));
            }
            sprite.graphics.moveTo(x, y);
        }
    }
}