/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dzV7
 */

// forked from attunedesigns's flash on 2009-9-8
package {

         import flash.display.CapsStyle;
         import flash.display.GradientType;
         import flash.display.Shape;
         import flash.display.SpreadMethod;
         import flash.display.Sprite;
         import flash.events.MouseEvent;
         import flash.geom.Matrix;
         import flash.geom.Point;

         [SWF(width=550, height=400, backgroundColor=0xFFFFFF)]

         public class DrawingGradientLines extends Sprite {

           private var _currentShape:Shape;
           private var _color:uint;
           private var _startPosition:Point;

           public function DrawingGradientLines() {
             stage.addEventListener(MouseEvent.MOUSE_DOWN, onStageMouseDown);
             stage.addEventListener(MouseEvent.MOUSE_UP, onStageMouseUp);
           }

           private function drawLine():void {
             var thickness:Number = 50;

             var colors:Array = [_color, _color];
             var alphas:Array = [1, 0];
             var ratios:Array = [127, 127];

             var currentPosition:Point = new Point(stage.mouseX, 
       stage.mouseY);
             var xDist:Number = (currentPosition.x - _startPosition.x);
             var yDist:Number = (currentPosition.y - _startPosition.y);
             var angle:Number = Math.atan2(yDist, xDist);
             var matrix:Matrix = new Matrix();
             matrix.createGradientBox(thickness, thickness, angle);

             _currentShape.graphics.clear();
             _currentShape.graphics.lineStyle(thickness, 0, 1, false, 
       null, CapsStyle.SQUARE);
             _currentShape.graphics.lineGradientStyle(GradientType.LINEAR, 
       colors, alphas, ratios, matrix, SpreadMethod.REPEAT);
             _currentShape.graphics.moveTo(_startPosition.x, 
       _startPosition.y);
             _currentShape.graphics.lineTo(stage.mouseX, stage.mouseY);
           }

           private function onStageMouseDown(event:MouseEvent):void {
             _color = Math.random()*0xFFFFFF;
             _currentShape = new Shape();
             addChild(_currentShape);
             _startPosition = new Point(stage.mouseX, stage.mouseY);
             stage.addEventListener(MouseEvent.MOUSE_MOVE, onStageMouseMove);
           }

           private function onStageMouseUp(event:MouseEvent):void {
             stage.removeEventListener(MouseEvent.MOUSE_MOVE, 
       onStageMouseMove);
           }

           private function onStageMouseMove(event:MouseEvent):void {
             drawLine();
             event.updateAfterEvent();
           }
         }
       }
