/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dzEf
 */

package
{
    // Load系コマンドでは二度目以降の読み込みに対して
    // catchErrorが発生しない仕様(もしくは不具合)

    // Progressionフォーラムに投稿
    // http://forum.progression.jp/index.php?topic=315.0
    
    public class Main extends Sprite
    {
        public static const URL:String = "hoge.jpg";
        
        public function Main()
        {
            var btn:PushButton = new PushButton(this, 10, 10, "LOAD START", _onClick);
            _label = new Text(this, 10, 100, "");
        }
        
        private var _label:Text;

        private function _onClick(e:Event):void
        {
            _label.text = "NOW LOADING";
            
            var list:SerialList = new SerialList();
            
            // エラーハンドリング
            list.catchError = function(target:Command, err:Error):void
            {
                // 二回目以降が呼ばれない
                _label.text = "CATCH ERROR : \n" + target.toString() + ", \n"+ err.toString();
                target.executeComplete();
            };
            
            // 読み込み処理
            list.addCommand(
                new LoadBitmapData(new URLRequest(URL)),
                function():void
                {
                    var res:Resource = getResourceById(URL);
                    
                    if(res && res.data)
                    {
                        // 読み込みが正常だったときの処理    
                    }
                    else
                    {
                        // 読み込みが行われなかったときの処理
                    }
                });
            list.execute();
        }
    }
    
    import com.bit101.components.PushButton;    import com.bit101.components.Text;        import flash.display.Sprite;    import flash.events.Event;    import flash.net.URLRequest;        import jp.progression.commands.Command;    import jp.progression.commands.lists.SerialList;    import jp.progression.commands.net.LoadBitmapData;    import jp.progression.data.Resource;    import jp.progression.data.getResourceById;
}