/**
 * Copyright tanaka ( http://wonderfl.net/user/tanaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dxnX
 */

// forked from ProjectNya's EmitParticle (3)
////////////////////////////////////////////////////////////////////////////////
// EmitParticle (3)
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.MouseEvent;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var emit:EmitParticle;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            emit = new EmitParticle();
            addChild(emit);
        }

    }

}


//////////////////////////////////////////////////
// EmitParticleクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;

class EmitParticle extends Sprite {
    private static var max:uint = 4;
    private var id:uint = 0;
    private var particles:Array;
    private static var friction:Number = 0.96;
    private static var gravity:Number = 0.5;

    public function EmitParticle() {
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        particles = new Array();
        stage.addEventListener(MouseEvent.MOUSE_MOVE, create, false, 0, true);
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function create(evt:MouseEvent):void {
        for (var n:uint = 0; n < max; n++) {
            var particle:Particle = new Particle(id);
            particle.id = id;
            addChild(particle);
            particle.vx = Math.random()*10 - 5;
            particle.vy = -8;
            particle.x = mouseX + Math.random()*20 - 10;
            particle.y = mouseY + Math.random()*20 - 10;
            particles.push(particle);
            id ++;
        }
    }
    private function update(evt:Event):void {
        for (var n:uint = 0; n < particles.length; n++) {
            var particle:Particle = particles[n];
            particle.x += particle.vx;
            particle.y += particle.vy;
            particle.vx *= friction;
            particle.vy *= friction;
            particle.vy += gravity;
            particle.angle += 5;
            if (particle.y > stage.stageHeight + 20) {
                removeChild(particle);
                particles.splice(n, 1);
                particle = null;
            }
        }
    }

}


//////////////////////////////////////////////////
// Particleクラス
//////////////////////////////////////////////////

import flash.display.Shape;
import flash.display.BlendMode;
import frocessing.color.ColorHSV;

class Particle extends Shape {
    public var id:uint;
    private static var radius:uint = 8;
    private static var inner:uint = 4;
    public var vx:Number = 0;
    public var vy:Number = 0;
    private var color:ColorHSV;
    private var _angle:Number = 0;
    private static var radian:Number = Math.PI/180;
    private var _scale:Number;

    public function Particle(hue:Number = 0) {
        color = new ColorHSV(hue, 0.6);
        draw();
        blendMode = BlendMode.ADD;
    }

    private function draw():void {
        graphics.beginFill(color.value);
        graphics.drawCircle(0, 0, radius);
        graphics.drawCircle(0, 0, inner);
        graphics.endFill();
    }
    public function get angle():Number {
        return _angle;
    }
    public function set angle(param:Number):void {
        _angle = param;
        scale = 1 + Math.sin(_angle*radian)*0.6;
    }
    private function get scale():Number {
        return _scale;
    }
    private function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }

}
