/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dxTY
 */

//ADDS MOUSE SUPPORT
package {
  import flash.display.*;
  import flash.events.*;
  import flash.filters.BlurFilter;
  import flash.geom.*;
  import flash.ui.*;
  public class ch23ex2 extends Sprite {
    protected const BMP_SCALE:Number = 1/2;
    protected const DIM_AMT:Number = 1.015;
    protected const DIM:ColorTransform = new ColorTransform(DIM_AMT, DIM_AMT, DIM_AMT);
    protected const BLUR:BlurFilter = new BlurFilter(16, 16, 1);
    protected var RLUT:Array, GLUT:Array, BLUT:Array;
    protected var sourceBmp:BitmapData;
    protected var colorBmp:BitmapData;
    protected var touches:Array = new Array();
    protected var fingerShape:Shape = new Shape();
    protected var isMultitouch:Boolean = false;
    protected var isMouseDown:Boolean = false;
    public function ch23ex2() {
      try {
        var test:Class = Multitouch;
        if (Multitouch.supportsTouchEvents) {
          Multitouch.inputMode = MultitouchInputMode.TOUCH_POINT;
          isMultitouch = true;
        }
      } catch (error:ReferenceError) {
        trace("Sorry, but multitouch is not supported in this runtime.");
      }
      init();          
    }
    protected function init():void {
      sourceBmp = new BitmapData(stage.stageWidth*BMP_SCALE, stage.stageHeight*BMP_SCALE, false, 0);
      colorBmp = sourceBmp.clone();
      var bitmap:Bitmap = new Bitmap(colorBmp, PixelSnapping.ALWAYS, true);
      bitmap.width = stage.stageWidth; bitmap.height = stage.stageHeight;
      addChild(bitmap);
      
      fingerShape.graphics.beginFill(0xffffff, 0.1);
      fingerShape.graphics.drawEllipse(-15, -20, 30, 40);
      fingerShape.graphics.endFill();
      
      var gradient:Shape = new Shape();
      var m:Matrix = new Matrix();
      m.createGradientBox(256, 10);
      gradient.graphics.beginGradientFill(GradientType.LINEAR,
        [0x313ad8, 0x2dce4a, 0xdae234, 0x7a1c1c, 0x0f0303],
        [1, 1, 1, 1, 1],
        [0,        0.4*256,      0.75*256,      0.9*256,      255],
        m
      );
      gradient.graphics.drawRect(0, 0, 256, 10);
      var gradientBmp:BitmapData = new BitmapData(256, 10, false, 0);
      gradientBmp.draw(gradient);
      RLUT = new Array(); GLUT = new Array(); BLUT = new Array();
      for (var i:int = 0; i < 256; i++) {
        var pixelColor:uint = gradientBmp.getPixel(i, 0);
        RLUT[256-i] = pixelColor & 0xff0000;
        GLUT[256-i] = pixelColor & 0x00ff00;
        BLUT[256-i] = pixelColor & 0x0000ff;
      }
      
      if (isMultitouch) {
        stage.addEventListener(TouchEvent.TOUCH_BEGIN, assignTouch);
        stage.addEventListener(TouchEvent.TOUCH_MOVE, assignTouch);
        stage.addEventListener(TouchEvent.TOUCH_END, removeTouch);
      } else {
        stage.addEventListener(MouseEvent.MOUSE_DOWN, function():void{isMouseDown = true});
        stage.addEventListener(MouseEvent.MOUSE_UP, function():void{isMouseDown = false});
      }
      stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    protected function assignTouch(event:TouchEvent):void {
      touches[event.touchPointID] = event;
    }
    protected function removeTouch(event:TouchEvent):void {
      delete touches[event.touchPointID];
    }
    protected function onEnterFrame(event:Event):void {
      if (isMultitouch) {
        for (var key:String in touches) {
          var touch:TouchEvent = touches[key] as TouchEvent;
          if (touch) {
            var m:Matrix = new Matrix();
            m.translate(touch.stageX*BMP_SCALE, touch.stageY*BMP_SCALE);
            sourceBmp.draw(fingerShape, m, null, BlendMode.ADD);
          }
        }
      } else if (isMouseDown) {
        m = new Matrix();
        m.translate(stage.mouseX*BMP_SCALE, stage.mouseY*BMP_SCALE);
        sourceBmp.draw(fingerShape, m, null, BlendMode.ADD);
      }
      sourceBmp.applyFilter(sourceBmp, sourceBmp.rect, sourceBmp.rect.topLeft, BLUR);
      sourceBmp.colorTransform(sourceBmp.rect, DIM);
      colorBmp.paletteMap(sourceBmp, sourceBmp.rect, colorBmp.rect.topLeft, RLUT, GLUT, BLUT, null);
    }
  }
}