/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dxTS
 */

package {
	import flash.events.Event;
	import org.papervision3d.core.math.Matrix3D;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.view.BasicView;
	import sliz.miniui.layouts.BoxLayout;
	import sliz.miniui.Silder;
	import sliz.miniui.Window;

	/**
	 * ...
	 * @author sliz http://game-develop.net/blog
	 */
	public class Test extends BasicView {
		private var d:Diamond;
		private var m:WireframeMaterial;
		private var nv:int;
		private var d1v:Number;
		private var n1v:Number;
		private var n2v:Number;
		private var n4v:Number;
		private var n5v:Number;

		public function Test(){
			startRendering();
			addEventListener(Event.ENTER_FRAME, updata);
			m = new WireframeMaterial(0x0000ff);
			d = new Diamond(m);
			scene.addChild(d);
			d.scale = 500;

			var n:Silder = new Silder(0, 0, null, "num", sn);
			n.value = 1 / 3;
			var d1:Silder = new Silder(0, 0, null, "num", sd1);
			d1.value = 0.53;
			var n1:Silder = new Silder(0, 0, null, "num", sn1);
			n1.value = 0.162;
			var n2:Silder = new Silder(0, 0, null, "num", sn2);
			n2.value = 0.108;
			var n4:Silder = new Silder(0, 0, null, "num", sn4);
			n4.value = 0.278;
			var n5:Silder = new Silder(0, 0, null, "num", sn5);
			n5.value = 0.431;

			var w:Window = new Window(this, 100, 100);
			w.add(n);
			w.add(d1);
			w.add(n1);
			w.add(n2);
			w.add(n4);
			w.add(n5);
			var layout:BoxLayout = new BoxLayout(w, BoxLayout.Y_AXIS, 10);
			w.setLayout(layout);
			w.doLayout();
		}

		private function sn4(v:Number):String {
			n4v = -v;
			reset();
			return -n4v + "";
		}

		private function sn5(v:Number):String {

			n5v = -v;
			reset();
			return -n5v + "";
		}

		private function sn2(v:Number):String {
			n2v = v;
			reset();
			return n2v + "";
		}

		private function sn1(v:Number):String {
			n1v = v;
			reset();
			return n1v + "";
		}

		private function sd1(v:Number):String {
			d1v = v;
			reset();
			return d1v + "";
		}

		private function sn(v:Number):String {
			var n:int = v * 15 + 3;
			nv = n;
			reset();
			return n + "";
		}

		private function updata(e:Event):void {
			d.rotationX++;
			d.rotationY++;
		}

		private function reset():void {
			if (d && d.root){
				scene.removeChild(d);
				var d2:Diamond = d;
				d = new Diamond(m, nv, d1v, n1v, n2v, n4v, n5v);
				d.copyTransform(d2);
				d.scale = 500;
				scene.addChild(d);
			}
		}
	}
}

import org.papervision3d.core.geom.*;
import org.papervision3d.core.geom.renderables.Triangle3D;
import org.papervision3d.core.geom.renderables.Vertex3D;
import org.papervision3d.core.proto.*;

class Diamond extends TriangleMesh3D {
	public function Diamond(material:MaterialObject3D, n:Number = 8, d1:Number = 0.53, h1:Number = 0.162, h2:Number = 0.108, h4:Number = -0.287, h5:Number = -0.431){
		super(material, new Array(), new Array(), null);
		var d2:Number = 2 * (((((1 - d1) / 2) * (h1 - h2) / h1) + d1 / 2) / Math.cos(Math.PI / n));
		var d4:Number = (h5 - h4) / (h5 * Math.cos(Math.PI / n));
		var aVertice:Array = this.geometry.vertices;
		var aFace:Array = this.geometry.faces;
		for (var i:int = 0; i < n + 1; i++){
			aVertice.push(new Vertex3D(d1 * Math.cos(i * Math.PI / (n / 2)) / 2, d1 * Math.sin(i * Math.PI / (n / 2)) / 2, h1));
			aVertice.push(new Vertex3D(d2 * Math.cos(i * Math.PI / (n / 2) + Math.PI / n) / 2, d2 * Math.sin(i * Math.PI / (n / 2) + Math.PI / n) / 2, h2));
			aVertice.push(new Vertex3D(Math.cos(i * Math.PI / (n / 2)) / 2, Math.sin(i * Math.PI / (n / 2)) / 2, 0));
			aVertice.push(new Vertex3D(Math.cos(i * Math.PI / (n / 2) + Math.PI / n) / 2, Math.sin(i * Math.PI / (n / 2) + Math.PI / n) / 2, 0));
			aVertice.push(new Vertex3D(d4 * Math.cos(i * Math.PI / (n / 2) + Math.PI / n) / 2, d4 * Math.sin(i * Math.PI / (n / 2) + Math.PI / n) / 2, h4));
		}
		aVertice.push(new Vertex3D(0, 0, h5));
		for (i = 0; i < n - 2; i++){
			aFace.push(new Triangle3D(this, [aVertice[0], aVertice[5 * (i + 2)], aVertice[5 * (i + 1)]], material));
		}
		for (i = 0; i < n; i++){
			aFace.push(new Triangle3D(this, [aVertice[5 * i + 1], aVertice[i * 5], aVertice[(i + 1) * 5]], material));
			aFace.push(new Triangle3D(this, [aVertice[5 * i + 1], aVertice[(i + 1) * 5], aVertice[(i + 1) * 5 + 1]], material));
			aFace.push(new Triangle3D(this, [aVertice[5 * i + 1], aVertice[(i + 1) * 5 + 1], aVertice[5 * (i + 1) + 2]], material));
			aFace.push(new Triangle3D(this, [aVertice[5 * i + 1], aVertice[5 * i + 3], aVertice[5 * i + 2]], material));
			aFace.push(new Triangle3D(this, [aVertice[5 * i + 1], aVertice[5 * (i + 1) + 2], aVertice[5 * i + 3]], material));
			aFace.push(new Triangle3D(this, [aVertice[5 * i + 2], aVertice[5 * i + 3], aVertice[5 * i + 4]], material));
			aFace.push(new Triangle3D(this, [aVertice[5 * (i + 1) + 2], aVertice[5 * i + 4], aVertice[5 * i + 3]], material));
			aFace.push(new Triangle3D(this, [aVertice[5 * i + 4], aVertice[5 * (i + 1) + 2], aVertice[5 * (i + 1) + 4]], material));
			aFace.push(new Triangle3D(this, [aVertice[5 * i + 4], aVertice[5 * (i + 1) + 4], aVertice[5 * (n + 1)]], material));
		}
	}
}