/**
 * Copyright umi_kappa ( http://wonderfl.net/user/umi_kappa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dwFR
 */

// forked from umi_kappa's 偶然できたパーティクル part2
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.ColorTransform;
    import flash.events.Event;
    import flash.display.Sprite;
    
    import net.hires.debug.Stats;
    
    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "60")]
    
    public class FlashTest extends Sprite {
        //ステージサイズ
        private var _stageW:int;
        private var _stageH:int;
        
        //全てをDrawする
        private var _drawCanvas:BitmapData;
        
        //_drawCanvasが入る
        private var _bmp:Bitmap;
        
        //パーティクルの配列
        private var _pVector:Vector.<Particle>;
        
	//前の座標
	private var _prevX:int;
        private var _prevY:int;

        public function FlashTest() {
            init();
            
            startEvent();
        }
        
        //--------------------------------------------------------------------------
        //
        //  初期化
        //
        //--------------------------------------------------------------------------
        private function init():void 
        {
            addChild(new Stats());
            
            _stageW = stage.stageWidth;
            _stageH = stage.stageHeight;
    
            _pVector = new Vector.<Particle>();
            
            _drawCanvas = new BitmapData(_stageW, _stageH, true, 0x00ffffff);
            _bmp = new Bitmap(_drawCanvas);
            addChild(_bmp);
        }
        
        
        //----------------------------------
        //  Start Event
        //----------------------------------
        private function startEvent():void
        {
            addEventListener(Event.ENTER_FRAME, onEF);
        }
        
        
        //----------------------------------
        //  ENTER_FRAME
        //----------------------------------
        private function onEF(e:Event):void
        {
	    var _rad:Number = Math.atan2(_prevY - mouseY, _prevX - mouseX);
			
	    //進む方向と逆
	    var _vx:Number = Math.cos(_rad);
	    var _vy:Number = Math.sin(_rad);
			
	    //動いていたらadd
	    if(_prevX - mouseX != 0 && _prevY - mouseY != 0)addParticle(mouseX, mouseY, _vx, _vy);
			
	    moveParticle();
			
	    _prevX = mouseX;
	    _prevY = mouseY;
        }
        
        
        
        //----------------------------------
        //  draw
        //----------------------------------
        public function addParticle(x:int, y:int, vx:Number, vy:Number):void
        {
            var _p:Particle = new Particle(x, y, vx, vy, 0xffffffff);
            _pVector.push(_p);
        }

        //----------------------------------
        //  move
        //----------------------------------
        public function moveParticle():void
        {
            var _colorT:ColorTransform = new ColorTransform(1, 1, 1, 0.95);
            _drawCanvas.colorTransform(_drawCanvas.rect, _colorT);
    
            var _p:Particle;
	    var _alphaEase:uint = 0x01000000;
	    var _num:uint = _pVector.length;
	    for (var i:int = _num - 1; i >= 0; i--) 
	    {
	        _p = _pVector[i];
		_p.x += _p.vx;
		_p.y += _p.vy;
				
		if ((_p.color - _alphaEase) >>> 24 < 255) 
		{
	            //alphaを下げていく
		    _p.color -= _alphaEase;
		    _drawCanvas.setPixel32(_p.x, _p.y, _p.color);
		}
		else
		{
		    _pVector.splice(i, 1);
		}
	    }
        }
    }
}



class Particle {
    //x軸
    public var x:Number;
    //y軸
    public var y:Number;
    //x軸方向の速さ
    public var vx:Number;
    //y軸方向の速さ
    public var vy:Number;
    //色
    public var color:Number;
    
    public function Particle(x:Number, y:Number, vx:Number, vy:Number, color:Number):void
    {
        this.x = x;
        this.y = y;
        this.vx = vx;
        this.vy = vy;
        this.color = color;
    }
}