/**
 * Copyright _shimabox ( http://wonderfl.net/user/_shimabox )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dwDo
 */

package 
{
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;
	
	/**
	 * H2O
	 * ...
	 * @author _s
	 */
	[SWF(width="465", height="465", frameRate="30")]
	public class Main extends Sprite 
	{	
		private const H_WORD_NUM:int = 30;
		private const O_WORD_NUM:int = 50;
		private const MARGE_AFTER_WORD:String = "H2";
		private var _hWords:Vector.<H> = new Vector.<H>;
		private var _oWords:Vector.<O> = new Vector.<O>;
		private var _h2Os:Vector.<H2o> = new Vector.<H2o>;
		
		public function Main():void
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			for (var i:int = 0; i < H_WORD_NUM; i++) {
				this._hWords.push(this.drowHWord());
			}
			for (var j:int = 0; j < O_WORD_NUM; j++) {
				this._oWords.push(this.drowOWord());
			}
			this.addEventListener(Event.ENTER_FRAME, this.enterFrameHandler);
			this.addEventListener(Event.ENTER_FRAME,this.h2oFrameHandler);
			Wonderfl.capture_delay( 2 );
		}
		
		private function enterFrameHandler(e:Event):void 
		{
			this.moveHWord();
			this.moveOword();
		}
		
		private function h2oFrameHandler(e:Event):void
		{
			var h2oLen:int = this._h2Os.length;
			for (var i:int = 0; i < h2oLen; i++ ) {
				var h2o:H2o = this._h2Os[i];
				var dx:Number = Math.random() * 5;
				h2o.y += 3;
				h2o.x += Math.cos((h2o.y + dx) / 100);
				h2o.y += Math.sin((h2o.x + dx) / 100);
				if (h2o.y >= this.stage.stageHeight) {
					h2o.deleteFlag = true;
				}
			}
			for (var j:int = h2oLen - 1; j >= 0; j-- ) {
				h2o = this._h2Os[j];
				if (h2o.deleteFlag) {
					this._h2Os.splice(j, 1);
					this.clear(h2o);
				}
			}
		}
		
		private function moveHWord():void
		{
			var hLen:int = this._hWords.length;
			for (var i:int = 0; i < hLen; i++) {
				var main:H = this._hWords[i];
				this.move(main);
				if (main.isMarge) continue;
				for (var j:int = i+1; j < hLen; j++) {
					var target:H = this._hWords[j];
					if (target.isMarge) continue;
					if (main.hitTestObject(target)) this.margeH(main, target, j);
				}
			}
		}
		
		private function moveOword():void
		{
			var oLen:int = this._oWords.length;
			var hLen:int = this._hWords.length;
			for (var i:int = 0; i < oLen; i++ ) {
				var oWord:O = this._oWords[i];
				this.move(oWord);
				for (var j:int = 0; j < hLen; j++ ) {
					var hWord:H = this._hWords[j];
					if (!hWord.isMarge) continue;
					if (oWord.hitTestObject(hWord)) this.margeO(oWord,hWord,i,j);
				}
			}
		}
		
		private function move(obj:Object):void
		{
			var ra:Number = Math.random() * 4;
			var n:int = Math.ceil(Math.random() * 2);
			var sw:Number = this.stage.stageWidth;
			var sh:Number = this.stage.stageHeight;
			var ow:Number = obj.getWidth;
			var oh:Number = obj.getHeight;
			
			if(n%2){
				obj.x += Math.cos((obj.y + ra) / 15);
				obj.y += Math.cos((obj.x + ra) / 15);
			}else {
				obj.x += Math.sin((obj.y + ra) / 15);
				obj.y += Math.sin((obj.x + ra) / 15);
			}
			
			if (obj.x  > sw + ow/2) obj.x = -(ow/2);
			else if ((obj.x + ow) < 0) obj.x = sw + ow/2;
			else if (obj.y  > sh + oh/2) obj.y = -(oh/2);
			else if ((obj.y + oh) < 0) obj.y = sh + oh/2;
		}
		
		private function margeH(main:H, target:H, key:int):void
		{
			main.isMarge = true;
			main.textH = MARGE_AFTER_WORD;
			main.setFont();
			this._hWords.splice(key, 1);
			this._hWords.push(this.drowHWord());
			this.clear(target);
		}
		
		private function margeO(main:O,target:H,mKey:int,tKey:int):void
		{
			this._oWords.splice(mKey, 1);
			this._oWords.push(this.drowOWord());
			this.clear(main);
			this._hWords.splice(tKey, 1);
			this._hWords.push(this.drowHWord());
			this.clear(target);
			this._h2Os.push(this.drowH2o(target.x, target.y));
		}
		
		private function clear(obj:Object):void
		{
			obj.clear();
			this.removeChild(obj as DisplayObject);
			obj = null;
		}
		
		private function drowHWord():H
		{
			var h:H = new H();
			h.x = Math.random() * this.stage.stageWidth;
			h.y = Math.random() * this.stage.stageHeight;
			this.addChild(h);
			return h;
		}
		
		private function drowOWord():O
		{
			var o:O = new O();
			o.x = Math.random() * this.stage.stageWidth;
			o.y = Math.random() * this.stage.stageHeight;
			this.addChild(o);
			return o;
		}
		
		private function drowH2o(_x:Number, _y:Number):H2o
		{
			var h2o:H2o = new H2o();
			h2o.x = _x;
			h2o.y = _y;
			this.addChild(h2o);
			return h2o;
		}
	}
}

import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.text.TextField;
import flash.text.TextFormat;

class Word extends Sprite
{
	protected const H_WORD:String = "H";
	protected const O_WORD:String = "O";
	protected const FONT_SIZE:int = 20;
	protected const FONT_SIZE_2:int = 15;
	protected var _t:TextField = new TextField();
	protected var _tf:TextFormat = new TextFormat();
	
	public function Word()
	{
		this.drow();
	}
	
	protected function drow():Object
	{
		return this;
	}
	
	public function setFont():void
	{
		var filter:DropShadowFilter = new DropShadowFilter(4,45,0,0.3);
		this._tf.size = FONT_SIZE;
		this._tf.color = 0xffffff * Math.random();
		this._tf.bold = true;
		this._tf.font = "Arial";
		this._t.setTextFormat(this._tf);
		this._t.width = this._t.textWidth + 4;
		this._t.height = this._t.textHeight;
		this._t.filters = [filter];
		this._t.selectable = false;
	}
	
	public function get getWidth():Number
	{
		return this._t.width;
	}
	
	public function get getHeight():Number
	{
		return this._t.height;
	}
	
	public function clear():void
	{
		this.removeChild(this._t);
		this._t = null;
		this._tf = null;
	}
}

class H extends Word
{
	private var _isMarge:Boolean;
	
	override protected function drow():Object
	{	
		this._t.text = H_WORD;
		this.setFont();
		this.addChild(this._t);
		return this;
	}
	
	override public function setFont():void
	{
		super.setFont();
		if (this._t.getLineLength(0) > 1) this.setFont2();
	}
	
	private function setFont2():void {
		this._tf.size = FONT_SIZE_2;
		this._t.setTextFormat(this._tf, 1);
	}
	
	public function set textH(value:String):void
	{
		this._t.text = value;
	}
	
	public function set isMarge(value:Boolean):void
	{
		this._isMarge = value;
	}
	
	public function get isMarge():Boolean
	{
		return this._isMarge;
	}
}

class O extends Word
{
	override protected function drow():Object
	{
		this._t.text = O_WORD;
		this.setFont();
		this.addChild(this._t);
		return this;
	}
}

class H2o extends Word
{
	private var _deleteFlag:Boolean = false;
	private var _h2o:Sprite;
	
	override protected function drow():Object
	{
		var filter:DropShadowFilter = new DropShadowFilter(4,270,0x007fff,0.8);
		this._h2o = new Sprite();
		this._h2o.graphics.beginFill(0x007fff, 0.6);
		this._h2o.graphics.drawCircle(0, 0, (Math.random()*5)+7);
		this._h2o.graphics.endFill();
		this.addChild(this._h2o);
		this._h2o.filters = [filter];
		return this;
	}
	
	public function set deleteFlag(value:Boolean):void
	{
		this._deleteFlag = value;
	}
	
	public function get deleteFlag():Boolean
	{
		return this._deleteFlag;
	}
	
	override public function clear():void
	{
		this._h2o.graphics.clear();
		this.removeChild(this._h2o);
		this._h2o = null;
	}	
}