/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dvwK
 */

/*
Matrix3D.transformVectors();
と同じ機能の関数を作ってみる。
MAC 10,0,2,54,MAC 10,0,12,36で動作確認。

処理としては
transformVectorと同じ処理を連続して実行している。
ただし10,0,2,54の1/20のバグが無い点に注意。

実体行列.transformVectors(処理したい値のvector,処理済値のvector)

返り値ではなく、処理済値を入れるvectorをあらかじめ用意しておくのが面白い。

entity.transformVectors(vin,vin);
でも、ちゃんと値を受け取るので、一度tempに納めてから、
voutに入れ直す。


各要素をrandomで値を入れて、transformVectorsし、
行列の各要素を比較して確認とした。

Matrix3D.transformVectors()
http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/flash/geom/Matrix3D.html#transformVectors()
*/
package {
	import flash.display.Sprite;
	import flash.geom.Matrix3D;
	import flash.geom.Orientation3D;
	import flash.text.TextField;
	import flash.geom.Vector3D;
	import flash.system.Capabilities;
	public class FlashTest extends Sprite {
		public function FlashTest() {
			var txt:String="◆同機能関数Mtrx3D.transformVectors　"+Capabilities.version+"での実行結果\n\n";
			
			//確認用の値を用意
			var entity:Matrix3D=new Matrix3D(Util.random16());
			var vin:Vector.<Number> = new Vector.<Number>(15,true);
			for (var i:int=0; i<15; i++) {
				vin[i] = Math.random()*200-100;
			}
			var vout1:Vector.<Number> = new Vector.<Number>();
			var vout2:Vector.<Number> = new Vector.<Number>();
			
			
			//実行
			entity.transformVectors(vin,vout1);
			Mtrx3D.transformVectors(entity,vin,vout2);
			
			
			//確認
			txt+="↓Matrix3D.transformVectorsの結果\n"+vout1+"\n";
			txt+="\n↓同機能関数Mtrx3D.transformVectorsの結果\n"+vout2+"\n\n";
			txt+=Util.hikaku(vout1,vout2);
			
			//テキストフィールドを作りtxtを流し込み。
			var tf:TextField = new TextField();
			tf.width=stage.stageWidth;
			tf.height=stage.stageHeight;
			tf.wordWrap=true;
			stage.addChild(tf);
			tf.text=txt;
		}
	}
}
import flash.display.Sprite;
class Mtrx3D extends Sprite {
	import flash.geom.Matrix3D;
	import flash.geom.Vector3D;
	import flash.system.Capabilities;
	public static function transformVectors(entity:Matrix3D,vin:Vector.<Number>,vout:Vector.<Number>):void{
		var e:Vector.<Number> = Vector.<Number>(entity.rawData);
		var _n:int=vin.length;
		var temp:Vector.<Number> = new Vector.<Number>(_n,true);
		for (var i:int=0; i<_n; i+=3) {
			temp[i] = e[0]*vin[i]+e[4]*vin[i+1]+e[8]*vin[i+2]+e[12];
			temp[i+1] = e[1]*vin[i]+e[5]*vin[i+1]+e[9]*vin[i+2]+e[13];
			temp[i+2] = e[2]*vin[i]+e[6]*vin[i+1]+e[10]*vin[i+2]+e[14];
		}
		for (var j:int=0; j<_n; j++) {
			vout[j] = temp[j];
		}
	}
}
class Util {
	import flash.geom.Matrix3D;
	import flash.geom.Vector3D;
	public static function hikaku(v0:Vector.<Number>,v1:Vector.<Number>):String {
		var _str:String="↓二つのVector.<Number>の要素毎の差\n";
		var _n:int=v0.length;
		for (var i:int=0; i<_n; i++) {
			_str += "["+i+"]:"+(v0[i]-v1[i])+"\n";
		}
		return _str;
	}
	public static function hikaku2(v0:Vector3D,v1:Vector3D):String {
		var _str:String="↓二つのVector3Dの要素毎の差\n";
		_str += ".x:"+(v0.x-v1.x)+"\n";
		_str += ".y:"+(v0.y-v1.y)+"\n";
		_str += ".z:"+(v0.z-v1.z)+"\n";
		_str += ".w:"+(v0.w-v1.w)+"\n";
		return _str;
	}

	public static function random16():Vector.<Number> {
		var _v:Vector.<Number>=new Vector.<Number>(16,true);
		for (var i:int=0; i<16; i++) {
			_v[i]=Math.random()*200-100;
		}
		return _v;
	}
	public static function random9():Vector.<Number> {
		var _mt:Matrix3D = new Matrix3D();
		var v:Vector.<Vector3D>=new Vector.<Vector3D>  ;
		v[0]=new Vector3D(200*Math.random()-100,200*Math.random()-100,200*Math.random()-100);//平行移動、
		v[1]=new Vector3D(10*Math.random()-5,10*Math.random()-5,10*Math.random()-5);//回転
		v[2]=new Vector3D(100*Math.random(),100*Math.random(),100*Math.random());//拡大 / 縮小
		_mt.recompose(v);
		return _mt.rawData;
	}
}