/**
 * Copyright ushisantoasobu ( http://wonderfl.net/user/ushisantoasobu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dvqg
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    public class BallFollwingMouse extends Sprite {
        private var ballCount:uint = 50;
    		private var speed:Number =0.2; 
        public function BallFolowingMouse() {
            for(var i:uint = 0; i < ballCount; i++){
            	addChild(new Ball(this, 200));
        		}
        		addEventListener(Event.ENTER_FRAME, followMouse);
    		}
    		private function followMouse(eventObject:Event):void{
    			dispatchEvent(new BallEvent(BallEvent.FOLLOW, mouseX, mouseY, speed));
    		}
    }
}

import flash.display.Sprite;
import flash.display.Graphics;
import flash.events.Event;
class Ball extends Sprite{
	 private const deceleration:Number = 0.2;
	 private var angle:Number;
	 private var radius:Number;
	 private var sizeRate:Number = 0.1;
	 public function Ball(timeLine:Sprite, maxRadius:Number){
	 	var randomRate:Number = Math.random();
	 	angle = 2 * Math.PI * Math.random();
	 	radius = maxRadius * randomRate;
	 	createBall(randomRate);
	 	timeLine.addEventListener(BallEvent.FOLLOW, follow);
	 }
	 private function createBall(randomRate:Number):void{
	 	var myGraphics:Graphics = graphics;
	 	myGraphics.beginFill(Math.floor(0xFFFFFF * randomRate)+1);
	 	myGraphics.drawCircle(0, 0, radius + sizeRate);
	 	alpha = 1 - randomRate;
	 }
	 private function follow(eventObject:BallEvent):void{
	 	var randomRate:Number = Math.random();
	 	angle += eventObject.speed;
	 	angle %= Math.PI*2;
	 	var nX:Number=eventObject.targetX+radius*Math.cos(angle);
	 	var nY:Number=eventObject.targetY+radius*Math.sin(angle);
	 	x += (nX - x) * deceleration * randomRate;
	 	y += (nY - y) * deceleration * randomRate;
	 }
}
class BallEvent extends Event{
	public static const FOLLOW:String = "follow";
	private var _targetX:Number;
	private var _targetY:Number;
	private var _speed:Number;
	public function get targetX():Number{
		return _targetX;
	}
	public function get targetY():Number{
		return _targetY;
	}
	public function get speed():Number{
		return _speed;
	}
	public function BallEvent(event_str:String, myTargetX:Number, myTargetY:Number, mySpeed:Number){
		super(event_str);
		_targetX = myTargetX;
		_targetY = myTargetY;
		_speed = mySpeed;
	}
	public override function clone():Event {
		return new BallEvent(type, targetX, targetY, speed);
	}
	public override function toString():String {
		return formatToString("BallEvent", "type", "bubbles", "cancelable", "eventPhase", "targetX", "targetY", "speed");
	}
}

