/**
 * Copyright majoraze ( http://wonderfl.net/user/majoraze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/duUS
 */

// forked from majoraze's flash on 2010-11-21
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    
    public class Velocity extends Sprite {
        private var ball:Ball;
        private var vx:Number = 0;
        private var ax:Number = 0;
        private var vy:Number = 0;
        private var ay:Number = 0;
        private var gravity:Number = .1;
        
        public function Velocity() {
            init();
        }
        
        private function init():void {
            ball = new Ball();
            addChild(ball);
            ball.x = stage.stageWidth/2;
            ball.y = stage.stageHeight/2;
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
        }
        
        private function onKeyDown(e:KeyboardEvent):void {
            switch(e.keyCode) {
                case Keyboard.LEFT:
                    ax = -.2;
                break;
                case Keyboard.RIGHT:
                    ax = .2;
                break;
                case Keyboard.UP:
                    ay = -.2;
                break;
                case Keyboard.DOWN:
                    ay = .2;
                break; 
            }
        }
        
        private function onKeyUp(e:KeyboardEvent):void {
            ax = 0;
            ay = 0;
        }
        
        private function onEnterFrame(e:Event):void {
            vx += ax;
            vy += ay;
            vy += gravity;
            ball.x += vx;
            ball.y += vy;
            
        }
    }
}


import flash.display.Sprite;

class Ball extends Sprite {
    private var radius:Number;
    private var color:uint;
    
    public function Ball(radius:Number = 40, color:uint = 0xff0000) {
        this.radius = radius;
        this.color = color;
        
        init();
    }
    
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0,0,radius);
        graphics.endFill()
    }
}