/**
 * Copyright itsDcTurner ( http://wonderfl.net/user/itsDcTurner )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/duQG
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import gs.*;
    
    [SWF(backgroundColor="#FFFFFF", frameRate=60)]
    public class FlashTest extends Sprite {
    	public static const totalParticles:int =300;
    	public var particlePool:Array = [];
    	public static const colourPool:Array = [0xff0000, 0x00ff00, 0x0000ff, 0xFFFF00, 0x00FFFF, 0xFF00FF];
    		
    		public var c:Sprite; // container
    		public var pool:Array = [];
    		public var wind:Number = 0;
    		public var maxWind:Number = 2;
    		
        public function FlashTest() {
            // write as3 code here..
            OverwriteManager.init(OverwriteManager.AUTO);
            c = new Sprite();
            addChild(c);
            c.graphics.beginFill(0x222222);
            c.graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
            stage.quality = "MEDIUM";
            c.addEventListener(Event.ENTER_FRAME, render);
            generateParticles(totalParticles);
        }
        
        private function generateParticles($total:int):void{
        		for(var i:int=$total ; i>=0 ; i--){
        			var p:Particle = new Particle(colourPool[Math.round(Math.random()*colourPool.length)],i*.01, .2+Math.random()*.8);
        			c.addChild(p);
        			p.x = Math.random()*stage.stageWidth;
        			p.y = Math.random()*stage.stageHeight;
        			p.addEventListener(Event.COMPLETE, refreshParticle);
        			particlePool.push(p);
        		}
        }
        
        private function refreshParticle(e:Event):void{
        		var p:Particle = e.target as Particle;
        		c.removeChild(p);
        		p.x = Math.random()*stage.stageWidth;
        		p.y = Math.random()*stage.stageWidth;
        		c.addChild(p);
        }
        
        private function render(e:Event):void{
        		setWind();
        		for(var i:int=totalParticles ; i>=0 ; i--){
        			var p:Particle = particlePool[i] as Particle;
        			p.w = wind;
        		}
        }
        private function setWind():void{
			wind += Math.random()*1-.5;
			if (wind<-maxWind)wind = -maxWind;
			else if (wind>maxWind)wind = maxWind;    	
        }
    }
}


{
import flash.display.Sprite;
import flash.events.Event;
import gs.*;
import gs.easing.*;
	class Particle extends Sprite{
		public var a:Number = 0; // acceleration
		public var c:uint;	// colour
		public var d:Number; // delay
		public var w:Number = 0; // wind
		public var weight:Number;
 		public function Particle($colour:uint, $delay:Number, $weight:Number){
 			addEventListener(Event.ADDED_TO_STAGE, init);
 			c = $colour;
 			d = $delay
 			weight = $weight;
 			alpha=0;
 			a=0;
 			graphics.beginFill(c);
 			graphics.drawCircle(-.5,-.5,1);
 			graphics.endFill();
		}
		private function init(e:Event):void{
			removeEventListener(Event.ENTER_FRAME, init);
			a=0;
			alpha=0;
			TweenLite.killTweensOf(this);
 			TweenLite.to(this, 2+Math.random()*2,{alpha:.8, delay:d});
 			
 			addEventListener(Event.ENTER_FRAME, render);
		}
		private function render(e:Event):void{
			a+=.1;
			y+=a;
			x +=w*weight;
			
			if(y>stage.stageHeight){
				removeEventListener(Event.ENTER_FRAME, render);
				dispatchEvent(new Event(Event.COMPLETE));
			}
			if (x<0) x = stage.stageWidth;
			if (x>stage.stageWidth)x = 0;
		}
	}
}