/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/duDb
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    public class FlashTest extends Sprite {
        
        /*
        DisplayObject   ・・・画面に表示できるクラス。Sprite, TextField は全て DisplayObject
        Display List    ・・・表示の重ね順、入れ子関係、親子関係。(DisplayListというクラスがある訳ではない)
        
        DisplayObject を Display List 上に配置することで
        
        */
        
        
        //変数----------------------------
        
        private var myText :TextField;
        
        private var oya :Sprite;
        private var ko :Sprite;
        private var mago :Sprite;
        
        
        //コンストラクタ--------------------
        
        public function FlashTest() {
            initOutput();
            
            //親作成
            oya = makeSprite(0x999999, 50);
            oya.x = 200;
            oya.y = 200;
            //子作成
            ko = makeSprite(0x990000, 30);
            ko.x = 100;
            ko.y = 0;
            //孫作成
            mago = makeSprite(0x000099, 20);
            mago.x = 50;
            mago.y = 0;
            
            //DisplayList上に配置
            addChild(oya);
            oya.addChild(ko);
            ko.addChild(mago);
            
            //動作開始
            addEventListener(Event.ENTER_FRAME, update);
            //動作変更
            addEventListener(MouseEvent.CLICK, change);
        }
        
        //ハンドラ--------------------------
        
        private function update(event:Event) :void{
            oya.rotation = oya.rotation + 2;
            ko.rotation = ko.rotation + 2;
            mago.rotation = mago.rotation + 2;
        }
        private function change(event :Event) :void{    //MouseEventクラス は Eventクラス の一種(サブクラス)なので、パラメータのクラス名は Event でも合っている。
            if(ko.parent == oya){
                oya.removeChild(ko);
                ko.removeChild(mago);
                oya.addChild(mago);
                mago.addChild(ko);
                output("親-孫-子");
            }else{
                oya.removeChild(mago);
                mago.removeChild(ko);
                oya.addChild(ko);
                ko.addChild(mago);
                output("親-子-孫");
            }
        }

        
        
        //その他メソッド--------------------
        
        private function makeSprite(color :uint, size :Number) :Sprite{
            var sp :Sprite = new Sprite();
            var gra :Graphics = sp.graphics;
            gra.beginFill(color);
            gra.drawRect(size / -2, size / -2, size, size);
            gra.endFill();
            return sp;
        }

        private function initOutput() :void{
            myText = new TextField();
            myText.width = 400;
            myText.height = 40;
            myText.background = true;
            myText.border = true;
            addChild(myText);
        }
        private function output(obj :Object) :void{
            myText.text = obj.toString();
        }


    }
}