/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/du3P
 */

// forked from _wonder's 回転方法（2）
// forked from _wonder's 回転方法（1）
// forked from _wonder's base
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class Rotate extends Sprite {
    		private var balls:Array;
    		private var numBalls:uint = 10;
    		private var vr:Number = 0.05;
    		
    		public function Rotate() {
            init();
        }
        
        private function init():void {
        		balls = new Array();
        		for( var i:uint = 0; i < numBalls; i++ ){
        			var ball:Ball = new Ball();
        			balls.push( ball );
        			addChild( ball );
        			ball.x = Math.random() * stage.stageWidth;
        			ball.y = Math.random() * stage.stageHeight;
        		}
        		addEventListener(Event.ENTER_FRAME,onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void{
        		var angle:Number = ( mouseX - stage.stageWidth / 2 ) * 0.01;
        		var cos:Number = Math.cos( angle );
        		var sin:Number = Math.sin( angle );
        		
        		for( var i:uint = 0; i < numBalls; i++ ){
        			var ball:Ball = balls[i];
        			var x1:Number = ball.x - stage.stageWidth / 2;
        			var y1:Number = ball.y - stage.stageHeight / 2;
        			var x2:Number = cos * x1 - sin * y1;
        			var y2:Number = cos * y1 + sin * x1;
        			ball.x = stage.stageWidth / 2 + x2;
        			ball.y = stage.stageHeight / 2 + y2;
        		}
        }
    }
}

import flash.display.Sprite;

class Ball extends Sprite {
	public var radius:Number;
	public var color:uint;
	
	public function Ball(radius:Number=40, color:uint=0Xff0000){
		this.radius = radius;
		this.color = color;
		init();
	}
	
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}