/**
 * Copyright tjoen ( http://wonderfl.net/user/tjoen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dtPx
 */

// forked from bradsedito's forked from: tree
// forked from nipx's tree
package{
    
    import frocessing.display.F5MovieClip2DBmp;
    import frocessing.math.FMath;
    
    [SWF(backgroundColor="#FFFFFF", frameRate="20", width="465", height="465")]
    public class FlashTest extends F5MovieClip2DBmp{
        
        
        private var where:Number;
        private var dotSize:Number = 6;
        private var angleOffsetA:Number;
        private var angleOffsetB:Number;
        private var funcs:Vector.<SeedCommand>;
        
        
        public function setup():void{
            size( 465, 465 );
            noStroke();
            fill( 0 );
            smooth();
            angleOffsetA    = FMath.radians( 2.3 );
            angleOffsetB    = FMath.radians( 45 );
            funcs    = new <SeedCommand>[];
            where = random (width, width/4);
        }
        
        
        public function draw():void{
            translate(  where, height );
            if( funcs.length == 0 ){
                background( 255 );
                funcs = seed1( dotSize, FMath.radians( 270 ), 0, 0 );
            }
            else{
                var temp:Vector.<SeedCommand> = new <SeedCommand>[];
                for each( var i:SeedCommand in funcs ){
                    temp = temp.concat( i.execute() );
                   
                }
                funcs = temp;
               
            }
        }
        
        
        private function seed1( dotSize:Number, angle:Number, x:Number, y:Number ):Vector.<SeedCommand>{
            var vector:Vector.<SeedCommand> = new <SeedCommand>[];
            if( dotSize > 1 ){
                rect(x, y, dotSize, dotSize*2 );
                //drawRect(x:Number, y:Number, width:Number, height:Number):
                
                var newx:Number;
                var newy:Number;
                if( random( 1 ) > 0.1 ){
                    newx = x + Math.cos( angle ) * dotSize;
                    newy = y + Math.sin( angle ) * dotSize;
                    vector.push( new SeedCommand( seed1, new <Number>[ dotSize * 0.99, angle - angleOffsetA, newx, newy ] ) );
                }
                else{
                    newx = x + Math.cos( angle );
                    newy = y + Math.sin( angle );
                    vector.push( new SeedCommand( seed2, new <Number>[ dotSize * 0.90, angle + angleOffsetA, newx, newy ] ) );
                    vector.push( new SeedCommand( seed1, new <Number>[ dotSize * 0.60, angle + angleOffsetB, newx, newy ] ) );
                    vector.push( new SeedCommand( seed2, new <Number>[ dotSize * 0.50, angle - angleOffsetB, newx, newy ] ) );
                }
            }
            
            return vector;
        }
        
        
        private function seed2( dotSize:Number, angle:Number, x:Number, y:Number ):Vector.<SeedCommand>{
            var vector:Vector.<SeedCommand> = new <SeedCommand>[];
            if ( dotSize > 1 ){
                rect(x, y, dotSize, dotSize*2 );
                //circle( x, y, dotSize/2 );
                var newx:Number;
                var newy:Number;
                if( random( 1 ) > 0.1 ){
                    newx = x + Math.cos( angle ) * dotSize;
                    newy = y + Math.sin( angle ) * dotSize;
                    vector.push( new SeedCommand( seed2, new <Number>[ dotSize * 0.99, angle + angleOffsetA, newx, newy ] ) );
                }
                else{
                    newx = x + Math.cos( angle );
                    newy = y + Math.sin( angle );
                    vector.push( new SeedCommand( seed1, new <Number>[ dotSize * 0.99, angle + angleOffsetA, newx, newy ] ) );
                    vector.push( new SeedCommand( seed2, new <Number>[ dotSize * 0.60, angle + angleOffsetB, newx, newy ] ) );
                    vector.push( new SeedCommand( seed1, new <Number>[ dotSize * 0.50, angle - angleOffsetB, newx, newy ] ) );
                }
            }
            return vector;
        }
        
        
    }
}



class SeedCommand{
    
    public function SeedCommand( func:Function, params:Vector.<Number> ){
        this.func    = func;
        this.params    = params;
    }
    
    private var func:Function;
    private var params:Vector.<Number>;
    
    public function execute():Vector.<SeedCommand>{
        return func( params[0], params[1], params[2], params[3] );
    }
    
}
