/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dt34
 */

// forked from djankey's 3D Flow Simulation (Stage3D, Starling)
// forked from clockmaker's BitmapDataで配列に格納すると高速化するよ
// forked from clockmaker's 3D Flow Simulation with Field of Blur
// forked from clockmaker's 3D Flow Simulation
// forked from clockmaker's Interactive Liquid 10000
// forked from clockmaker's Liquid110000 By Vector
// forked from munegon's forked from: forked from: forked from: forked from: Liquid10000
// forked from Saqoosha's forked from: forked from: forked from: Liquid10000
// forked from nutsu's forked from: forked from: Liquid10000
// forked from nutsu's forked from: Liquid10000
// forked from zin0086's Liquid10000


package{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.navigateToURL;
    import flash.net.URLRequest;
    import com.bit101.components.PushButton;
    
    public class Main extends Sprite {
        
        public function Main(){
            var linkButton:PushButton = new PushButton(this, 50, 150, "OPEN PREVIEW IN NEW WINDOW", btnClicked);
            linkButton.width = 365;            
        }
         
        private function btnClicked(e:MouseEvent):void
       {
           var targetURL:URLRequest = new URLRequest("http://www.as-flash.com/test/starling3dflow/");
           navigateToURL(targetURL, "_blank");    
       }
 
    }

}



// -------------------------------- REAL CODE ------------------------------------
/*
package
{
    import flash.display.Sprite;    
    import flash.display.Stage;    
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import net.hires.debug.Stats;
    import starling.core.Starling;
    
    [SWF(frameRate="60")]
    public class Main extends flash.display.Sprite
    {
        private var myStarling:Starling;
        
        public function Main()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event:Event=null):void
        {
            // support autoOrients
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;          
            
            myStarling = new Starling(Content, stage);
            
            // set anti-aliasing
            myStarling.antiAliasing = 1;
        
            // start
            myStarling.start();
            
            // stats
            addChild (new Stats());
        }
            
            
    }
}

import starling.display.Sprite;
import starling.display.Image;
import starling.events.Event;
import starling.textures.Texture;
import starling.textures.TextureSmoothing;
import starling.utils.deg2rad;

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shape;
import flash.events.TimerEvent;
import flash.utils.Timer;
import flash.geom.Point;

class Content extends starling.display.Sprite
{
    private const NUM_PARTICLE:uint = 4000;        
    private var forceMap:BitmapData;
    private var randomSeed:uint = Math.floor( Math.random() * 0xFFFF );
    private var particleList:Vector.<Arrow> = new Vector.<Arrow>(NUM_PARTICLE, true);
    private var seed:Number = Math.floor( Math.random() * 0xFFFF );
    private var offset:Array = [new Point(), new Point()];
    private var timer:Timer;    
    private var _W:int;
    private var _H:int;
    
    public function Content()
    {
        addEventListener(Event.ADDED_TO_STAGE, onAdded);
    }
    
    private function onAdded ( e:Event ):void
    {        
        // setup sizes
        _W = stage.stageWidth;
        _H = stage.stageHeight;
        forceMap = new BitmapData(_W/2 + 1, _H/2 + 1, false, 0x000000);
        
        // timer
        var timer:Timer = new Timer(1000)
        timer.addEventListener(TimerEvent.TIMER, resetFunc);
        timer.start();
        
        // draw arrow
        var dummy:Shape = new Shape();
        dummy.graphics.beginFill(0xFFFFFF, 1);
        dummy.graphics.lineStyle(1, 0x0, 1);
        dummy.graphics.moveTo(2, 4);
        dummy.graphics.lineTo(8, 4);
        dummy.graphics.lineTo(8, 0);
        dummy.graphics.lineTo(20, 7);
        dummy.graphics.lineTo(8, 14);
        dummy.graphics.lineTo(8, 10);
        dummy.graphics.lineTo(2, 10);
        dummy.graphics.lineTo(2, 4);
        
        // create texture
        var bd:BitmapData = new BitmapData(dummy.width, dummy.height, true, 0x00000000);    
        bd.draw(dummy);
        var texture:Texture = Texture.fromBitmap(new Bitmap(bd, "auto", true));
        
        var pivot_x:int = dummy.width >> 1;
        var pivot_y:int = dummy.height >> 1;
        var px:Number;
        var py:Number;
        var delta:int;
        
        for (var i:int = 0; i < NUM_PARTICLE; i++)
        {
            px = Math.random() * _W;
            py = Math.random() * _H;
            
            // create a Image object with one texture
            var arrow:Arrow = new Arrow(texture, px, py);
            
            //arrow.pivotX = pivot_x;
            //arrow.pivotY = pivot_y;
            //arrow.smoothing = TextureSmoothing.NONE;    
            //arrow.color = Math.random()*0xFFFFFF;        
            
            particleList[i] = arrow;
            addChild(arrow);
        }    
        
        // main loop
        stage.addEventListener(Event.ENTER_FRAME, onFrame);    
        
        resetFunc();
    }
    
    private function onFrame(event:Event):void
    {
        var col:Number;
        
        for (var i:uint = 0; i < NUM_PARTICLE; i++) {
            
            var arrow:Arrow = particleList[i];
            
            var oldX:Number = arrow.x;
            var oldY:Number = arrow.y;
            
            col = forceMap.getPixel( arrow.x >> 1, arrow.y >> 1);
            arrow.ax += ( (col & 0xff) - 0x80 ) * .0005;
            arrow.ay += ( (col >> 8 & 0xff) - 0x80 ) * .0005;
            arrow.vx += arrow.ax;
            arrow.vy += arrow.ay;
            arrow.x += arrow.vx;
            arrow.y += arrow.vy;
            
            var _posX:Number = arrow.x;
            var _posY:Number = arrow.y;
            
            var rot:Number = - Math.atan2((_posX - oldX), (_posY - oldY)) * 180 / Math.PI + 90;
            var angle:int = rot | 0;
            
            // Math.absの高速化ね
            angle = (angle ^ (angle >> 31)) - (angle >> 31);
            arrow.rot += (angle - arrow.rot) * 0.2;
            arrow.rotation = deg2rad(arrow.rot);
            
            arrow.ax *= .96;
            arrow.ay *= .96;
            arrow.vx *= .92;
            arrow.vy *= .92;
            
            // あと配置座標を整数化しておきます
            arrow.x = arrow.x | 0;
            arrow.y = arrow.y | 0;
            
            ( _posX > _W ) ? arrow.x = 0 :
                ( _posX < 0 ) ? arrow.x = _W : 0;
            ( _posY > _H ) ? arrow.y = 0 :
                ( _posY < 0 ) ? arrow.y = _H : 0;
        }
    }
    
    private function resetFunc(e:TimerEvent = null):void
    {            
        forceMap.perlinNoise(_W/4 + 1, _H/4 + 1, 3, seed, false, true, 6, false, offset);
        offset[0].x += 1.5;
        offset[1].y += 1;
        seed = Math.floor( Math.random() * 0xFFFFFF );            
    }
}



import starling.display.Image;
import starling.textures.Texture;

class Arrow extends starling.display.Image
{
    public var rot:int = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var ax:Number = 0;
    public var ay:Number = 0;
    
    public function Arrow(texture:Texture, x:Number, y:Number)
    {
        super(texture);
        
        this.x = x;
        this.y = y;
    }
}
*/