/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dsaR
 */

package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.GradientType;
    import flash.filters.GlowFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    public class FlashTest extends Sprite {
        private var star:Sprite;
        private var bmp1:Bitmap;
        private var bmpd1:BitmapData;
        private var bmp2:Bitmap;
        private var bmpd2:BitmapData;
        
        public function FlashTest() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            star = new Star(50);
            
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(100, 100, 0, -50, -50);
            var circle:Sprite = new Sprite();
            circle.graphics.beginGradientFill(GradientType.RADIAL, [0, 0], [1, 0], [0, 255], matrix);
            circle.graphics.drawCircle(0, 0, 50);
            circle.graphics.endFill();
            
            bmpd1 = new BitmapData(100, 100, true, 0);
            bmpd1.draw(star, new Matrix(1, 0, 0, 1, 50, 50));
            bmp1 = new Bitmap(bmpd1);
            bmp1.x = bmp1.y = 200;
            addChild(bmp1);
            
            bmpd2 = new BitmapData(100, 100, true, 0);
            bmpd2.draw(circle, new Matrix(1, 0, 0, 1, 50, 50));
            bmp2 = new Bitmap(bmpd2);
            addChild(bmp2);
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
        }
        
        public function mouseMoveHandler(e:MouseEvent):void
        {
            bmp2.x = mouseX - 50;
            bmp2.y = mouseY - 50;
            
            if(bmpd1.hitTest(new Point(bmp1.x, bmp1.y), 255, bmp2, new Point(bmp2.x, bmp2.y), 125))
            {
                bmp1.filters = [new GlowFilter()];
                bmp2.filters = [new GlowFilter()];
                
            }
            else
            {
                bmp1.filters = [];
                bmp2.filters = [];
            }


        }

        public function onEnterFrameHandler(e:Event):void
        {
            
        }

    }
}


import flash.display.Sprite;

class Star extends Sprite
{
    public function Star(radius:Number, color:uint = 0xFFFF00):void
    {
        graphics.lineStyle(0);
        graphics.moveTo(radius, 0);
        
        graphics.beginFill(color);
        
        for(var i:int = 0;i < 11;i++)
        {
            var radius2:Number = radius;
            if(i % 2 > 0)
            {
                radius2 = radius / 2;
            }
            var angle:Number = Math.PI * 2 / 10 * i;
            graphics.lineTo(Math.cos(angle) * radius2, Math.sin(angle) * radius2);
        }

    }

    
}
