/**
 * Copyright Mr.Star ( http://wonderfl.net/user/Mr.Star )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dsaE
 */

package {
    import flash.display.Shape;
    import flash.display.Sprite;

    public class DrawTreeSample extends Sprite {
        private var sp:Shape;
        public function DrawTreeSample() {
            sp = new Shape();
            addChild(sp);
            DrawTree(250, 360, 120, 90, 6);//DrawTree
        }

        private function drawt(ax:Number, ay:Number, bx:Number, by:Number):void {
            sp.graphics.moveTo(ax, ay);
            sp.graphics.lineStyle(0, 0x000000, 1);
            sp.graphics.lineTo(bx, by);
        }
        //DrawTree Function
        private function DrawTree(x:Number, y:Number, l:Number, angle:Number, n:Number):void {
            if (n>0) {
                var x1:Number = x+0.5*l*Math.cos(angle*Math.PI/180);
                var y1:Number = y-0.5*l*Math.sin(angle*Math.PI/180);
                var x2:Number = x+l*Math.cos(angle*Math.PI/180);
                var y2:Number = y-l*Math.sin(angle*Math.PI/180);
                drawt(x, y, x2, y2);
                var a_l:Number = angle+30;
                var a_r:Number = angle-30;
                l = l*2/3;
                DrawTree(x2, y2, l, angle-Math.round(Math.random()*10), n-1);
                DrawTree(x1, y1, l*2/3, a_l, n-1);
                DrawTree(x1, y1, l*2/3, a_r, n-1);
                DrawTree(x2, y2, l*2/3, a_l, n-1);
                DrawTree(x2, y2, l*2/3, a_r, n-1);
            }
        }
    }
}