/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dsFE
 */

// forked from ninehundred's PV3D 2.0 / マ○オ編1日目(マ○オを走らせてみる)
//////////////////////////////////////////////////////////////////////////////////////////
//
//  [ PV3D 2.0 / マ○オ編1日目(マ○オを走らせてみる) ]
//
//  今回のテーマ
//  - flickrから画像をloadして色と座標の情報を取得
//  - その情報をもとにCubeを用いて立体におこす
//  - 現時点ではsceneを複数用意して切り替えをしているが
//  - 使い方は間違ってるような気がする。。。
//  - 
//  - 次の目標：構造を再度、見直しクリックでJUMPできるようにする
//
//////////////////////////////////////////////////////////////////////////////////////////

package
{
    // # imports
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.*;
    /*import flash.errors.*;
    import flash.external.*;
    import flash.filters.*;
    import flash.media.*;
    import flash.ui.*;
    import flash.utils.*;*/

    import com.flashdynamix.motion.*;
    import com.flashdynamix.utils.*;
    import fl.motion.easing.*;

    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.cameras.*;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.MaterialsList;

    import net.hires.debug.Stats;

    [SWF(width="465", height="465", backgroundColor="0x0", frameRate="60")]

    public class App extends Sprite
    {

        // ================================================== //
        // STEP00 - Constructor & Parameters
        // ================================================== //
        private var mario001        :String = 'http://farm4.static.flickr.com/3538/3849422504_4d982b3977.jpg';
        private var mario002        :String = 'http://farm3.static.flickr.com/2460/3849422530_d4a72f94d3.jpg';
        private var mario003        :String = 'http://farm3.static.flickr.com/2603/3849422602_f497dd4644.jpg';
        private var mario004        :String = 'http://farm4.static.flickr.com/3487/3849422666_8029ea7483.jpg';

        private var _loadList        :Array = [];
        private var _loader            :Loader;
        private var _loadCnt        :int = 0;

        private const EarthSize:int = 2000;
        private const CubeSize:int  = 20;

        private var _scene:Scene3D;
        private var _camera:Camera3D;
        private var _viewport:Viewport3D;
        private var _renderer:BasicRenderEngine;

        private var _infoText        :TextField;
        private var _marioList        :Array = [];
        private var _goombaList        :Array = [];
        private var _materialList    :Array = [];


        public function App()
        {
            if(stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event=null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            _loadList = [ mario001 , mario002, mario003, mario004 ];// ループ処理用のURLをまとめる
            initStage();    // ステージの初期化
            loadPhotos();    // 画像の読込み開始
                        Wonderfl.capture_delay( 15 );
        }





        // ================================================== //
        // STEP01 - 画像の読込みと各種情報の抜き出し
        // ================================================== //
        
        private function loadPhotos():void
        {
            var req:String = _loadList[_loadCnt]+'?date='+new Date();
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadedPhotos);
            _loader.load(new URLRequest(req), new LoaderContext(true));
        }
        
        private function loadedPhotos(e:Event=null):void
        {
            /*// 確認用
            var bmp:Bitmap = addChildAt(e.target.content, 0) as Bitmap;
            bmp.x = bmp.width * _loadCnt;//*/
            var myParams:Array = getMyParameter(e.target.content);// 読込んだ画像から色データと座標を抽出
            _loadCnt < 3 ? _marioList.push(myParams) : _goombaList.push(myParams);// ここでマリオとクリボー専用配列に仕分け
            
            _loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, loadedPhotos);
            _loader = null;

            ++_loadCnt;
            if(_loadCnt == _loadList.length)
            {
                _loadList = null;
                initPV3D();        // 画像の読込み終了 → 次の工程へ
            }
            else
            {
                loadPhotos();    // 必要な画像分ループ処理
            }
        }

        private function getMyParameter(bmp:Bitmap):Array
        {
            var list:Array = [];
            var bw:int = bmp.width;
            var bh:int = bmp.height;
            var col16:int, col8:int, col:int;
            var r:int, g:int, b:int;
            var pos:Point;
            for(var i:int=0; i<bh; i++)
            {
                for(var j:int=0; j<bw; j++)
                {
                    // なぜか色が劣化？するので色を近似色で揃える
                    col16 = bmp.bitmapData.getPixel(j, i);
                    r     = ((col16 >> 20)       << 4) | (col16 >> 20);
                    g     = ((col16 >> 12 & 0xF) << 4) | (col16 >> 12 & 0xF);
                    b     = ((col16 >>  4 & 0xF) << 4) | (col16 >>  4 & 0xF);
                    col8  = r << 16 | g << 8 | b;

                    if(col8.toString(16) != 'ffffff')
                    {
                        var obj:Object = {};
                        obj.pos        = new Point(bw-j, bh-i);
                        obj.col        = col8;
                        list.push(obj);// 0xFFFFFFは不要なのでそれ以外の色の場合のみ格納
                        obj = null;
                    }
                }
            }
            bmp = null;
            return list;
        }






        // ================================================== //
        // STEP01 - PV3Dの初期化
        // ================================================== //
        
        private function initPV3D():void
        {
            // 必須アイテムの初期化
            _renderer = new BasicRenderEngine();
            //_scene    = new Scene3D();
            _viewport = new Viewport3D(0, 0, true, true);
            addChild(_viewport);

            // カメラの初期化
            _camera        = new Camera3D();
            _camera.x      = 0;
            _camera.y      = 500;
            _camera.z      = 1000;
            _camera.target = DisplayObject3D.ZERO;

            initMaterial();            // マテリアルを設置
            stage.addEventListener(Event.ENTER_FRAME, update);
        }



        // ================================================== //
        // STEP03 - マテリアルを設置
        // ================================================== //

        private function initMaterial():void
        {
            var size:int   = CubeSize;
            var mt:ColorMaterial;
            var mtList:MaterialsList;
            
            for(var i:int=0; i<_marioList.length; i++)
            {
                var list:Array = _marioList[i];
                var _scene:Scene3D = new Scene3D(); 
                for(var j:int=0; j<list.length; j++)
                {
                    mt            = new ColorMaterial(list[j].col, 1);
                    mt.oneSide    = false;
                    mtList        = new MaterialsList({all:mt});
                    var cube:Cube = new Cube(mtList, size, size, size, 1, 1, 1);
                    cube.x        = list[j].pos.x * size - 16*size/2 - size/2;
                    cube.y        = list[j].pos.y * size - size/2;
                    cube.z        = 0;
                    _scene.addChild(cube);
                }
                var wire:WireframeMaterial = new WireframeMaterial(0x666666);
                wire.oneSide    = false;
                var earth:Plane = new Plane(wire, EarthSize, EarthSize, 8, 8);
                earth.rotationX = 90;
                _scene.addChild(earth);
                _sceneList.push(_scene);
            }
        }

        private function plusMinus():int
        {
            var p:int = Math.round(Math.random()) == 0 ? -1 : 1
            return p;
        }
        

        private var _sceneList:Array = [];
        private var _cnt:int = 0;

        // ================================================== //
        // STEP03 - Event
        // ================================================== //
        private function update(e:Event=null):void
        {
            if(++_cnt == _sceneList.length) _cnt = 0;
            var _scene:Scene3D = _sceneList[_cnt]
            _renderer.renderScene(_scene, _camera, _viewport);
        }



        // ================================================== //
        // STEP99 - Commons & Settings
        // ================================================== //
        private function initStage():void
        {
            stage.align                  = StageAlign.TOP_LEFT;
            stage.scaleMode              = StageScaleMode.NO_SCALE;
            stage.quality                = StageQuality.MEDIUM;
            stage.displayState           = StageDisplayState.NORMAL;
            stage.frameRate              = 10;
            stage.showDefaultContextMenu = false;
        }
    }
}
