/**
 * Copyright gaziya ( http://wonderfl.net/user/gaziya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dsDS
 */

// forked from gaziya's 遠近法のテスト2
package {
    import flash.geom.Matrix3D;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.display.Sprite;
    [SWF(width=465,height=465,frameRate=30)]
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            //transform.perspectiveProjection.focalLength = 200
            x = stage.stageWidth/2
            y = stage.stageHeight/2  
            var container:Sprite= new Sprite
            var points:Vector.<Vector3D> = new Vector.<Vector3D>
            var shapes:Vector.<Sprite> = new Vector.<Sprite>
            var radius:Number = 200    
            var rect_size:int = 30
            for (var i:int = 0; i <200; i++){
                var vector:Vector3D = new Vector3D                
                var vector_length:Number = Math.sqrt(Math.random())*radius
                var theta_x:Number = Math.random()*360
                var theta_y:Number = Math.random()*360
                var matrix:Matrix3D = new Matrix3D
                matrix.appendRotation(theta_x,Vector3D.X_AXIS)
                matrix.appendRotation(theta_y,Vector3D.Y_AXIS)
                vector.z = vector_length
                vector = matrix.transformVector(vector)
                points.push(vector)
                var rect:Shape = new Shape
                rect.graphics.beginFill(Math.round(Math.random()*0xffff)*0x100)                
                rect.graphics.drawRect(-rect_size/2, -rect_size/2,rect_size,rect_size)
                rect.z = vector.length
                shapes.push(new Sprite)
                shapes[i].addChild(rect)
                shapes[i].rotationX = theta_x
                shapes[i].rotationY = theta_y      
                container.addChild(shapes[i])
            }
            addChild(container)
               
            var theta:int = 0
            addEventListener(Event.ENTER_FRAME, loop)                                      
            function loop(e:Event):void {
                theta += Math.sqrt(Math.pow(mouseX,2)+Math.pow(mouseY,2))/40
                theta %= 360
                var tilt:Number = 180-Math.atan2(mouseX,mouseY)*20*Math.PI                
                var matrix:Matrix3D = new Matrix3D              
                matrix.appendRotation(theta,Vector3D.Y_AXIS)    
                matrix.appendRotation(tilt,Vector3D.Z_AXIS)                
                var sort_items:Array = new Array
                var i:int
                for (i=0; i<points.length; i++) {
                    var vector:Vector3D = matrix.transformVector(points[i])
                    vector.w = i
                    sort_items.push(vector)
                    container.removeChild(shapes[i])                    
                }
                sort_items.sortOn("z", Array.NUMERIC | Array.DESCENDING)
                for (i=0; i<points.length; i++) {
                    container.addChild(shapes[sort_items[i].w])
                }                                            
                container.rotationY = theta
                container.rotationZ = tilt                     
            }    
        }
    }
}
