/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/drMx
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    
    
    public class NoiseExperiment extends Sprite 
    {
        
        public function NoiseExperiment() 
        {
            test();
        }
        
        private function test():void
        {
            var bm:Bitmap;
            
            var a1:BitmapData = new BitmapData(100,100,false,0);
            var a2:BitmapData = a1.clone();
            addChild ( new Bitmap( a1 ) );
            addChild( new Bitmap(a2) ).x = 110;
           
            a1.noise( 0xcaffee, 0, 255, 7, false );
            a2.noise( 0xbada55, 0, 255, 7, false );
            
            var a3:BitmapData = a1.clone();
            a3.draw( a2, null, null, "difference");
            addChild( new Bitmap(a3) ).x = 220;
            
            
            
            var b1:BitmapData = new BitmapData(100,100,false,0);
            var b2:BitmapData = b1.clone();
            addChild ( bm = new Bitmap( b1 ) ).y = 110;
            addChild( bm = new Bitmap(b2) ).y = 110;
            bm.x = 110;
           
           
            b1.noise( 10, 0, 255, 7, false );
            
            // The seed of noise b2 is twice the seed value of b1:
            b2.noise( 20, 0, 255, 7, false );
            
            
            var b3:BitmapData = b1.clone();
            b3.draw( b2, null, null, "difference");
            addChild( bm = new Bitmap(b3) ).y = 110;
            bm.x = 220;
            
            var v1:Vector.<uint> = b1.getVector( b1.rect );
            var v2:Vector.<uint> = b2.getVector( b2.rect );
            
            for ( var i:int = 0; i < v1.length; i++ )
            {
                v1[i] &= 0xff7f7f7f // clear the highest rgb bits of b1
                v2[i] &= 0xfefefefe; // clear the lowser rgb bits of b2
                v2[i] >>= 1;  // and shift it one bit to the right
                v2[i] |= 0xff000000; // fix the alpha channel
            }
            
            var b1a:BitmapData = b1.clone()
            b1a.setVector( b1.rect, v1 );
            addChild( new Bitmap(b1a) ).y = 220;
            
            
            var b2a:BitmapData = b1.clone()
            b2a.setVector( b2.rect, v2 );
            
            addChild( bm = new Bitmap(b2a) ).y = 220;
            bm.x = 110;
            
            var b3a:BitmapData = b1a.clone();
            
            // Check the difference between both noises....
            // after the shift it shows that they are identical:
            b3a.draw( b2a, null, null, "difference" );
            
            addChild( bm = new Bitmap(b3a) ).y = 220;
            bm.x = 220;
            
            
        }
    }
}