/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/drJZ
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.GlowFilter;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import net.hires.debug.Stats;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.common.emitters.Emitter;
    import idv.cjcat.stardust.common.renderers.Renderer;
    import idv.cjcat.stardust.twoD.renderers.BitmapRenderer;
    import frocessing.color.ColorHSV;
    
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0)]    
    
    public class FlashTest extends Sprite {
        protected var emitter:Emitter;
        protected var renderer:Renderer;
        private const stw:uint = stage.stageWidth, sth:uint = stage.stageHeight;
        private var _hsv:ColorHSV;
        private var _bmd:BitmapData;
        private var _blurBmd:BitmapData;
        private var _ctf:ColorTransform;
        
        private var _vPoint:VecPoint = new VecPoint(465 * .5, 465 * .5, 465, 465);
        private var _oldP:Point = new Point();
        private var _parlinBmd:BitmapData;
        private var _isMouseDown:Boolean;
        
        public function FlashTest() {
            _hsv = new ColorHSV(53, 1, 1);
            _bmd = new BitmapData(465, 465, false, 0);
            _ctf = new ColorTransform(.8, .8, .8);
            var bm:Bitmap = new Bitmap(_bmd);
            var bbm:Bitmap = new Bitmap(_blurBmd = _bmd.clone());
            bbm.blendMode = "add";
            addChild(bm);
            addChild(bbm);
            addChild(new Stats());
            
            _parlinBmd = new BitmapData(465, 465, false, 0);
            _parlinBmd.perlinNoise(100, 100, 2, Math.random() * 0xffff | 0, false, true, 1 | 2);
            emitter = new MyEmitter(new SteadyClock(3));
            renderer = new BitmapRenderer(_bmd);
            renderer.addEmitter(emitter);
            
            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp);           
        }
        
        private function update(e:Event):void
        {
            var vx:Number = 0;
            var vy:Number = 0;
            if(_isMouseDown) {
                vx = mouseX;
                vy = mouseY;
            } else {
                vx = _vPoint.vPoint(_parlinBmd).x;
                vy = _vPoint.vPoint(_parlinBmd).y;
            }
            
            _ctf.redMultiplier = (_hsv.value >> 16 & 0xff) / 255;
            _ctf.greenMultiplier = (_hsv.value >> 8 & 0xff) / 255;
            _ctf.blueMultiplier = (_hsv.value & 0xff) / 255;
            
            _bmd.lock()+
            _bmd.colorTransform(_bmd.rect, _ctf);
            _bmd.applyFilter(_bmd, _bmd.rect, new Point(), new BlurFilter(8, 8, 2));
            _bmd.unlock();
            _blurBmd.copyPixels(_bmd, _bmd.rect, new Point());
            
            vx += (MyEmitter(emitter).point.x - _oldP.x) * 10;
            vy += (MyEmitter(emitter).point.y - _oldP.y) * 10;
            _oldP.x = MyEmitter(emitter).point.x;
            _oldP.y = MyEmitter(emitter).point.y;
            
            MyEmitter(emitter).point.x += (vx - MyEmitter(emitter).point.x) * .05;
            MyEmitter(emitter).point.y += (vy - MyEmitter(emitter).point.y) * .05;
            
            emitter.step();
        }
        
        private function onDown(e:MouseEvent):void
        {
            _isMouseDown = true;
            _parlinBmd.perlinNoise(100, 100, 2, Math.random() * 0xffff | 0, false, true, 1 | 2);
        }
        
        private function onUp(e:MouseEvent):void
        {
            _isMouseDown = false;
        }
    }
}

import idv.cjcat.stardust.common.actions.*;
import idv.cjcat.stardust.common.clocks.*;
import idv.cjcat.stardust.common.initializers.*;
import idv.cjcat.stardust.common.math.*;
import idv.cjcat.stardust.twoD.actions.*;
import idv.cjcat.stardust.twoD.emitters.*;
import idv.cjcat.stardust.twoD.initializers.*;
import idv.cjcat.stardust.twoD.zones.*;
import idv.cjcat.stardust.twoD.renderers.*;
import idv.cjcat.stardust.twoD.fields.BitmapField;
import idv.cjcat.stardust.twoD.fields.UniformField;

internal class MyEmitter extends Emitter2D
{
    public var point:SinglePoint = new SinglePoint();
    
    private var _gravity:Gravity = new Gravity();
    
    public function MyEmitter(clock:Clock) {
        super(clock);
        addInitializer(new DisplayObjectClass(Star));
        addInitializer(new Velocity(new LazySectorZone(0.2, 0.5)));
        addInitializer(new Life(new UniformRandom(50, 30)));
        addInitializer(new Position(point));
        
        addAction(new AlphaCurve(40, 80));
        addAction(new Age());
        addAction(new DeathLife());
        addAction(new Accelerate(0.02));
        addAction(new Move());
        
        var bmpField:BitmapField = new BitmapField();
        bmpField.max = 0.9;
        bmpField.massless = false;
        bmpField.scaleX = bmpField.scaleY = 0;
        
        var gravity:Gravity = new Gravity();
        gravity.addField(bmpField);
        gravity.addField(new UniformField(0, .05));
        addAction(gravity);
    }
}

import flash.display.Sprite;
import flash.display.Shape;

internal class Star extends Sprite
{
    public function Star() {
        var sp:Shape = new Shape();
        var c:int = 0xffffff >> 8 * (Math.random() * 3 | 0);
        var r:int = Math.random() * 1.5 + 1;
        sp.graphics.beginFill(c, 1.0);
        sp.graphics.moveTo(0, 4);
        sp.graphics.lineTo(3,3);
        sp.graphics.lineTo(4, 0);
        sp.graphics.lineTo(5, 3);
        sp.graphics.lineTo(8, 4);
        sp.graphics.lineTo(5, 5);
        sp.graphics.lineTo(4,8);
        sp.graphics.lineTo(3, 5);
        sp.graphics.endFill();
        
        sp.scaleX = sp.scaleY  = r;
        sp.rotation = Math.random() * 180;
        addChild(sp);
    }
}

import flash.geom.Point;
import flash.display.BitmapData;

internal class VecPoint
{
    private var _av:Point = new Point();
    private var _vv:Point = new Point();
    private var _pv:Point = new Point();
    
    private var _limitW:Number;
    private var _limitH:Number;
    
    public function VecPoint(x:Number, y:Number, limitWidth:Number, limitHeight:Number) {
        _pv.x = x;
        _pv.y = y;
        _limitW = limitWidth;
        _limitH = limitHeight;
    }
    
    public function vPoint(map:BitmapData):void {
        var c:Number = map.getPixel(_pv.x, _pv.y);
        var r:uint = c >> 16 * 0xff;
        var g:uint = c >> 8 & 0xff;
        _av.x += (r-128) * .001;
        _av.y += (g-128) * .001;
        _vv.x += _av.x;
        _vv.y += _av.y;
        _pv.x += _vv.x;
        _pv.y += _vv.y;
        _av.x *= .95;
        _av.y *= .95;
        _vv.x *= .9;
        _vv.y *= .9;
        (_pv.x > _limitW) ? _pv.x = 0 : 0;
        (_pv.x < 0) ? _pv.x = _limitW : 0;
        (_pv.y > _limitH) ? _pv.y = 0 : 0;
        (_pv.y < 0) ? _pv.y = _limitH : 0;
        
        return _pv;
    }
}





