/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dqQi
 */

// forked from l.dijkman's forked from: TwinkleEffect (8)
// forked from ProjectNya's TwinkleEffect (8)
////////////////////////////////////////////////////////////////////////////////
// TwinkleEffect (4)
//
// [AS3.0] DetectPixelsクラスに挑戦！ (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1135


// http://www.3x6.NL  ///////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.Bitmap;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="60")]

    public class Main extends Sprite {
        private var loader:Loader;
        private static var basePath:String = "http://www.gravomaster.com/";
        private static var photoPath:String = "666.png";
        private var detection:DetectPixels;
        private static var accuracy:uint = 2;
        private var threshold:uint = 0xFF808080;
        private var twinkle:TwinkleEffect;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT, initialize, false, 0, true);
            loader.load(new URLRequest(basePath + photoPath), new LoaderContext(true));
            addChild(loader);
            loader.x = 32;
            loader.y = 32;
            loader.alpha = 0.2;
        }
        private function initialize(evt:Event):void {
            evt.target.removeEventListener(Event.INIT, initialize);
            var content:Bitmap = Bitmap(evt.target.content);
            var area:Rectangle = new Rectangle(10, 10, 400, 400);
            detection = new DetectPixels(accuracy);
            var offset:Object = {x: 10, y: 10};
            detection.search(loader, area, threshold, offset);
            var map:Array = detection.pixels();
            //
            var rect:Rectangle = new Rectangle(0, 0, 420, 420);
            twinkle = new TwinkleEffect(rect, map.reverse());
            addChild(twinkle);
            twinkle.x = 22;
            twinkle.y = 22;
            twinkle.setup(100, 10);
        }
        
    }

}


//////////////////////////////////////////////////
// TwinkleEffectクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Rectangle;
import flash.geom.Matrix;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;
import frocessing.color.ColorHSV;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundLoaderContext;
import flash.media.SoundMixer;
import flash.utils.ByteArray;
import flash.net.URLRequest;
import flash.system.Security;

class TwinkleEffect extends Sprite {
    private var rect:Rectangle;
    private var map:Array;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private static var radius:uint = 10;
    private var interval:uint = 100;
    private var life:uint = 10;
    private var particles:Array;
    private var color:ColorHSV;
    private var unit:uint = 30;
    private var division:uint = 12;
    private static var radian:Number = Math.PI/180;
    private var timer:Timer;
    private static var policyPath:String = "http://www.gravomaster.com/crossdomain.xml";
    private var sound:Sound;
    private var channel:SoundChannel;
    private static var soundPath:String = "http://scfire-dtc-aa03.stream.aol.com:80/stream/1035";
    private var byteArray:ByteArray;
    private static var channels:uint = 256;
    private var factors:uint = 0;
    private var count:uint = 0;

    public function TwinkleEffect(r:Rectangle, m:Array) {
        rect = r;
        map = m;
        init();
    }

    private function init():void {
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        particles = new Array();
        color = new ColorHSV();
        unit = uint(360/division);
        //
        Security.loadPolicyFile(policyPath);
        sound = new Sound();
        sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
        sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
        byteArray = new ByteArray();
    }
    public function setup(i:uint = 100, l:uint = 10):void {
        interval = i;
        life = l;
    }
    private function complete(evt:Event):void {
        evt.target.removeEventListener(Event.COMPLETE, complete);
        start();
    }
    private function start():void {
        timer = new Timer(interval);
        timer.addEventListener(TimerEvent.TIMER, tick, false, 0, true);
        timer.start();
        channel = sound.play(0, 1000);
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function stop():void {
        timer.stop();
        removeEventListener(Event.ENTER_FRAME, update);
    }
    private function tick(evt:TimerEvent):void {
        SoundMixer.computeSpectrum(byteArray, true, factors);
        for (var c:uint = 0; c < 2; c++) {
            for (var t:uint = 0; t < channels; t++) {
                var p:Number = byteArray.readFloat();
                if (p > 0) create(p);
            }
        }
    }
    private function create(p:Number):void {
        var id:uint = uint(map.length*p)%map.length;
        var px:Number = map[id].x;
        var py:Number = map[id].y;
        plot(px, py);
    }
    private function plot(px:Number, py:Number):void {
        var matrix:Matrix = new Matrix();
        matrix.translate(px - radius, py - radius);
        color.h = count;
        var particle:TwinkleParticle = new TwinkleParticle();
        particle.x = px;
        particle.y = py;
        particle.life = (Math.random()*0.5 + 0.5)*life;
        particle.matrix = matrix;
        particle.color = color.value;
        particles.push(particle);
        bitmapData.lock();
        draw(px, py, 0xFFFFFF, life/life);
        bitmapData.unlock();
    }
    private function update(evt:Event):void {
        bitmapData.lock();
        bitmapData.fillRect(rect, 0x00000000);
        for (var n:uint = 0; n < particles.length; n++) {
            var particle:TwinkleParticle = particles[n];
            draw(particle.x, particle.y, particle.color, particle.life/life);
            particle.life --;
            if (particle.life < 0) {
                particles.splice(n, 1);
                particle = null;
            }
        }
        bitmapData.unlock();
        count++;
    }
    private function draw(px:uint, py:uint, color:uint, percent:Number):void {
        var length:uint = uint(radius*percent);
        var argb:uint = 0xFF << 24 | color;
        for (var n:uint = 0; n < length; n++) {
            for (var a:uint = 0; a < 360; a+=unit) {
                var dx:Number = px + n*Math.cos(a*radian);
                var dy:Number = py + n*Math.sin(a*radian);
                bitmapData.setPixel32(dx, dy, argb);
            }
        }
    }

}


//////////////////////////////////////////////////
// TwinkleParticleクラス
//////////////////////////////////////////////////

import flash.geom.Matrix;

class TwinkleParticle {
    public var x:uint;
    public var y:uint;
    public var life:int;
    public var matrix:Matrix;
    public var color:uint;

    public function TwinkleParticle() {
    }

}


//////////////////////////////////////////////////
//    DetectPixelsクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.IBitmapDrawable;

class DetectPixels {
    private var bd:IBitmapDrawable;
    private var rect:Rectangle;
    private var map:BitmapData;
    private var mapList:Array;
    private var accuracy:uint;
    private var threshold:uint = 0x80FFFFFF;
    private var offset:Object = {x: 0, y: 0};

    public function DetectPixels(a:uint = 1) {
        accuracy = a;
    }

    public function search(t:IBitmapDrawable, r:Rectangle, th:uint = 0x80FFFFFF, o:Object = null):void {
        bd = t;
        rect = r;
        threshold = th;
        if (o) offset = o;
        var w:uint = rect.width/accuracy;
        var h:uint = rect.height/accuracy;
        detect(w, h);
    }
    private function detect(w:uint, h:uint):void {
        map = new BitmapData(w, h, true, 0x00000000);
        var matrix:Matrix = new Matrix();
        matrix.translate(-rect.x, -rect.y);
        matrix.scale(1/accuracy, 1/accuracy);
        map.lock();
        map.draw(bd, matrix);
        map.unlock();
        mapList = new Array();
        for (var y:uint = 0; y < h; y++) {
            for (var x:uint = 0; x < w; x++) {
                var color:uint = map.getPixel32(x, y);
                if (color >= threshold) {
                    var px:int = x*accuracy + rect.x + offset.x;
                    var py:int = y*accuracy + rect.y + offset.y;
                    var point:Point = new Point(px, py);
                    mapList.push(point);
                }
            }
        }
    }
    public function pixels():Array {
        return mapList;
    }

}
