/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dq6i
 */

package
{
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFormat;
 
    public class Main extends Sprite
    {
        private const WIDTH:int = 50;
        private const HEIGHT:int = 50;
        private var map/*Array*/:Array;
        
        public function Main()
        {
            map = [];
            for (var y:int = 0; y < HEIGHT; y++)
            {
                map[y] = [];
                for (var x:int = 0; x < WIDTH; x++)
                {
                    map[y][x] = " ";
                }
            }
            
            var partitions/*Rect*/:Array = split(new Rect(0, 0, WIDTH - 1, HEIGHT - 1));
            for (var i:int = 0; i < partitions.length; i++)
            {
                fill(partitions[i], ".");
            }
            
            var tf:TextField = new TextField();
            var format:TextFormat = new TextFormat("_typeWriter", 12, 0x0, true);
            format.leading = -8;
            tf.defaultTextFormat = format;
            tf.autoSize = "left";
            addChild(tf);

            for (i = 0; i < map.length; i++)
            {
                tf.appendText(map[i].join("") + "\n");
            }
        }
        
        private function fill(rect:Rect, char:String):void
        {
            var minY:int = Math.min(rect.top, rect.bottom);
            var maxY:int = Math.max(rect.top, rect.bottom);
            
            var minX:int = Math.min(rect.left, rect.right);
            var maxX:int = Math.max(rect.left, rect.right);
            
            for (var y:int = minY; y <= maxY; y++)
            {
                for (var x:int = minX; x <= maxX; x++)
                {
                    map[y][x] = char;
                }
            }
        }
        
        private function split(rect:Rect, ...args):Array
        {
            const MIN_SIZE:int = 8;
            
            if (rect.height < MIN_SIZE * 2 + 1 ||
                rect.width    < MIN_SIZE * 2 + 1)
            {
                return [rect];
            }
            
            var rectA:Rect;
            var rectB:Rect;
            
            var dirSplitFlag:Boolean = true; // true = 縦に分割, false = 横に分割
            if (rect.height < MIN_SIZE * 2 + 1) dirSplitFlag = false;
            else if (rect.width < MIN_SIZE * 2 + 1) dirSplitFlag = true;
            else dirSplitFlag = (rect.width < rect.height) ? true : false;
            
            // 縦に分割
            if (dirSplitFlag)
            {
                var height:int = rect.top + (MIN_SIZE - 1) + getIntRandom(rect.height - MIN_SIZE * 2 - 1);
                rectA = new Rect(rect.left, rect.top, rect.right, height);
                rectB = new Rect(rect.left, height + 2, rect.right, rect.bottom);
            }
            // 横に分割
            else
            {
                var width:int = rect.left + (MIN_SIZE - 1) + getIntRandom(rect.width - MIN_SIZE * 2 - 1);
                rectA = new Rect(rect.left, rect.top, width, rect.bottom);
                rectB = new Rect(width + 2, rect.top, rect.right, rect.bottom)
            }
            
            return flatten([rectA, rectB].map(split));
        }
        
        private function getIntRandom(n:int):int
        {
            n += (n < 0) ? -1 : 1;
            return n * Math.random();
        }
        
        private function flatten(data:Array):Array
        {
            var src:Array = data.slice();
            var dest:Array = [];
            
            while (true)
            {
                var element:* = src.shift();
                if (element == undefined) break;
                else if (element is Array) src = src.concat(element);
                else dest.push(element);
            }
            
            return dest;
        }
    }
}

class Rect
{
    public var left:int;
    public var top:int;
    public var right:int;
    public var bottom:int;
    
    public function Rect(left:int = 0, top:int = 0, right:int = 0, bottom:int = 0):void
    {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }
    
    public function get height():int
    {
        return bottom - top + 1;
    }
    
    public function get width():int
    {
        return right - left + 1;
    }
}