/**
 * Copyright tjoen ( http://wonderfl.net/user/tjoen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dpwQ
 */

// forked from kuma360's サムネイルしきつめる
package {
    
    import flash.display.*;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    
    public class Main extends Sprite {
        
        private var _canvas:BitmapData ;
        private var _text:TextField ;
        private var _img:ImageLoader;
        
        public function Main () {
            
            ///////////////////
            _canvas = new BitmapData ( stage.stageWidth , stage.stageHeight , false , 0 ) ;
            addChild ( new Bitmap ( _canvas ) ) ;
            
            _text = new TextField ;
            _text.autoSize = "center" ;
            _text.textColor = 0xFFFFFF ;
            _text.text = "loading..." ;
            
            _img = new ImageLoader ;
            
            
            ///////////////////
            addEventListener (
                Event.ENTER_FRAME ,
                function ():void {
                    
                    _img.update( mouseY ) ;
                    
                    _canvas.fillRect ( _canvas.rect , 0 ) ;
                    _canvas.draw ( _text ) ;
                    _canvas.copyPixels ( _img , _img.rect , new Point ) ;
                    
                }
            ) ;
            
            ///////////////////
            stage.addEventListener (
                MouseEvent.CLICK,
                function ():void {
                    _img = new ImageLoader ;
                }
            ) ;
                
            
        }
        
        
    }
}


import flash.display.*;
import flash.events.Event;
import flash.geom.Matrix;
import flash.net.URLLoader;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import flash.geom.Point;

class ImageLoader extends BitmapData {
    
    private const _feed:String = "http://api.flickr.com/services/feeds/photos_public.gne?format=rss_200";
    private const _media:Namespace = new Namespace ( "http://search.yahoo.com/mrss/" ) ; 
    private const SIZE:int = 155 ;
    
    private var _length:uint = 0 ;
    private var _V:Vector.<BitmapData> = new Vector.<BitmapData> ;
    
    public function ImageLoader() {
        
        super ( 465 , 465 , true , 0 ) ;
        
        var ldr:URLLoader = new URLLoader;
        ldr.addEventListener ( Event.COMPLETE, function _load(e:Event):void {
            ldr.removeEventListener(Event.COMPLETE, _load);
            Loaded ( XML(ldr.data).._media::thumbnail.@url.toXMLString().split('\n') );
        } );
        ldr.load ( new URLRequest ( _feed ) ) ;
        
    }
    
    
    
    private function Loaded ( $images:Array ) :void {
        
        _length = $images.length ;
        for ( var i:int = 0; i < _length ; ++i ) {
            
            var ldr:Loader;
            ldr = new Loader;
            ldr.contentLoaderInfo.addEventListener ( Event.COMPLETE , Loadcomp ) ;
            
            var strArray:String = $images[ i ].replace ( "_s" , "" ) ;
            ldr.load ( new URLRequest ( strArray ) , new LoaderContext ( true ) ) ;
            
        }
        
    }
    
    
    private function Loadcomp ( e:Event ) :void {
        
        var data:Bitmap = e.target.content as Bitmap ;
        
        if ( data ) {
            data.smoothing = true;
            
            var h:int = data.height / data.width * SIZE ;
            var b:BitmapData = new BitmapData ( SIZE , h , false , 0 ) ;
            
            var m:Matrix = new Matrix;
            m.scale ( SIZE / data.width , h / data.height ) ;
            
            b.draw ( data , m ) ;
            
            _V.push ( b ) ;
            
        }
        
    }
    
    
    
    public function update ( y:int ) :void {
        
        var i:int ;
        var j:int ;
        var k:int ;
        var b:BitmapData ;
        var h:Array = [ 0 , 0 , 0 ] ;
        var p:Point = new Point ;
        
        
        fillRect ( rect , 0 ) ;
        for ( i = 0; i < _V.length ; ++i ) {
            
            b = _V[i] ;
            
            j = 0 ;
            var min:Number = h[0];
            for ( k = 1; k < h.length ; k++ ) {
                  if ( h[k] < min ) {
                      min = h[k] ;
                      j = k ;
                  }
            }
    
            p.x = j * SIZE ;
            p.y = h [ j ] - y ;
            copyPixels ( b , b.rect , p ) ;
            
            h [ j ] += b.rect.height ; 
            
        }
        
    }
    
}
