/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dph9
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.Font;
    import flash.text.TextField;
    import com.bit101.components.InputText;
    import com.bit101.components.VSlider;
    
    public class FlashTest extends Sprite {
        private var _fonts:Vector.<FontPanel> = new Vector.<FontPanel>();
        private var _sp:Sprite;
        private var _mask:Sprite;
        private var input:InputText;
        private var slider:VSlider;
        
        public function FlashTest() {
             _mask = addChild(new Sprite) as Sprite;
            _mask.graphics.beginFill(0x0);
            _mask.graphics.drawRect(0, 40, stage.stageWidth-20, stage.stageHeight-50);
            _mask.graphics.endFill();
            _sp = addChild(new Sprite) as Sprite;
            _sp.mask = _mask;
            
            var count:int = 0;
            for each (var font:Font in Font.enumerateFonts(true)){
                _fonts.push(_sp.addChild(new FontPanel(10+140*(count%3), 40+60*int(count/3), 140, 60, font.fontName, "input text")) as FontPanel);
                count++;
            }
            
            input = new InputText(this, 10, 10, "input text", change);
            input.setSize(100, 15);
            
            slider = new VSlider(this, stage.stageWidth-10, 40, change);
            slider.setSize(10, stage.stageHeight-50);
            slider.minimum = 0;
            slider.maximum = 1;
            slider.value = 1;
            
            txt = addChild(new TextField) as TextField;
            txt.width = stage.stageWidth;
            txt.height = stage.stageHeight; 
            txt.mouseEnabled = false;
        }
        
        private function change(event:Event):void{
            if(event.currentTarget is InputText){
                for each(var fontPanel:FontPanel in _fonts){
                    fontPanel.text = input.text;
                }
            }
            else if(event.currentTarget is VSlider){
                _sp.y = -(_sp.height-(stage.stageHeight-50))*(1-slider.value);
            }
        }

        public var txt:TextField;        
    }
}


import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.geom.Matrix;

class FontPanel extends Sprite{
    private var _txt:TextField;
    private var _label:TextField;
    
    public function FontPanel(x:Number = 0, y:Number = 0, width:Number = 100, height:Number = 100, fontName:String = null, text:String = null){
        //パラメータの設定
        this.x = x;
        this.y = y;
        
        //テキスト
        _txt = addChild(new TextField) as TextField;
        _txt.defaultTextFormat = new TextFormat(fontName, 20, 0x111111, null, null, null, null, null, "center");
        _txt.text = text;
        _txt.x = 2;
        _txt.y = 23;
        _txt.width = width-4;
        _txt.height = _txt.textHeight+5;
        _txt.mouseEnabled = false;
        
        //フォント名
        _label = addChild(new TextField) as TextField;
        _label.defaultTextFormat = new TextFormat(fontName, 10, 0x666666);
        _label.text = fontName;
        _label.x = 2;
        _label.y = 2;
        _label.width = width-4;
        //_label.mouseEnabled = false;
        
        //背景描画
        graphics.lineStyle(1, 0x888888);
        graphics.beginFill(0xEEEEEE);
        graphics.drawRect(0, 0, width, height);
        graphics.endFill();
    }
    
    public function set text(str:String):void{
        _txt.text = str;
    }
}