/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dpaG
 */

// forked from 178ep3's RoundPolygon
//        drawRoundPolygon( Graphics , 丸みレベル(0～10) , 直径 , 角数);
//        7角形が何か変だ。。　>>>凡ミスでした。 uwiさんのナイスな指摘で解決。
//        丸みレベルは、　0で丸み無し、　10で完全に丸(10だと何か変)
//        普通の多角形なら drawPolygon( Graphics , 直径 , 角数);
package  
{
    import com.bit101.components.CheckBox;
    import com.bit101.components.HSlider;
    import com.bit101.components.HUISlider;
    import com.bit101.components.VBox;
    import flash.display.*;
    import flash.events.Event;
    
    public class TejidoHexagonal extends Sprite 
    {
        static private const HEXAGON:int = 6;
        private var roundnessRadius:Number;
        private var pRadius:Number;
        private var pPositionRadius:Number;
        private var roundnessHSlider:HUISlider;
        private var isRounded:Boolean;
        private var raiudPositionHUISlider:HUISlider;
        private var radiushSlider1:HUISlider;
        private var isColored:Boolean;
        
        public function TejidoHexagonal() 
        {
            gui();
            draw();

        }
        
        private function gui():void 
        {
            roundnessRadius = 5;
            pPositionRadius = 30
            pRadius = pPositionRadius;
            var vbox:VBox = new VBox(this, 0, 0);
            roundnessHSlider = new HUISlider(vbox,0,0,'rr',onRroundedRadius);
            roundnessHSlider.minimum = 0;
            roundnessHSlider.maximum = uint(pPositionRadius*0.5);
            roundnessHSlider.value = roundnessRadius;;
            radiushSlider1 = new HUISlider(vbox,0,0,'rr',onRadius);
            radiushSlider1.minimum = 10;
            radiushSlider1.maximum = pPositionRadius;
            radiushSlider1.value = pRadius;
            raiudPositionHUISlider = new HUISlider(vbox, 0, 0, "ir", onIr);
            raiudPositionHUISlider.minimum = 10;
            raiudPositionHUISlider.maximum = 100;
            raiudPositionHUISlider.value = pPositionRadius;
            new CheckBox(vbox, 0, 0, 'nonRounded', onNonRounded);
            new CheckBox(vbox, 0, 0, 'colored', onColored);
        }
        
        private function onColored(e:Event):void 
        {
            var checkBox:CheckBox = e.target as CheckBox;
            isColored = checkBox.selected;
            draw();
        }
        
        private function onNonRounded(e:Event):void 
        {
            var checkBox:CheckBox = e.target as CheckBox;
            isRounded = checkBox.selected;
            draw();
        }
        
        private function onIr(e:Event):void 
        {
            var hUISlider:HUISlider = e.target as HUISlider;
            pPositionRadius = hUISlider.value;
            //trace( "pRadius : " + pRadius );
            radiushSlider1.maximum = pPositionRadius;
            if (pRadius>pPositionRadius) 
            {
                radiushSlider1.value = pRadius = pPositionRadius;
            }
            draw();
        }
        
        private function onRadius(e:Event):void 
        {
            var hSlider:HUISlider = e.target as HUISlider;
            pRadius = hSlider.value;
            var roundMax:uint = uint(pRadius * 0.5);
            roundnessHSlider.maximum = roundMax;
            if (roundnessRadius>roundMax) 
            {
                roundnessHSlider.value = roundnessRadius = roundMax;
            }
            draw();
        }
        
        private function onRroundedRadius(e:Event):void 
        {
            var hSlider:HUISlider = e.target as HUISlider;
            roundnessRadius = hSlider.value;
            draw();
        }
        
        private function draw():void 
        {
            graphics.clear();
            var i:int=0;
            var q:int = 0;
            var hexagon:int = 2 * Math.PI / HEXAGON;
            var hexagon2:Number = hexagon * 0.5;
            var pSide:Number = Math.sin(hexagon2) * pPositionRadius * 2;
            var pSomeHeight:Number = Math.cos(hexagon2) * pPositionRadius;
            var gapx:Number = pSomeHeight*0.5+pPositionRadius;
            var gapy:Number = 2*pSomeHeight ;
            //gapx = 0; gapy = 0;
            var ox:Number = 0;
            var oy:Number = 0;
            var numRows:Number = int( stage.stageHeight/ pSomeHeight) +1;
            var separation:Number = 2 * pPositionRadius + pSide;
            var numCols:Number = int(stage.stageWidth / separation)+1;
            var nn:Number = numCols * numRows;
            //trace( "nn : " + nn );
            for(i=-1; i<numRows; i++)
            {
                for(q=-1; q<numCols; q++)
                {
                    var gapxx:Number = (i % 2 == 0)?gapx:0;
                    var gapyy:Number = (i % 2 == 0)?pSomeHeight:pSomeHeight;
                    var px:Number = ox + gapxx + q * separation;
                    var py:Number = oy + gapyy + i * pSomeHeight;
        //                    塗りや線を設定して
                    if(isColored)
                    graphics.beginFill(Math.random() * 0xffffff);
                    else
                    graphics.beginFill(Math.random()*0);
        //                    PolygonクラスのdrawRoundPolygonに設定を渡す
                    Polygon.drawRoundPolygon(graphics, roundnessRadius, pRadius, HEXAGON, px, py);
                    graphics.lineStyle(0);
                    if(isRounded)Polygon.drawPolygon(graphics,pRadius,HEXAGON,px,py);
                }
            }
        }
        
    }

}
import flash.display.*;
import flash.geom.*;

    

class Polygon
{
    public function Polygon(){}
    
    public static function drawPolygon(target:Graphics, radius:Number, polygon:uint, cx:Number=0, cy:Number=0):void
    {
        var list:Array = getPoints(radius,polygon,cx,cy);
        var i:uint=0;
        var len:uint = list.length;
        
        target.moveTo(list[0].x,list[0].y);
        for(i=1; i<len; i++)
        {
            target.lineTo(list[i].x,list[i].y);
        }
        target.lineTo(list[0].x,list[0].y);
        target.endFill();
    }
    
    public static function drawRoundPolygon(target:Graphics,round:uint,radius:Number,polygon:uint,cx:Number=0, cy:Number=0):void
    {
        var con:Array = getPoints(radius,polygon,cx,cy);
        var anc:Array = [];
        var i:uint = 0;
        var a2:uint = Math.PI / polygon;
        var maxRoundness:uint = uint(0.5*radius);
        if(round>maxRoundness)round=maxRoundness;
        var n:Number = round/20;
        var cLen:uint = con.length;
        
        for(i=0; i<cLen; i++)
        {
            var p:Point = new Point(0,0);
            var q:Point = new Point(0,0);
            if(i==0)
            {
                p = Point.interpolate(con[cLen-1],con[0],n);
                q = Point.interpolate(con[1],con[0],n);
            }
            else if(i==cLen-1)
            {
                p = Point.interpolate(con[i-1],con[i],n);
                q = Point.interpolate(con[0],con[i],n);
            }
            else 
            {
                p = Point.interpolate(con[i-1],con[i],n);
                q = Point.interpolate(con[i+1],con[i],n);
            }
            anc.push(p);
            anc.push(q);
        }
        
        var len:uint = anc.length;
        target.moveTo(anc[0].x,anc[0].y);
        for(i=1; i<len-2; i+=2)
        {
            target.curveTo(con[(i-1)/2].x,con[(i-1)/2].y,anc[i].x,anc[i].y);
            target.lineTo(anc[i+1].x,anc[i+1].y);
        }
        target.curveTo(con[cLen-1].x,con[cLen-1].y,anc[len-1].x,anc[len-1].y);
        target.lineTo(anc[0].x,anc[0].y);
        target.endFill();
    }
    
    private static function getPoints(radius:Number, polygon:uint, cx:Number=0, cy:Number=0):Array
    {
        var list:Array = [];
        var angle:Number = 360/polygon;
        var i:Number=0;
        for(i=0; i<360; i+=angle)
        {
            var p:Point = Point.polar(radius, i * Math.PI / 180);
            p=p.add(new Point(cx, cy));
            list.push(p);
        }
        return list
    }
}