/**
 * Copyright cjcat2266 ( http://wonderfl.net/user/cjcat2266 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/doM8
 */

/**
 * Stardust Particle Engine
 * 
 * Homepage
 * 	http://code.google.com/p/stardust-particle-engine/
 * 
 * Documentation
 * 	http://stardust-particle-engine.googlecode.com/svn/trunk/docs/index.html
 * 
 * PDF Manual
 * 	http://stardust-particle-engine.googlecode.com/svn/trunk/manual/Stardust%20Particle%20Engine%20Manual.pdf
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import idv.cjcat.stardust.common.clocks.SteadyClock;
	import idv.cjcat.stardust.twoD.display.AddChildMode;
	import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;
	
	[SWF(backgroundColor="#FFFFFF", frameRate=60)]
	
	public class Main extends Sprite {
		
		private var emitter:StarEmitter;
		
		public function Main():void {
			emitter = new StarEmitter(new SteadyClock(1));
			var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(this);
			renderer.addEmitter(emitter);
			
			addEventListener(Event.ENTER_FRAME, mainLoop);
		}
		
		private function mainLoop(e:Event):void {
			emitter.step();
		}
	}
}

//------------------------------------------------------------------------------------------------

import flash.display.LineScaleMode;
import flash.display.Shape;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.initializers.Scale;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.twoD.actions.Damping;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.actions.Spin;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
import idv.cjcat.stardust.twoD.initializers.Omega;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Rotation;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.SinglePoint;

//------------------------------------------------------------------------------------------------

//I have no idea why this line must be added in order to compile successfully on Wonderfl.
//Just ignore this class :p
class BugFixer extends Shape { public function BugFixer() { } }

//------------------------------------------------------------------------------------------------

class StarEmitter extends Emitter2D {
	
	public function StarEmitter(clock:Clock) {
		super(clock);
		
		//initializers
		addInitializer(new DisplayObjectClass(Star));
		addInitializer(new Life(new UniformRandom(30, 10)));
		addInitializer(new Position(new SinglePoint(232.5, 232.5)));
		addInitializer(new Velocity(new LazySectorZone(10, 10)));
		addInitializer(new Rotation(new UniformRandom(0, 180)));
		addInitializer(new Omega(new UniformRandom(0, 5)));
		addInitializer(new Scale(new UniformRandom(1, 0.3)));
		
		//actions
		addAction(new Age());
		addAction(new DeathLife());
		addAction(new Move());
		addAction(new Spin());
		addAction(new ScaleCurve(5, 15));
		addAction(new Damping(0.1));
	}
}

//------------------------------------------------------------------------------------------------

class Star extends Shape {
	
	private const OUTER_RADIUS:Number = 20;
	private const INNER_RADIUS:Number = 12;
	
	public function Star() {
		graphics.lineStyle(0, 0, 1, false, LineScaleMode.NONE);
		graphics.beginFill(0xF9C330);
		graphics.moveTo(0, -OUTER_RADIUS);
		for (var i:int = 1; i <= 11; i++) {
			var radius:Number = (i & 1)?(INNER_RADIUS):(OUTER_RADIUS);
			var theta:Number = 0.2 * Math.PI * i;
			graphics.lineTo(radius * Math.sin(theta), radius * -Math.cos(theta));
		}
		graphics.endFill();
	}
}