/**
 * Copyright Fricks ( http://wonderfl.net/user/Fricks )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dn1b
 */

package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.utils.ByteArray;
    public class FlashTest extends Sprite {
        
        private var sw:Number = stage.stageWidth;
        private var sh:Number = stage.stageHeight;
        private var cx:Number = sw/2;
        private var cy:Number = sh/2;
        private var camz:Number = -300;
        private var shape:Shape;
        private var g:Graphics;
        private var ary:Array;
        private var cn:Number = 8;
        private var degree:Number = 1.0;
        private var radian:Number = 0.;
        private var degree2:Number = 1.0;
        private var radian2:Number = 0.;
        
        public function FlashTest() {
            // write as3 code here..
            init();
        }
        
        private function init(){
            ary = new Array();
            ary[0] = {px:100,py:100,pz:100};
            ary[1] = {px:-100,py:100,pz:100};
            ary[2] = {px:-100,py:-100,pz:100};
            ary[3] = {px:100,py:-100,pz:100};
            ary[4] = {px:100,py:100,pz:-100};
            ary[5] = {px:-100,py:100,pz:-100};
            ary[6] = {px:-100,py:-100,pz:-100};
            ary[7] = {px:100,py:-100,pz:-100};
            shape = new Shape();
            addChild(shape);
            g = shape.graphics;
            addEventListener(Event.ENTER_FRAME,upDate);
        }
        
        private function upDate(e:Event){
            g.clear();
            degree = (mouseX-cx)/50;
            degree2 = (mouseY-cy)/50;
            radian = (degree/180)*Math.PI;
            radian2 = (degree2/180)*Math.PI;
            
            for(var i=0;i<cn;i++){
                /*X軸に沿ったに回転
                y' = ycosβ - zsinβ
                z' = ysinβ + zcosβ
                
                Y軸に沿った回転
                z' = zcosβ - xsinβ
                x' = zsinβ + xcosβ
                
                Z軸に沿った回転 ---Z軸の回転は2次元(XY平面)の回転に対応
                x' = xcosβ - ysinβ
                y' = xsinβ + ycosβ*/
                
                //x軸
                var fpy = ((ary[i].py)*Math.cos(radian2)-(ary[i].pz)*Math.sin(radian2));
                var fpz = ((ary[i].py)*Math.sin(radian2)+(ary[i].pz)*Math.cos(radian2));
                
                //y軸
                var pz = ((fpz)*Math.cos(radian2)-(ary[i].px)*Math.sin(radian2));
                var fpx = ((fpz)*Math.sin(radian2)+(ary[i].px)*Math.cos(radian2));
                
                //z軸
                var px = ((fpx)*Math.cos(radian)-(fpy)*Math.sin(radian));
                var py = ((fpx)*Math.sin(radian)+(fpy)*Math.cos(radian));
                ary[i].px = px;
                ary[i].py = py;
                ary[i].pz = pz;
            }
            
            var ba:ByteArray = new ByteArray();
            ba.writeObject(ary);
            ba.position = 0;
            var cAry:Array = ba.readObject();  
            for(var j=0;j<cAry.length;j++){
                var scale = camz/(cAry[j].pz+camz);
                var sx = (cAry[j].px)*scale;
                var sy = (cAry[j].py)*scale;
                cAry[j].px = sx+cx;
                cAry[j].py = sy+cy;
                //dPoint(cAry[j].px-2,cAry[j].py-2);
            }
            
            g.lineStyle(1,0xFF0000);
            g.moveTo(cAry[0].px,cAry[0].py);
            g.lineTo(cAry[1].px,cAry[1].py);
            g.lineTo(cAry[2].px,cAry[2].py);
            g.lineTo(cAry[3].px,cAry[3].py);
            g.lineTo(cAry[0].px,cAry[0].py);
            g.moveTo(cAry[4].px,cAry[4].py);
            g.lineTo(cAry[5].px,cAry[5].py);
            g.lineTo(cAry[6].px,cAry[6].py);
            g.lineTo(cAry[7].px,cAry[7].py);
            g.lineTo(cAry[4].px,cAry[4].py);
            g.moveTo(cAry[0].px,cAry[0].py);
            g.lineTo(cAry[4].px,cAry[4].py);
            g.moveTo(cAry[1].px,cAry[1].py);
            g.lineTo(cAry[5].px,cAry[5].py);
            g.moveTo(cAry[2].px,cAry[2].py);
            g.lineTo(cAry[6].px,cAry[6].py);
            g.moveTo(cAry[3].px,cAry[3].py);
            g.lineTo(cAry[7].px,cAry[7].py);
        }
        
        private function dPoint(dx:Number,dy:Number){
            g.beginFill(0x0000FF);
            g.drawCircle(dx,dy,2);
        }
    }
}