/**
 * Copyright majoraze ( http://wonderfl.net/user/majoraze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dmXD
 */

// forked from majoraze's asteroids spaceship
// forked from majoraze's forked from: Basic spaceship
// forked from majoraze's Basic spaceship
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    
    
    public class SpaceShipBasic extends Sprite {
        private var ship:Ship;
        private var vr:Number = 0;
        private var thrust:Number = 0;
        private var vx:Number = 0;
        private var vy:Number = 0;
        private var friction:Number = 0.98;
        
        public function SpaceShipBasic() {
            init();
        }
        
        private function init():void {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            //fills the background black 
            graphics.beginFill(0x000000,1);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            ship = new Ship();
            addChild(ship);
            ship.x = stage.stageWidth/2;
            ship.y = stage.stageHeight/2;
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
        }
        
        private function onKeyDown(e:KeyboardEvent):void {
            switch(e.keyCode) {
                case Keyboard.LEFT:
                    vr = -5;
                break;
                case Keyboard.RIGHT:
                    vr = 5;
                break;
                case Keyboard.UP:
                    thrust = .3;
                    ship.draw(true);
                break;
                
                default:
                break;
            }

        }
        
        private function onKeyUp(e:KeyboardEvent):void {
            switch(e.keyCode) {
                case Keyboard.LEFT:
                    vr = 0;
                break;
                case Keyboard.RIGHT:
                    vr = 0;
                break;
                case Keyboard.UP:
                    thrust = 0;
                    ship.draw(false);
                break;
                
                default:
                break;
            }
        }
        
        private function onEnterFrame(e:Event):void {
            ship.rotation += vr;
            var angle:Number = ship.rotation * Math.PI/180;
            var ax:Number = Math.cos(angle) * thrust;
            var ay:Number = Math.sin(angle) * thrust;
            vx += ax;
            vy += ay;
            vx *= friction;
            vy *= friction;
            ship.x += vx;
            ship.y += vy;
            
            //boundaries
            var left:Number = 0;
            var right:Number = stage.stageWidth;
            var top:Number = 0;
            var bottom:Number = stage.stageHeight;
            
            //left and right boundaries
            if(ship.x - ship.width/2 > right) {
                ship.x = left - ship.width/2;
            } else if (ship.x + ship.width/2 < left) {
                ship.x = right + ship.width/2;
            }
            
            //top and bottom boundaries
            if (ship.y - ship.height/2 > bottom) {
                ship.y = top - ship.height/2;
            } else if (ship.y < top - ship.height/2) {
                ship.y = bottom + ship.height/2;
            }
        }
    }
}

import flash.display.Sprite;
class Ship extends Sprite {
    public function Ship() {
        draw(false);
    }
    
    public function draw(showFlame:Boolean):void {
        graphics.clear();
        graphics.lineStyle(1,0xffffff);
        graphics.moveTo(10,0);
        graphics.lineTo(-10,10);
        graphics.lineTo(-5,0);
        graphics.lineTo(-10,-10);
        graphics.lineTo(10,0);
        
        if (showFlame) {
            graphics.moveTo(-7.5,-5);
            graphics.lineTo(-15,0);
            graphics.lineTo(-7.5,5);
        }

    }


}
