/**
 * Copyright leocavalcante ( http://wonderfl.net/user/leocavalcante )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dlFZ
 */

package
{
    import com.greensock.TweenMax;

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;

    public class Main extends Sprite
    {
        private const IMAGE_URL : String = "http://dl.dropbox.com/u/5208159/Pics/euavt3.jpg";
        private var loader : Loader;
        private var bitmap : Bitmap;
        private var canvas : Bitmap;
        private var container : Sprite;
        private var pixels : Vector.<uint>;
        private var numPixels : uint;
        private var displayedPixels : Array;
        private var num : Number;
        private var isMouseFollow : Boolean;

        public function Main()
        {
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoaderComplete);
            loader.load(new URLRequest(IMAGE_URL));

            container = new Sprite();

            canvas = new Bitmap(new BitmapData(550, 400));
            addChild(canvas);

            num = 50;

            stage.addEventListener(MouseEvent.CLICK, onStageClick);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        private function onStageClick(event : MouseEvent) : void
        {
            if (isMouseFollow)
            {
                isMouseFollow = false;

                for each (var pixel : Pixel in displayedPixels)
                {
                    TweenMax.to(pixel, 1, {x:pixel.defaultPoint.x, y:pixel.defaultPoint.y});
                }
            }
            else
            {
                isMouseFollow = true;
            }
        }

        private function onEnterFrame(event : Event) : void
        {
            canvas.bitmapData.dispose();
            canvas.bitmapData = new BitmapData(550, 400);
            canvas.bitmapData.draw(container);

            if (isMouseFollow)
                mouseFollow();
        }

        private function mouseFollow() : void
        {
            var i : int;

            for each (var pixel : Pixel in displayedPixels)
            {
                i++;

                pixel.x += (mouseX - pixel.x) / (i * .05);
                pixel.y += (mouseY - pixel.y) / (i * .05);
            }

            i = 0;
        }

        private function onLoaderComplete(event : Event) : void
        {
            loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onLoaderComplete);

            bitmap = loader.content as Bitmap;

            pixels = bitmap.bitmapData.getVector(new Rectangle(0, 0, bitmap.width, bitmap.height));
            numPixels = pixels.length;

            displayedPixels = [];

            for (var i : int = 0; i < bitmap.width; i += bitmap.width / num)
            {
                for (var j : int = 0; j < bitmap.height; j += bitmap.height / num)
                {
                    var rect : Rectangle = new Rectangle(i, j, bitmap.width / num, bitmap.height / num);

                    var bmd : BitmapData = new BitmapData(bitmap.width / num, bitmap.height / num);
                    bmd.copyPixels(bitmap.bitmapData, rect, new Point);

                    var pixel : Pixel = new Pixel(bmd);
                    pixel.defaultPoint.x = i;
                    pixel.defaultPoint.y = j;
                    pixel.x = i;
                    pixel.y = j;

                    container.addChild(displayedPixels[displayedPixels.length] = pixel);
                }
            }
        }
    }
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Point;

class Pixel extends Bitmap
{
    public var defaultPoint : Point = new Point();

    public function Pixel(bmd : BitmapData)
    {
        super(bmd);
    }
}
