/**
 * Copyright andyshang ( http://wonderfl.net/user/andyshang )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dkyF
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;


    [SWF(width="650", height="500")]
    public class FloysCanv extends Sprite
    {
        public static var NF:Number = 600;
        public static var KICK:Number = 0.05;
        public static var NUMNB:Number = 2;

        private var floys:Array;
        private var wa:int,ha:int,wc:int,hc:int;

        public function FloysCanv()
        {
            stage.frameRate = 100;

            var canvas:Shape = new Shape();
            var bitmap:Bitmap = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight));
            var filter:BlurFilter = new BlurFilter();
            var ct:ColorTransform = new ColorTransform(1.6, 1.6, 1.6);

            addChild(bitmap);

            addEventListener(Event.ENTER_FRAME, function(event:Event):void
            {
                canvas.graphics.clear();
                if (Math.random()< KICK)
                {
                    randemize();
                }
                floys.forEach(function(floy:Floy, i:int, arr:*):void
                {
                    floy.process();
                    draw(canvas.graphics, floy);
                });

                bitmap.bitmapData.colorTransform(bitmap.bitmapData.rect, ct);
                bitmap.bitmapData.draw(canvas);
                bitmap.bitmapData.applyFilter(bitmap.bitmapData, bitmap.bitmapData.rect, new Point(0,0), filter);
            });
            init();
        }

        public function init():void{
            floys = [];
            for (var i:int=0;i<NF;i++)
            {
                floys[i] = new Floy(NUMNB, stage.stageWidth-5, stage.stageHeight-5);
                floys[i].init();
            }
            randemize();
        }

        public function randemize():void{
            for (var k:int=0;k<NF;k++)
            {
                var ng:Floy = floys[k];
                for (var j:int=0;j<NUMNB;j++)
                {
                    var n:int = Math.random()*NF;
                    ng.neighbors[j] = floys[n];
                }
            }
        }

        private function draw(graphics:Graphics, f:Floy):void
        {
            graphics.beginFill(0x0);
            graphics.drawCircle(f.x, f.y, 2);
            graphics.endFill();
        }
    }
}

class Floy
{
    public var x:Number;
    public var y:Number;
    public var neighbors:Array = [];

    private var numnb:int;

    private var revdist:int = 1000;
    private var margin:int = 30;
    private var acc:Number = 0.3;
    private var acctomid:Number = 0.1;
    private var maxspeed:Number = 8;
    private var bouncespeed:Number = 0.8;
    private var v0:Number = 4;

    private var vx:Number;
    private var vy:Number;
    private var width:int;
    private var height:int;

    private var color:uint = 0x0;

    public function Floy(numnb:int, w:int, h:int)
    {
        this.numnb = numnb;
        width = w;
        height = h;
    }

    public function init():void
    {
        x =  Math.random()*(width-margin*2) + margin;
        y =  Math.random()*(height-margin*2) + margin;

        vx =  Math.random()*v0-v0/2;
        vy =  Math.random()*v0-v0/2;
    }


    public function dist(ng:Floy):int
    {
        var d1:int = x-ng.x;
        var d2:int = y-ng.y;
        return d1*d1+d2*d2;
    }


    private function updateNeighbors():void
    {
        var i:int=0;
        for (i=0;i<numnb;i++) {
            var ng:Floy = neighbors[i];;
            for (var j:int=0;j<numnb;j++) {
                if (dist(ng.neighbors[j]) < dist(ng))
                    neighbors[i]=ng.neighbors[j];
            }
        }

        for (i=0;i<numnb;i++) {
            if (neighbors[i] == this)
            {
                neighbors[i]=neighbors[i].neighbors[0];
            }
        }
    }

    private function adjustSpeed():void
    {
        var rev:int = -1;

        for (var i:int=0;i<numnb;i++)
        {
            var d:int = dist(neighbors[i]);
            rev = d == 0? 0 : (d < revdist ? -1:1);

            var sign:int;
            sign = x < neighbors[i].x ? 1: -1;
            vx += sign * acc * rev;
            sign = y < neighbors[i].y ? 1: -1;
            vy += sign * acc * rev;
        }

        if (vx > maxspeed) vx = maxspeed;
        if (vx < -maxspeed) vx = -maxspeed;
        if (vy > maxspeed) vy = maxspeed;
        if (vy < -maxspeed) vy = -maxspeed;

        if (x < 0) vx = bouncespeed;
        if (x > width) vx = -bouncespeed;
        if (y < 0) vy = bouncespeed;
        if (y > height) vy = -bouncespeed;

        if (x < width/2) vx += acctomid;
        if (x > width/2) vx -= acctomid;
        if (y < height/2) vy += acctomid;
        if (y > height/2) vy -= acctomid;
    }

    public function process():void
    {
        updateNeighbors();
        adjustSpeed();

        x += vx;
        y += vy;
    }
}