/**
 * Copyright 123strikeout ( http://wonderfl.net/user/123strikeout )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dkAa
 */

package {
    import caurina.transitions.Tweener;
    //import com.trick7.utils.TeraClock;
    import flash.display.*;
    import flash.text.*; 
    import flash.events.*;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import flash.utils.Timer;
    import flash.events.TimerEvent;

[SWF(width="500", height="500", backgroundColor="0x000000", frameRate="24")]
public class clock3D extends Sprite{

// _______________________________________________________________________
//vars

private var _camera:Camera3D;
private var _renderer:BasicRenderEngine;
private var space:Scene3D;
private var _viewport:Viewport3D;
private var color_val:int = 0x37CDFF;
private var clock:TeraClock;

private var cameraPitch:Number = 0;
private var cameraYaw:Number = 0;
private var cameraRoll:Number = 30;
private var cameraTarget:DisplayObject3D = DisplayObject3D.ZERO;

// _______________________________________________________________________
//constructor

public function clock3D(){

    _viewport = new Viewport3D(0,0,true,true);
    //_viewport.containerSprite.buttonMode = true;
    addChild(_viewport);
    _renderer = new BasicRenderEngine();
    _camera = new Camera3D();
    _camera.z = -1600;
    _camera.focus = 500;
    _camera.zoom = 1;
    space = new Scene3D();

    var format:TextFormat = new TextFormat();
    format.font = "helvetica";
    format.size = 50;
    format.color = 0xFFFFFF;


    for(var i:int=0;i<60;i++){

        //var _mycolor = new ColorTransform();
        if(i < 20){
            color_val -= 0x000010;
        }else
        if(i >= 20 && i < 40){
            color_val -= 0x100000;
        }else
        if(i >= 40)
        {
             color_val -= 0x001000;   
        }

        var plate:Shape=new Shape();
        plate.graphics.beginFill(color_val); 
        plate.graphics.drawRoundRect(0,0,100,100,10);
        plate.graphics.endFill(); 
        //
        //_mycolor.color = color_val;
        //plate.transform.colorTransform = _mycolor;

        var _text:TextField = new TextField();
        _text.defaultTextFormat = format;
        _text.wordWrap = false;
        _text.autoSize = TextFieldAutoSize.CENTER;
        _text.width = 100;
        _text.x = 50;
        _text.y = 30;
        _text.text = String(i);
    
        //角丸とテキストをMCにまとめる
        var mc:MovieClip = new MovieClip(); 
        mc.addChild(plate);
        mc.addChild(_text);
        mc.alpha = 0.75;
        
        //MCを3D objectに内包
        var material:MovieMaterial = new MovieMaterial( mc, true)
        material.oneSide = false;
        material.smooth = true;
        
        //一番外側のコンテナ
        var wire:WireframeMaterial =  new WireframeMaterial(0xFFFFFF, 0, 1);
        var container:Plane = new Plane(wire,10, 10,0,0);
        container.name = "container"+String(i);
        container.alpha = 0;
        
        var _plane:Plane = new Plane(material, 100, 100);
        _plane.name = "plane"+String(i);
        
        space.addChild(container);
        container.addChild(_plane);

        Tweener.addTween( container, {
            x            :Math.sin(i*6*(Math.PI/180))*600 ,
            y            :0,
            z            :Math.cos(i*6*(Math.PI/180))*600 ,
            rotationX    :0,
            rotationY    :i*6 +90,
            rotationZ    :0,
            time        :2,
            transition    :"easeOutSine"
        });
    }//end loop

    addEventListener(Event.ENTER_FRAME, _onEnterFrame);
    clocksecond();

}

// _______________________________________________________________________
//Event
private function _onEnterFrame(e:Event):void{
    //cameraPitch +=  0.6;
    //cameraYaw += 0.4 ;
    //_cameraRoll += 0.2;
    //_camera.roll(cameraRoll);
    cameraPitch += ((stage.stageHeight / 2 - mouseY) / 2 - cameraPitch) / 20 ;
    cameraYaw += ((stage.stageWidth / 2 - mouseX) / 2 - cameraYaw) / 20 ;
    _camera.orbit(cameraPitch, cameraYaw, true, cameraTarget);
    _renderer.renderScene(space, _camera, _viewport);
    
}

// _______________________________________________________________________
//clock
private function clocksecond() {
clock = new TeraClock();
clock.addEventListener(TeraClock.SECONDS_CHANGED, secondsListener);
}

private function secondsListener(e:Event):void {
    var sec = clock.seconds;
    if(sec == 0 ){
        zeroEvent();
    }else{

        var tgt = space.getChildByName("container"+ String(sec)).getChildByName("plane" + String(sec));
        //trace(space.getChildByName("container"+ String(sec)).getChildIndex(tgt));
        //getChildAtが使えない
        tgt.scaleX = tgt.scaleY = 2;
        tgt.rotationZ = 360;
        Tweener.addTween(tgt , {
            scaleX        :1,
            scaleY        :1,
            rotationZ    :0,
            time        :2,
            transition    :"easeOutBack"
        } );
    }
}


private function zeroEvent():void {
    
    for(var i:int=0;i<60;i++){
        var tgt = space.getChildByName("container"+ String(i)).getChildByName("plane" + String(i));
        tgt.scaleX = tgt.scaleY = 2;
        tgt.rotationZ = 360;
        Tweener.addTween(tgt , {
            scaleX        :1,
            scaleY        :1,
            rotationZ    :0,
            time        :2,
            transition    :"easeOutBack"
        });
    }
}


}
}

/*
teraclock
http://www.libspark.org/wiki/trick7/TeraClock
*/

import flash.display.*;
import flash.events.Event;
import flash.events.EventDispatcher;  

class TeraClock extends Sprite {
        public static const HOURS_CHANGED:String = "hoursChanged";
        public static const MINUTES_CHANGED:String = "minutesChanged";
        public static const SECONDS_CHANGED:String = "secondsChanged";
        private var _hours:int;
        private var _minutes:int;
        private var _seconds:int;
        private var _preSeconds:int;
        private var _gmt:int;
        public function TeraClock(GMT:int = 9) {
            _gmt = GMT%24;
            this.enterFrameListener(null);
            addEventListener(Event.ENTER_FRAME, enterFrameListener);
        }
        
        private function enterFrameListener(e:Event):void {
            var date:Date = new Date();
            if(_gmt>=0){
                _hours = (date.getUTCHours() + _gmt) % 24;
            }else {
                _hours = (24+(date.getUTCHours() + _gmt)) % 24;
            }
            _minutes = date.getUTCMinutes();
            _seconds = date.getUTCSeconds();
            if (_seconds != _preSeconds) {
                dispatchEvent(new Event(SECONDS_CHANGED));
                if (_seconds == 0) {
                    dispatchEvent(new Event(MINUTES_CHANGED));
                    if (_minutes == 0) {
                        dispatchEvent(new Event(HOURS_CHANGED));
                    }
                }
            }
            _preSeconds = _seconds;
        }
        public function get hours():int { return _hours; }
        public function get minutes():int { return _minutes; }
        public function get seconds():int { return _seconds; }
        public function get milliseconds():int { return (new Date()).getUTCMilliseconds(); }
        
        public function get hoursUpper():int { return _hours / 10; }
        public function get minutesUpper():int { return _minutes / 10; }
        public function get secondsUpper():int { return _seconds / 10; }
        
        public function get hoursLower():int { return _hours % 10; }
        public function get minutesLower():int  { return _minutes % 10; }
        public function get secondsLower():int { return _seconds % 10; }
        
        public function get hours2():String { return niketa(_hours); }
        public function get minutes2():String { return niketa(_minutes); }
        public function get seconds2():String { return niketa(_seconds); }
        
        public function get milliseconds2():String { return niketa((new Date()).getUTCMilliseconds() / 10); }
        
        public function get milliseconds3():String { return keta((new Date()).getUTCMilliseconds(), 3); }
        
        private function niketa(num:int):String {
            if (num < 10) {
                return String("0"+num);
            }else {
                return String(num);
            }
        }
        
        private function keta(num:int, keta:int):String {
            var str:String = String(num);
            while(str.length < keta) str = "0" + str;
            return str;
        }
        
        public function get hoursDegree():Number {
            return ((_hours % 12) * 30) + (_minutes / 2) + (_seconds/120);
        }
        public function get minutesDegree():Number {
            return (_minutes * 6) + (_seconds / 10);
        }
        public function get secondsDegree():Number {
            return _seconds * 6;
        }
        
        public function getDifferenceTime(s:int, m:int, h:int):Object {
            var time:Array = [_seconds, _minutes, _hours, 0];
            var dt:Array   = [s, m, h];
            var cap:Array  = [60, 60, 24];
            for(var i:int = 0; i < 3; ++i) {
                time[i] += dt[i];
                if(time[i] < 0) {
                    time[i + 1] += Math.floor(time[i] / cap[i]);
                    time[i] = time[i] % cap[i] + cap[i];
                    continue;
                }
                if(time[i] >= cap[i]) {
                    time[i + 1] += Math.floor(time[i] / cap[i]);
                    time[i] = time[i] % cap[i];
                    continue;
                }
            }
            return { seconds:time[0], minutes:time[1], hours:time[2], date:time[3] };
        }
}

