/**
 * Copyright yuuganisakase ( http://wonderfl.net/user/yuuganisakase )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/diu3
 */

// Ornamental Heart  revised  
//

package  
{
	import flash.events.Event;
	import flash.events.MouseEvent;
	import org.papervision3d.core.geom.Lines3D;
	import org.papervision3d.core.geom.renderables.Line3D;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.LineMaterial;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import fl.motion.easing.Linear;
	import flash.display.Sprite;

	
	[SWF(width=465, height=465, frameRate=12, backgroundColor=0x222222)]
	public class OrnamentalBraid extends Sprite
	{
		private var lm:LineMaterial;
		private var lines:Lines3D;
		private var plane:Plane;
		
		private var cameraF:Number;
		private var cameraR:Number;
		
		private var model:Model;
		private var view:View;
		public static var count:int = 0;
		private var clickCount:int = 0;
		private var waitCount:int = 30;;
		
		
		public function OrnamentalBraid() 
		{
                          Wonderfl.capture_delay( 19);
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage.addEventListener(Event.ENTER_FRAME, onEnter);
			stage.addEventListener(MouseEvent.CLICK, onClick);
			setUp(1, 8, 1, 0, 0);
		}
		
		private function onClick(e:MouseEvent):void 
		{
			clickCount += 1;
			dispose();
			if (clickCount % 3 == 0) {
				setUp(1,8, 1, 0, 0,10);
				
			}else if (clickCount % 3 == 1) {
				setUp(14, 11, 1, 1, 0,30);
				
			}else {
				setUp(7, 6, 4, 0.5, 1.5,45);
					
			}
		}
		private function dispose():void
		{
			count = 0;
			model.dispose();
			view.dispose();
			removeChild(view);
		}
		private function setUp(xx:int, yy:int, zz:int, _cameraR:Number, _cameraF:Number, _waitCount:int = 20):void
		{
			model = new Model(xx,yy,zz);
			view = new View(model);
			addChild(view);
			cameraF = _cameraF;
			cameraR = _cameraR;
			waitCount = _waitCount;

		}
		private function onEnter(e:Event):void 
		{
			count += 1;
			model.update();
			if (count < waitCount) {
							

				view.update(false);
				model.disposeAfterAnimated();
				model.update();
				view.update(false);
				model.disposeAfterAnimated();
				model.update();
				view.update(false);
		        	model.disposeAfterAnimated();
				model.update();
				view.update(false);


			}else {
				view.update(true);
				
			}
			model.disposeAfterAnimated();
			view.base.camera.moveForward(cameraF);
			view.base.camera.moveRight(cameraR);
		}
		
	}
}



import com.flashdynamix.motion.effects.core.FilterEffect;
import com.flashdynamix.motion.layers.BitmapLayer;
import org.libspark.betweenas3.tweens.ITweenGroup;

import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.display.Shape;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
import org.libspark.betweenas3.tweens.ITween;
import org.papervision3d.core.math.Number3D;
import org.papervision3d.core.render.command.RenderLine;
import org.papervision3d.core.render.data.RenderSessionData;
import org.papervision3d.objects.DisplayObject3D;
import org.papervision3d.objects.primitives.Plane;
import org.papervision3d.view.BasicView;
import org.papervision3d.materials.ColorMaterial;
import org.papervision3d.core.geom.Lines3D;
import org.papervision3d.core.geom.renderables.Vertex3D;
import org.papervision3d.core.geom.renderables.Line3D;
import org.papervision3d.materials.special.LineMaterial;
import flash.display.Sprite;
import flash.geom.Point;
import flash.text.TextField;
import flash.text.TextFormat;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Linear;
import flash.display.BlendMode;

	class Model
	{
		public static var Xnum:int = 7;
		public static var Ynum:int = 7;
		public static var Znum:int = 4;
		public var field:Vector.<Vector.<Vector.<FieldObject>>>;
		
		public var nodeArray1:Vector.<Node>;
		public var nodeArray2:Vector.<Node>;
		
		private var iterator:Iterator;
		private var pool:NodePool;
		public function Model(_x:int, _y:int, _z:int)
		{
			Xnum = _x;
			Ynum = _y;
			Znum = _z;
			init();
		}
		
		public function init():void
		{
			nodeArray1 =  new Vector.<Node>;
			nodeArray2 =  new Vector.<Node>;
			field = new Vector.<Vector.<Vector.<FieldObject>>>(Model.Xnum, true);					
			pool = new NodePool(field);
			for(var i:int = 0; i < Xnum; i++)
			{
				field[i] = new Vector.<Vector.<FieldObject>>(Model.Ynum, true);
				for (var ii:int = 0; ii < Ynum; ii++)
				{
					field[i][ii] = new Vector.<FieldObject>(Model.Znum, true);
				}
			}
			for(var xx:int = 0; xx < Model.Xnum; xx++)
			{
				for(var yy:int = 0; yy < Model.Ynum; yy++)
				{
					for (var zz:int = 0; zz < Model.Znum; zz++)
					{
						field[xx][yy][zz] = new FieldObject();
					}
				}
			}
			var nn:int = 1;
	
			for(var ll:int = 0; ll < nn; ll++)
			{
				addNodeAtRandomPoint();
			}
			
			iterator = new Iterator(nodeArray1);
		}
		
		private function addNodeAtRandomPoint():void
		{
				var xx:int = Math.random() * Xnum << 0;
				var yy:int = Math.random() * Ynum << 0;
				var zz:int = Math.random() * Znum << 0;
				if (field[xx][yy][zz] .direction.x == 0)
				{
					var node:Node = pool.getNode(xx, yy, zz, field);// new Node(xx, yy, zz, field);
					node.originFlag = true;
					nodeArray2.push(node);
					field[xx][yy][zz].direction.x = (Math.random() > 0.5)? 1: -1;
					field[xx][yy][zz].direction.y = (Math.random() > 0.5)? 1: -1;
					field[xx][yy][zz].direction.z = (Math.random() > 0.5)? 1: -1;
					field[xx][yy][zz].isBranch = true;
					field[xx][yy][zz].animationOK = true;
				}	
		}
		
		public function disposeAfterAnimated():void
		{
			var len:int = nodeArray1.length;
			for (var i:int = 0; i < len; i++) 
			{
				if (nodeArray1[i].disposeFlag == true)
				{
					pool.disposeNode(nodeArray1[i]);
					nodeArray1.splice(i, 1);
					len -= 1;
				}
			}
			len = nodeArray2.length;
			for (var j:int = 0; j < len; j++) 
			{
				if (nodeArray2[j].disposeFlag == true)
				{
					pool.disposeNode(nodeArray2[j]);
					nodeArray2.splice(j, 1);
					len -= 1;
				}
			}
		}
		public function update(cc:int = 2 ):void
		{
			trace("ar1 = " + nodeArray1.length + "ar2 = " + nodeArray2.length);
			
			for(var i:int = 0; i < cc; i++)
			{
				var node:Node = (iterator.next() as Node);
				
				if(node != null)
				{			
						var ar:Array = node.move();
					
						if(ar[0] != -1)
						{
							nodeArray2.push(pool.getNode(ar[1].x, ar[1].y,ar[1].z, field) );
						}				

				}else {				
					var temp:Vector.<Node> = nodeArray1;
					nodeArray1 = nodeArray2;
					nodeArray2 = temp;
					iterator = new Iterator(nodeArray1);
					if(animeProbability()) addNodeAtRandomPoint();
				}	
			}
			
		}
		private function animeProbability():Boolean
		{
			if (Math.random() > 0.9) {
				return true;
			}else {
				return false;
			}
		}
		public function dispose():void
		{
			
			field = null;
			nodeArray1 = null;
			nodeArray2 = null;
			pool.dispose();
			pool = null;
			iterator = null;
		}
		
	}
	class Iterator
	{
		private var ar:Vector.<Node>;
		private var counter:int;
		private var lastObject:*;
		public function Iterator(_ar:Vector.<Node>)
		{
			ar = _ar;
			counter = 0;
			
		}
		public function next():*
		{
			counter += 1;
			if(ar.length >= counter){
				lastObject = ar[counter-1];
				return lastObject;
			}else{
				return null;				
			}
		}		
	}
	class NodePool
	{
		private var nodeArray:Vector.<Node>;
		public function NodePool(_field:Vector.<Vector.<Vector.<FieldObject>>>)
		{
			nodeArray = new Vector.<Node>;
			for (var i:int = 0; i < 100; i++) {
				
				nodeArray.push(new Node(0, 0, 0));
			}
		}
		
		public function getNode(_x:int, _y:int, _z:int, _field:Vector.<Vector.<Vector.<FieldObject>>>):Node
		{
			var node:Node;
			if (nodeArray.length >= 1) 
			{
				node = nodeArray.pop();
				node.x = _x;
				node.y = _y;
				node.z = _z;
				node.movingFlag = new Array( -1, -1);
				node.disposeFlag = false;
				node.originFlag = false;
				node.field = _field;
			}else 
			{
				node = new Node(_x, _y, _z, _field);
			}
			return node;
		}
		public function disposeNode(n:Node):void
		{
			nodeArray.push(n);
			n.dispose();
		}
		public function dispose():void
		{
			nodeArray.length = 0;
		}
	}

	class Node
	{
		public var field:Vector.<Vector.<Vector.<FieldObject>>>;
		private static const CurveFac:Number = 0.5;
		public var x:int;
		public var y:int;
		public var z:int;
		public var movingFlag:Array = new Array( -1, -1);
		public var disposeFlag:Boolean = false;
		public var originFlag:Boolean = false;
		private var kinds:int;
		public function Node(_x:int, _y:int,_z:int, _field:Vector.<Vector.<Vector.<FieldObject>>> = null)
		{
			super();
			this.x = _x;
			this.y = _y;
			this.z = _z;
			if(_field != null) field = _field;
		}
		
		public function move():Array
		{
			if (field[0][0].length == 1)
			{
				kinds = 4;
			}else {
				kinds = 6;
			}
			var ran:int = (Math.random()*kinds << 0);
			
			for(var i:int = 0; i < 5; i++)
			{
				if(ran == 0){
					if(canMoveX() )
					{
						movingFlag = moveX();
						return movingFlag;
					}
				}else if(ran == 1){
					if(canMoveY() )
					{
						movingFlag = moveY();
						return movingFlag;
					}
				}else if (ran == 2) {
					if (canMoveXY() )
					{
						movingFlag = moveXY();
						return movingFlag;
					}
				}else if (ran == 3) {
					if (canMoveZ()) {
						movingFlag = moveZ();
						return movingFlag;
					}
				}else if (ran == 4) {
					if (canMoveXZ()) {
						movingFlag = moveXZ();
						return movingFlag;
					}
				}else if (ran == 5) {
					if (canMoveYZ()) {
						movingFlag = moveYZ();
						return movingFlag;
					}
				}
				ran = (Math.random()*kinds << 0)
			}
			movingFlag = new Array( -1, field[x][y][z].isBranch, new Point3D(x, y, z), field[x][y][z].direction);
			disposeFlag = true;
			return movingFlag;
			
		}
		private function canMoveX():Boolean
		{
			var newX:int = this.x + field[x][y][z].direction.x;
			return newX>=0 && newX<Model.Xnum && field[newX][this.y][z].direction.x==0;
		}
		private function moveX():Array
		{
			var newX:int = this.x + field[x][y][z].direction.x;
 			field[newX][y][z].direction.x =  field[x][y][z].direction.x;
			field[newX][y][z].direction.y = -(field[x][y][z].direction.y);
			field[newX][y][z].direction.z = -field[x][y][z].direction.z;
			field[x][y][z].isBranch = true;
			return new Array(new Point3D(x, y, z),
							 new Point3D(newX, y, z),
							 new Point3D( (x + newX) * 0.5, y + field[x][y][z].direction.y * CurveFac , z+field[x][y][z].direction.z*CurveFac)
							 );
		}
		
		private function canMoveZ():Boolean
		{
			var newZ:int = this.z + field[x][y][z].direction.z;
			return newZ >= 0 && newZ < Model.Znum && field[x][y][newZ].direction.z == 0;
		}
		
		private function moveZ():Array
		{
			var newZ:int = this.z + field[x][y][z].direction.z;
 			field[x][y][newZ].direction.x = -(field[x][y][z].direction.x);
			field[x][y][newZ].direction.y = -(field[x][y][z].direction.y);
			field[x][y][newZ].direction.z = field[x][y][z].direction.z;
			field[x][y][z].isBranch = true;
			return new Array(new Point3D(x, y, z),
							 new Point3D(x, y, newZ),
							 new Point3D( (x + field[x][y][z].direction.x*CurveFac), y + field[x][y][z].direction.y * CurveFac , (z+newZ)*0.5)
							 );
		}
		
		private function canMoveY():Boolean
		{
			var newY:int = this.y + field[x][y][z].direction.y;
			return newY>=0 && newY<Model.Ynum && field[x][newY][z].direction.y==0;
		}
		private function moveY():Array
		{
			var newY:int = this.y + field[x][y][z].direction.y;
			field[x][newY][z].direction.x = -(field[x][y][z].direction.x);
			field[x][newY][z].direction.y = field[x][y][z].direction.y;
			field[x][newY][z].direction.z = -field[x][y][z].direction.z;
			field[x][y][z].isBranch = true;
			return new Array(
								new Point3D(x, y, z) ,
								new Point3D(x, newY, z) ,
								new Point3D(x + field[x][y][z].direction.x * CurveFac, (y + newY) * 0.5, z+field[x][y][z].direction.z*CurveFac)
							);
		}
		private function canMoveXY():Boolean
		{
			var newX:int = this.x + field[x][y][z].direction.x;
			var newY:int = this.y + field[x][y][z].direction.y;
			
			return newX >= 0 && newX < Model.Xnum && newY >= 0 && newY < Model.Ynum && field[newX][newY][z].direction.y == 0 &&
					(newX + field[newX][y][z].direction.x != x || y + field[newX][y][z].direction.y != newY) && 
					(x + field[x][newY][z].direction.x != newX || newY + field[x][newY][z].direction.y != y);
		}
		private function moveXY():Array
		{
			var newX:int = this.x + field[x][y][z].direction.x;
			var newY:int = this.y + field[x][y][z].direction.y;
			field[x][y][z].isBranch = true;
			field[newX][newY][z].direction.x = field[x][y][z].direction.x;
			field[newX][newY][z].direction.y = field[x][y][z].direction.y;
			field[newX][newY][z].direction.z = -field[x][y][z].direction.z;
			return new Array(new Point3D(x, y, z), new Point3D(newX, newY, z), 
								new Point3D((x + newX) * 0.5, (y + newY) * 0.5, z + field[x][y][z].direction.z * CurveFac)
							);
		}
		
		private function canMoveXZ():Boolean
		{
			var newX:int = this.x + field[x][y][z].direction.x;
			var newZ:int = this.z + field[x][y][z].direction.z;
			
			return newX >= 0 && newX < Model.Xnum && newZ >= 0 && newZ < Model.Znum && field[newX][y][newZ].direction.x == 0 &&
					(newX + field[newX][y][z].direction.x != x || z + field[newX][y][z].direction.z != newZ ) && 
					(x + field[x][y][newZ].direction.x != newX || newZ + field[x][y][newZ].direction.z != z ) ;
		}
		private function moveXZ():Array
		{
			var newX:int = this.x + field[x][y][z].direction.x;
			var newZ:int = this.z + field[x][y][z].direction.z;
			field[x][y][z].isBranch = true;
			field[newX][y][newZ].direction.x = field[x][y][z].direction.x;
			field[newX][y][newZ].direction.y = -field[x][y][z].direction.y;
			field[newX][y][newZ].direction.z = field[x][y][z].direction.z;
			return new Array(
								new Point3D(x, y, z),
								new Point3D(newX, y, newZ), 
								new Point3D( (x + newX) * 0.5, y + field[x][y][z].direction.y * CurveFac , (z+newZ)*0.5)
							);
		}
		
		private function canMoveYZ():Boolean
		{
			var newY:int = this.y + field[x][y][z].direction.y;
			var newZ:int = this.z + field[x][y][z].direction.z;
			
			return newY >= 0 && newY < Model.Ynum && newZ >= 0 && newZ < Model.Znum && field[x][newY][newZ].direction.x == 0 &&
					(newY + field[x][newY][z].direction.y != y || z + field[x][newY][z].direction.z != newZ ) && 
					(y + field[x][y][newZ].direction.y != newY || newZ + field[x][y][newZ].direction.z != z ) ;
		}
		private function moveYZ():Array
		{
			var newY:int = this.y + field[x][y][z].direction.y;
			var newZ:int = this.z + field[x][y][z].direction.z;
			field[x][y][z].isBranch = true;
			field[x][newY][newZ].direction.x = -field[x][y][z].direction.x;
			field[x][newY][newZ].direction.y = field[x][y][z].direction.y;
			field[x][newY][newZ].direction.z = field[x][y][z].direction.z;
			return new Array(
								new Point3D(x, y, z),
								new Point3D(x, newY, newZ), 
								new Point3D( x + field[x][y][z].direction.x*CurveFac, (y+newY)*0.5, (z+newZ)*0.5)
							);
		}

		// new Point3D( (x + newX) * 0.5, y + field[x][y][z].direction.y * 0.33 , z+field[x][y][z].direction.z*0.33)

		public function dispose():void
		{
			field = null;
		}
	}

	class FieldObject
	{	
		public var pos:Point3D = new Point3D(0,0,0);
		public var direction:Point3D = new Point3D(0,0,0);
		public var isBranch:Boolean = false;
		public var animationOK:Boolean = false;
		
		public function FieldObject():void
		{
		}
	}

	
	
	class View extends BitmapLayer
	{
		private const Margin:int = 0;
		private const LineSize:int = 3;
		private const WeightFac:Number = -33;
        private const col:uint = 0x668855;
		public var base:BasicView;
		
		public static var xSize:Number;
		public static var ySize:Number; 
		public static var zSize:Number;

		private var plane:Plane;
		private var lines:Lines3D;
		private var model:Model;
		private var renderList:Vector.<RenderObject> = new Vector.<RenderObject>();
		private var renderPool:RenderObjectPool = new RenderObjectPool();
		
		
		
		public function View(m:Model)
		{
			super(465, 465, 1, 0x222222, false, true);
			model = m;
			View.xSize =  (Util.WID-Margin)/Model.Xnum;
			View.ySize = (Util.HEI-Margin)/Model.Ynum;
			View.zSize = View.xSize*2;		
			
			base = new BasicView(465, 465, false, false, "Target");
			var cm:ColorMaterial = new ColorMaterial(0x111111);

			base.camera.z = -411;
			base.camera.x = -51;
			base.camera.y = 51;
			var target:DisplayObject3D = new DisplayObject3D();
			target.z = Model.Znum/2 * zSize;
			base.camera.target = target;
			lines = new Lines3D(new LineMaterial(col,0.9));
			base.scene.addChild(lines);
						
			this.draw(base);			
			this.clearOnRender = true;
			
			base.startRendering();

			this.add(new FilterEffect(new BlurFilter(2, 2, 1)));
		}
					
		
		public function update(draw:Boolean = true):void
		{
			displayMovingLine(model.nodeArray1);
			displayMovingLine(model.nodeArray2);
			if(draw) drawStart();
		}
		
		private function drawStart():void
		{
			trace("render list length" + renderList.length);
			var len:int = renderList.length;
			if (len >= 50) len = 50;
			for (var i:int = 0; i < len; i++) 
			{
				
				var pos:Point3D = new Point3D(renderList[i].fp.x, renderList[i].fp.y, renderList[i].fp.z);
				
				
				if (model.field[pos.x][pos.y][pos.z].animationOK == true) 
				{
					renderList[i].render();
					renderPool.disposeObject(renderList[i]);
					renderList.splice(i, 1);
					len -= 1;
				}
			}
		}
		private function displayMovingLine(ar1:Vector.<Node>):void
		{
			for each(var node:Node in ar1)
			{
				if (node.originFlag == true) 
				{
					drawOriginCircle(node, node.z);
					node.originFlag = false;
				}
				if(node.movingFlag[0] != -1) // animated?
				{
					renderList.push(renderPool.getObject(drawCurve, node, 0));//new RenderObject(drawCurve, node));
					//drawCurve(start, end, control, node.z, node);
					node.movingFlag[0] = -1;
				}else if (node.movingFlag[1] == false)  // isbranch?
				{
					renderList.push(renderPool.getObject(drawHeart, node, 1));// new RenderObject(drawHeart, node, 1));
					node.movingFlag[1] = true;
				}				
			}
		}
		private function drawOriginCircle(node:Node, weight:Number ):void
		{
			var po:Point3D = getRealPosFromField(new Point3D(node.x, node.y, node.z) );
			
			var size:int = 4;
			var v1:Vertex3D = new Vertex3D(po.x - size, po.y, po.z);
			var v2:Vertex3D = new Vertex3D(po.x ,po.y + size, po.z);
			var v3:Vertex3D = new Vertex3D(po.x + size, po.y , po.z);
			var v4:Vertex3D = new Vertex3D(po.x , po.y - size, po.z);

			var aa:Number = 0.7;
			var cc:uint = 0xfaa9933;
			var ll1:Line3D = new Line3D(lines, new LineMaterial(cc,aa),  LineSize, v1, v2);
			var ll2:Line3D = new Line3D(lines, new LineMaterial(cc,aa),  LineSize, v2, v3);
			var ll3:Line3D = new Line3D(lines, new LineMaterial(cc,aa),  LineSize, v3, v4);
			var ll4:Line3D = new Line3D(lines, new LineMaterial(cc,aa),  LineSize, v4, v1);
			lines.addLine(ll1);
			lines.addLine(ll2);
			lines.addLine(ll3);
			lines.addLine(ll4);
		}
		
		private function drawCurve(start:Point3D, end:Point3D, control:Point3D, weight:Number, eP:Point3D):void
		{
			
			var aa:Number = 0 + weight+1/(Model.Znum);
			var po1:Point3D = new Point3D(start.x-1, start.y-1, start.z-1);
			var po2:Point3D = new Point3D(start.x, start.y, start.z);
			var po3:Point3D = new Point3D(start.x+1, start.y+1, start.z+1);

			var prev1:Point3D = po1.clone();
			var prev2:Point3D = po2.clone();
			var prev3:Point3D = po3.clone();
			
			var t1:ITween;
			var t2:ITween;
			var t3:ITween;
			
			var dur:Number = 1;
            BetweenAS3.parallel(
				t1 = BetweenAS3.bezierTo(po1, { x:end.x-1, y:end.y-1, z:end.z-1 }, { x:control.x, y:control.y, z:control.z }, dur, Linear.easeNone),
                t2 = BetweenAS3.bezierTo(po2, { x:end.x, y:end.y, z:end.z }, { x:control.x, y:control.y, z:control.z }, dur, Linear.easeNone),
				t3 = BetweenAS3.bezierTo(po3, { x:end.x+1, y:end.y+1, z:end.z+1 }, { x:control.x, y:control.y, z:control.z }, dur, Linear.easeNone)
             ).play();
			
			t1.onUpdate = movingPoint;
			t1.onUpdateParams = [po1, prev1,aa];
			t2.onUpdate = movingPoint;
			t2.onUpdateParams = [po2, prev2,aa];
			t3.onUpdate = movingPoint;
			t3.onUpdateParams = [po3, prev3,aa];
			
			t1.onComplete = movingEnd;
			t1.onCompleteParams = [eP]
		
		}
			private function movingPoint(pp:Point3D, prev:Point3D, aa:Number):void
			{
					var v1:Vertex3D = new Vertex3D(prev.x, prev.y, prev.z);
					var v2:Vertex3D = new Vertex3D(pp.x, pp.y, pp.z);
					var line:Line3D = new Line3D(lines, new LineMaterial(col, aa), 1, v1, v2);
					lines.addLine(line);
					prev.x = pp.x;
					prev.y = pp.y;
					prev.z = pp.z;

			}
			
			private function movingEnd(pos:Point3D):void
			{
				if(model != null) model.field[pos.x][pos.y][pos.z].animationOK = true;
			}
		private function drawHeart(pp:Point3D, dir:Point3D, weight:Number):void
		{
			var po:Point3D = pp;// getRealPosFromField(new Point3D(pp.x, pp.y, pp.z) );
						var aa:Number = 0.8;
						weight =  4;
			var size:int = 1;
			var cm:ColorMaterial = new ColorMaterial(0xeeaa77,0.8);
			
			var sphere:org.papervision3d.objects.primitives.Sphere = new org.papervision3d.objects.primitives.Sphere(cm,5,1,1);
			base.scene.addChild(sphere);
			
			base.viewport.getChildLayer(sphere).filters = [new GlowFilter(0xf87744, 0.9, 8,8,2,2)];
			base.viewport.getChildLayer(sphere).blendMode = BlendMode.ADD;

			sphere.x = pp.x;
			sphere.y = pp.y;
			sphere.z = pp.z;
			BetweenAS3.from(base.viewport.getChildLayer(sphere), { alpha:0 }, 2).play();
			
/*			var v1:Vertex3D = new Vertex3D(po.x - size, po.y - size, po.z);
			var v2:Vertex3D = new Vertex3D(po.x - size, po.y + size, po.z);
			var v3:Vertex3D = new Vertex3D(po.x + size, po.y + size, po.z);
			var v4:Vertex3D = new Vertex3D(po.x + size, po.y - size, po.z);
			var cccc:uint = 0xee5511;
			var ll1:Line3D = new Line3D(lines, new LineMaterial(cccc,aa),  weight, v1, v2);
			var ll2:Line3D = new Line3D(lines, new LineMaterial(cccc,aa),  weight,v2, v3);
			var ll3:Line3D = new Line3D(lines, new LineMaterial(cccc,aa),  weight, v3, v4);
			var ll4:Line3D = new Line3D(lines, new LineMaterial(cccc,aa),  weight, v4, v1);
			lines.addLine(ll1);
			lines.addLine(ll2);
			lines.addLine(ll3);
			lines.addLine(ll4);
*/

/*			var sh:Shape = new Shape();
			var sp:Sprite = new Sprite();
			//sp.addChild(sh);
			holder.addChild(sh);
			tween.fromTo(sh, { alpha:0 }, { alpha:1 }, 2);
			sh.x = po.x;
			sh.y = po.y;
			
			
			var gra:GraphicsEx = new GraphicsEx(sh.graphics);
			
			var sca :Number= 0.09;
			var rad:Number = 40*sca;
			 var size:Number = 50*sca;
			 var posScale:Number = 0;
			 
			 var random1:Number = 1;
			 var random2:Number = 1;
			 var random3:Number = 1;
			 var random4:Number = 1;
			 var random5:Number = 1;
			 var random6:Number = 1;
			 var xx:Number = 0;
			 var yy:Number = 0;
			 var p1:Point = new Point(xx+random5*posScale, yy+size+random6*posScale);
			 var p3:Point = new Point(xx+random1*posScale, yy-size+random3*posScale);
			 var p2:Point = new Point(xx-size*1.4*random2, yy-size+random4*posScale);
			 var p4:Point = new Point(xx+size*1.4*random3, yy-size+random5*posScale);
			 
			 var c1:Point = new Point(xx-rad*0.5*random1, yy);
			 var c3:Point = new Point(xx-size-rad*0.5*random2, yy-size-rad);
			 var c2:Point = Point.interpolate(c3,p2,-0.8);
			 var c4:Point = new Point((p2.x+p3.x)/2+rad*0.4*random3, yy-size-rad*1.5);
			 
			 var c8:Point = new Point((p3.x+p4.x)/2-rad*0.4*random4, yy-size-rad*1.5);
			 var c7:Point = new Point(xx+size+rad*0.5*random5, yy-size-rad);
			 var c6:Point = Point.interpolate(c7,p4,-0.8);
			 var c5:Point = new Point(xx + rad * 0.5 * random6, yy);
			 
			 gra.lineStyle(LineSize,col,1);
			 gra.moveTo(p1.x, p1.y);
			 gra.bezierTo(c1.x, c1.y, c2.x, c2.y, p2.x, p2.y);
			 gra.bezierTo(c3.x, c3.y, c4.x, c4.y, p3.x, p3.y);
			 
			 gra.bezierTo(c8.x, c8.y, c7.x, c7.y, p4.x, p4.y);
			 gra.bezierTo(c6.x, c6.y, c5.x, c5.y, p1.x, p1.y);
			
			if (dir.x == 1 ) {
				if (dir.y == 1) {
					sh.rotation = 135;
					sh.x += 2;
					sh.y += 2;
				}else if (dir.y == -1) {
					sh.rotation = 45;
					sh.x += 2;
					sh.y -= 2;
				}
			}else {
				if (dir.y == 1) {
					sh.rotation = 225;
					sh.x -= 2;
					sh.y += 2;
				}else if (dir.y == -1) {
					sh.rotation = -45;
					sh.x -= 2;
					sh.y -= 2;
				}
			}
*/		
		}
		
		private function getRealPosFromField(node:Point3D):Point3D
		{
			var point:Point3D = new Point3D(node.x * View.xSize + View.xSize / 2 - 465 / 2,
											  node.y * View.ySize + View.ySize / 2 - 465 / 2,
											  node.z * View.zSize + View.zSize / 2);		
			return point;	
		}
		override public function dispose():void
		{
			super.dispose();
			base.viewport.containerSprite.removeAllLayers();
			base.stopRendering();
			base = null;
			model = null;
			renderList.length = 0;
			renderList = null;
			renderPool.dispose();
			renderPool = null;
			lines.removeAllLines();
		}
	}

	class RenderObjectPool
	{
		private var objectPool:Vector.<RenderObject>
		public function RenderObjectPool():void
		{
			objectPool = new Vector.<RenderObject>();
			for (var i:int = 0; i < 90; i ++) {
				objectPool.push(new RenderObject(function():void { }, new Node(0, 0, 0),-1) );
			}
		}
		public function getObject(f:Function, n:Node, fla:int = 0):RenderObject
		{
			trace("object length" + objectPool.length);
			if (objectPool.length >= 1) {
				
				var rr:RenderObject = objectPool.pop();
				rr.init(f, n, fla);
				return rr;
			}else {
				return new RenderObject(f, n, fla);
			}
		}
		public function disposeObject(r:RenderObject):void
		{
			objectPool.push(r);
		}
		public function dispose():void
		{
			objectPool.length = 0;
			objectPool = null;
		}
	}
	class RenderObject
	{
		public var func:Function;
		private var start:Point3D;
		private var end:Point3D;
		private var control:Point3D;
		private var weight:Number;
		private var ep:Point3D;
		public var fp:Point3D;
		private var drawFlag:int;
		public function RenderObject(r:Function, node:Node, flag:int = 0)
		{
			init(r, node, flag);
		}
		public function init(r:Function, node:Node, flag:int = 0):void
		{
			func = r;
			drawFlag = flag;
			weight = 1;
			if (flag == -1) return;
			
			if (flag == 0) {
				start = node.movingFlag[0];
				start = getRealPosFromField(start).clone();
				end = node.movingFlag[1];
				end = getRealPosFromField(end).clone();
				
				fp = node.movingFlag[0].clone();
				ep = node.movingFlag[1].clone();

				control = node.movingFlag[2];
				control = getRealPosFromField(control).clone();
				weight = 1;
				
				
			}else {
					fp = node.movingFlag[2];
					start = getRealPosFromField(fp).clone();

			}

		}
		private function getRealPosFromField(node:Point3D):Point3D
		{
			return  new Point3D(node.x * View.xSize + View.xSize / 2 - 465 / 2,
											  node.y * View.ySize + View.ySize / 2 - 465 / 2,
											  node.z * View.zSize + View.zSize / 2);
		}

		public function render():void
		{
			if (drawFlag == 0) {
				func(start, end, control, weight, ep);
			}else {
				var direction:Point3D = new Point3D(0,0,0);
				func(start, direction, weight);
			}
		}
		public function dispose():void
		{
			
		}
	}
	class LineMat extends LineMaterial
	{
		public function LineMat(color:Number = 0xFF0000, alpha:Number = 1)
		{
			super(color, alpha);
		}
		override public function drawLine(line:RenderLine, graphics:Graphics, renderSessionData:RenderSessionData):void
		{	
			graphics.lineStyle( line.size, lineColor, lineAlpha );
			graphics.moveTo( line.v0.x, line.v0.y );
			
			if(line.cV){
				graphics.curveTo(line.cV.x, line.cV.y, line.v1.x, line.v1.y);
			}else{
				graphics.lineTo( line.v1.x, line.v1.y );
			}
/*			graphics.moveTo(0,0);
			graphics.lineStyle();
*/		}
	}
	
	class Point3D
	{
		public var x:Number;		
		public var y:Number;
		public var z:Number;
		public function Point3D(_x:Number, _y:Number, _z:Number)
		{
			x = _x;
			y = _y;
			z = _z;
		}
		public function clone():Point3D
		{
			return new Point3D(x, y, z);
		}
	}
	
class Util
{
	public static const WID:int = 465;
	public static const HEI:int = 465;
	public static const test:Boolean = false;
}


