/**
 * Copyright xor ( http://wonderfl.net/user/xor )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/diqA
 */

// forked from yd_niku's flash on 2009-9-7
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField; 
    import flash.text.TextFormat;
    import com.bit101.components.PushButton;
    public class PagerTest extends Sprite{
        
        private var _pager:Pager;
        private var _numField:TextField;

        public function PagerTest () {
            
            _pager = new Pager();
            
            var format:TextFormat= new TextFormat();    
            format.color= 0xCCCCCC;
            format.size = 12;        
            
            _numField = new TextField();
            _numField.width = 100;
            _numField.height = 24;            
            _numField.x = 50;
            _numField.y= 50;    
            _numField.wordWrap = true;
            //_numField.background = true;    
            //_numField.backgroundColor = 0x000000;    
            //_numField.border = true;    
            //_numField.borderColor = 0x333333;                
            format.font="_SANS";            
            _numField.selectable  = false;    
            _numField.defaultTextFormat=format;
            _numField.antiAliasType = "ADVANCED";
            addChild(_numField);
                        
            var prevBtn:PushButton = new PushButton(this, 10, 10, "Prev", prevPage);
            var nextBtn:PushButton = new PushButton(this, 100, 10, "Next", nextPage);
            var remButton:PushButton = new PushButton(this, 310, 10, "Remove", removePage);
            var addBtn:PushButton = new PushButton(this, 220, 10, "Add", addPage);
            //
            updatePager();
        }
      
        private function addPage( e:MouseEvent ) :void {
            _pager._totalPages++;                        
            updatePager();
        }

        private function removePage( e:MouseEvent ) :void {
            _pager._totalPages--;                        
            updatePager();
        }
        private function nextPage( e:MouseEvent ) :void {
            _pager.next();                        
            updatePager();
        }
        
        private function prevPage( e:MouseEvent ) :void {
            _pager.prev();            
            updatePager();
        }
        
        private function updatePager():void {
            _numField.text = String( _pager.getCurrentPage()+1 ) + " of " + _pager.getTotalPages()+ " pages";
        }

    }

}

class Pager {
        private var _currentPage:int;
        public var _totalPages:int;        
        public function Pager() {
            _currentPage = 0;
            _totalPages= 10;
        }
        public function next() :void {
            _currentPage = Math.min( _totalPages -1, _currentPage +1 );
        }
        
        public function prev() :void {
            _currentPage = Math.max( 0, _currentPage -1 );
        }
        public function getCurrentPage():int {
            return _currentPage;   
        }
        public function getTotalPages():int {
            return _totalPages;   
        }
}
