/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dioY
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
 
	public class Main extends Sprite
	{
		public function Main()
		{
			var slider:Slider = new Slider();
			slider.x = slider.y = 100;
			slider.addEventListener(Event.CHANGE, function():void { trace(slider.value); } );
			addChild(slider);
		}
	}
}
 
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Rectangle;
 
class Slider extends Sprite
{
	public var value:Number = 0.0;
	private var bar:Sprite;
 
	public function Slider()
	{
		// バーの動ける範囲を表す線を引く
		var line:Sprite = new Sprite();
		line.graphics.lineStyle(2.0, 0x0);
		line.graphics.lineTo(100, 0);
		addChild(line);
 
		// バーの形を定義
		bar = new Sprite();
		bar.graphics.beginFill(0x0);
		bar.graphics.drawRect( -4, -10, 8, 20);
		bar.graphics.endFill();
		addChild(bar);
 
		// バーの上でマウスボタンが押されたらonMouseDown()を呼ぶ
		bar.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
	}
 
	private function onMouseDown(event:MouseEvent):void
	{
		// ドラッグ開始(動ける範囲は横0～100pxまで)
		bar.startDrag(false, new Rectangle(0, 0, 100, 0));
 
		// ドラッグを止め、ENTER_FRAMEイベントを止める関数を定義
		var stop:Function = function():void { bar.stopDrag(); removeEventListener(Event.ENTER_FRAME, onEnterFrame); };
 
		// マウスが画面外に出る、もしくはマウスボタンが離されたら上の関数を呼ぶ
		stage.addEventListener(Event.MOUSE_LEAVE, stop);
		stage.addEventListener(MouseEvent.MOUSE_UP, stop);
 
		addEventListener(Event.ENTER_FRAME, onEnterFrame);
	}
 
	private function onEnterFrame(event:Event):void
	{
		// バーの位置 / スライダーの位置で割合を取る
		this.value = bar.x / this.x;
 
		// Event.CHANGEイベントを発行する
		this.dispatchEvent(new Event(Event.CHANGE));
	}
}
