/**
 * Copyright Heo.SangHun ( http://wonderfl.net/user/Heo.SangHun )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dinh
 */

// forked from FLASHMAFIA's $M0KE
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.ByteArray;

    public class SmokeTTT extends Sprite
    {
        private const MASKS : String = "$$MMOOKKEE††††††";
        private const P_NUM : int = 111111;
        /* */
        private var ppp : Particle = new Particle();
        private var bmd : BitmapData;
        private var buf : Vector.<uint>;
        private var forceMap : BitmapData;
        private var maskMap : BitmapData;
        private var maskBytes : ByteArray;
        private var forceBytes : ByteArray;
        private var tf : TextField;
        private var dstp : Point;
        private var mtx : Matrix;
        private var seed : int;
        private var mskCnt : uint;
        private var fcnt : int;

        function SmokeTTT()
        {
            stage.stageFocusRect = tabChildren = tabEnabled = mouseChildren = mouseEnabled = false;
            stage.scaleMode = "noScale";
            stage.align = "TL";
            stage.quality = "low";
            stage.frameRate = 64;
            opaqueBackground = 0x0;

            var bm : Bitmap = new Bitmap(bmd = new BitmapData(512, 512, false, 0xFFFFFF));
            bm.x = bm.y = (465 - 512) / 2;
            bm.opaqueBackground = 0x0;
            addChild(bm);

            buf = new Vector.<uint>(bmd.width * bmd.height, true);

            forceMap = new BitmapData(256, 256, false, 0x0);
            maskMap = new BitmapData(256, 256, false, 0x0);

            var p : Particle = ppp = new Particle();
            var n : uint = P_NUM;
            while (n-- != 0)
            {
                p.x = Math.random() * 512;
                p.y = Math.random() * 512;
                p.vx = p.vy = 0.0;
    
                p = p.next = new Particle();
            }

            tf = new TextField();
            tf.defaultTextFormat = new TextFormat("_sans", 200, 0xFFFFFF, true);
            tf.autoSize = TextFieldAutoSize.LEFT;

            mtx = new Matrix();
            dstp = new Point();

            seed = 8888;

            stage.addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void
        {
            fcnt++;

            if ((fcnt & 63) == 1)
            {
                seed = (((seed & 1) - 1) & 0xF00FC7C8) ^ (seed >> 1);
                
                forceMap.perlinNoise(32, 32, 8, seed, false, true, 3, false);
                
                forceBytes = forceMap.getPixels(forceMap.rect);

                tf.text = MASKS.charAt(mskCnt & 15);
                
                mtx.tx = (256 - tf.width) / 2;
                mtx.ty = ((256 - tf.height) / 2) + ((tf.text != "†") ? 0 : -16);
                
                maskMap.fillRect(maskMap.rect, 0x0);
                maskMap.draw(tf, mtx);
                
                maskBytes = maskMap.getPixels(maskMap.rect);

                mskCnt++;
            }

            var pos : uint = buf.length - (fcnt & 1);
            while (pos > 2)
            {
                pos--; pos--;
                buf[pos] = 0xFFFFFF;
            }

            var p : Particle = ppp;
            while (p != null)
            {
                pos = (((p.y >> 1) << 8) + (p.x >> 1)) << 2;

                if (maskBytes[pos + 1] > 128)
                {
                    p.vx += (forceBytes[pos + 1] - 128) * 0.0018;
                    p.vy += (forceBytes[pos + 2] - 128) * 0.0018;
                    
                    p.vx *= 0.5;
                    p.vy *= 0.5;
                }
                else
                {
                    p.vx += (forceBytes[pos + 1] - 128) * 0.00088;
                    p.vy += (forceBytes[pos + 2] - 128) * 0.00088;
                }

                p.x -= p.vx;
                p.y -= p.vy;
                p.y -= 2;//Math.random()*5;

                if (p.x < 0) p.x = 511;
                else if (p.x > 511) p.x = 1;

                if (p.y < 0) {
                    p.y = 511;
                }

                else if (p.y > 511) p.y = 1;

                pos = ((p.x >> 0) & 511) + (((p.y >> 0) & 511) << 9);
                
                var c : uint = buf[pos];
                
                c -= 0x0F0F0F;
                if (c > 0xFFFFFF) c = 0x0;

                buf[pos] = c;
                
                p = p.next;
            }

            bmd.setVector(bmd.rect, buf);
        }
    }
}

class Particle {
    public var next : Particle;
    public var x : Number;
    public var y : Number;
    public var vx : Number;
    public var vy : Number;
}