/**
 * Copyright vlad.el.rojo ( http://wonderfl.net/user/vlad.el.rojo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dig2
 */

// Espiral letras. Vladimir Israel Ramìrez Díaz. VLD

package  
{
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;    
    import flash.events.TimerEvent;
    import flash.utils.Timer;
   import flash.utils.getTimer;    

    import org.papervision3d.view.*;    
    import org.papervision3d.core.effects.view.ReflectionView;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.materials.WireframeMaterial
    import org.papervision3d.materials.special.Letter3DMaterial
    import org.papervision3d.typography.fonts.HelveticaBold;
    import org.papervision3d.typography.Font3D;
    import org.papervision3d.typography.Letter3D;
    import org.papervision3d.typography.Text3D;    
    
    import net.hires.debug.Stats;
    
    public class Espiral extends ReflectionView {
        
        private var _word:Text3D;
        private var _textVec:Vector.<Text3D> = new Vector.<Text3D>;
        private var _num:uint = 0;
        private var _nextDate:Text3D;
        private var onTimer:Timer = new Timer(1000, 1);
        private var _count:uint = 0;
        private var _floor:Plane = new Plane(new WireframeMaterial(0x999999, 0.5), 3000, 3000, 12, 12);
                
        public function Espiral():void {
            
            stage.quality = "medium";
            surfaceHeight = -1800;
            viewportReflection.filters = [new BlurFilter(4, 4, 1)];
            viewportReflection.alpha = 0.7;
                        
            for (var i:int = 0 ; i < 50; i++) {
                Text(i, Math.random() * 0xFF00FF);
            }
                
            var material:Letter3DMaterial = new Letter3DMaterial(0xFFFFFF);
            material.doubleSided = true;
            
            var font:HelveticaBold = new HelveticaBold();
            _nextDate = new Text3D("0", font, material);
            
            _nextDate.x = _textVec[0].x;
            _nextDate.y = _textVec[0].y;
            _nextDate.z = _textVec[0].z;
            
            
            _floor.rotationX = 90;
            _floor.y = -900
            _floor.z = 1200
            scene.addChild(_floor);            
            
            addEventListener(Event.ENTER_FRAME, loop);            
    
        }
        
     
        private function stoptime(e:TimerEvent):void {
            removeEventListener(TimerEvent.TIMER, stoptime);
            
        
        }
        
        private function loop(e:Event):void {
            camera.x = 600 * Math.sin(getTimer() / 1000);
            camera.z = -2100 * Math.cos(getTimer() / 1000);
            camera.y = 600 * Math.sin(getTimer() / 1000);
                    
        
            
            for (var i:uint = 0; i < _textVec.length; i++) {
                
                if (i == _textVec.length - 1) {                     
                    _num = 0; 
                } else {
                    _num = i + 1;
                }                
                _textVec[i].x = _textVec[_num].x;
                _textVec[i].y = _textVec[_num].y;
                _textVec[i].z = _textVec[_num].z;    
                
            }            
            singleRender();            
        }
        
        private function Text(n:int, col:uint):void {
            var material:Letter3DMaterial = new Letter3DMaterial(col);
            material.doubleSided = true;
            
            var font:HelveticaBold = new HelveticaBold();
            _word = new Text3D( generateRandomString(3) , font, material);
            _word.alpha = Math.random();
            
            _textVec.push(_word);
            scene.addChild(_word);
            
            var rot:Number = (n / 100) * 360 * 12;
            _word.x = 20 * n * Math.cos(rot * Math.PI/180);
            _word.y = 20 * n * Math.sin(rot * Math.PI/180);
            _word.z = n * 50 + 100;            
        }    
       private function generateRandomString(newLength:Number):String{
          var a:String = "MidianMIDIANmiaumiaucosamininamariammidiamduraznito";
          var alphabet:Array = a.split("");
          var randomLetter:String = "";
          for (var i:Number = 0; i < newLength; i++){
            randomLetter += alphabet[Math.floor(Math.random() * alphabet.length)];
          }
          return randomLetter;
        }    


    }    
}