/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/diNX
 */

// forked from nyamogera's forked from: てすとてすと
// forked from mogera's てすとてすと
// forked from mogera's デバッグ用2
// forked from mogera's デバッグ用
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.getTimer;
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.events.MouseEvent;
    import Box2D.Dynamics.b2Body;
    //    つみはむをさくせいする。
    public class TumiHam extends Sprite {
        private static const STAGE_WIDTH:int = 465;
        private static const STAGE_HEIGHT:int = 465;
        [SWF(width="465", height="465", backgroundColor="0x222222", frameRate="30")] 
        private var hamButton:Sprite;    //    ハムスターを追加するボタン
        private var hamster:Hamster;            //    現在持ってるハムスター
        private var tower:Tower;
        private var debug:DebugTest;
        private var background:Sprite;
        private var tmpTop:Number;
        private var tmpTopCount:int;
        public function TumiHam() {
            createBackground();
            ｃreateHamButton();
            createTower();
            debug = DebugTest.createShareDebug("key");
            addChild(debug );
            var towerDebug:DebugTest = DebugTest.createShareDebug("tower");
            addChild(towerDebug);
            var towerHitCheckDebug:DebugTest = DebugTest.createShareDebug("tower hitcheck");
            addChild(towerHitCheckDebug);
            addEventListener( Event.ENTER_FRAME, enterFrame );
        }
        private function createBackground() : void
        {
            background = new Sprite();
            var g:Graphics = background.graphics;
            var color:Array = [0xccffaa, 0x33ffaa, 0xccff65a, 0xc4ffaa, 0xccf22a, 0x22ffaa,0xcc55aa, 0xccffaa, 0xccffaa]
            for( var i:int = 0; i < 10; i ++ )
            {
                g.beginFill(color[i]);
                g.drawRect(0, -i * STAGE_HEIGHT, STAGE_WIDTH, STAGE_HEIGHT);
            }
            background.y = STAGE_HEIGHT;
            addChild( background );
        }
     private function enterFrame(e:Event):void 
    {
            var towerDebug:DebugTest = DebugTest.createShareDebug("tower");
            towerDebug.add("tower height", ( -tower.getTop() ).toString()  + "cm");
            if( tmpTop -tower.getTop() <= Math.abs(1))
            {
                towerDebug.add("tower height px",( -tower.getTop()+ 200).toString());
                tmpTopCount ++ ;
                if( tmpTopCount == 30 )
                {
                    var top:Number = -tower.getTop() + 200 ;
                  if( top < STAGE_HEIGHT) top = STAGE_HEIGHT;
                    background.y = top ;
                    tmpTopCount = 0;
                }
            }
            else
            {
                tmpTopCount = 0;
                tmpTop = tower.getTop()
            }
            tower.hitCheck();
    }
     private function collapses(e:Event) : void
        {
            
        }
     private function allRunaway() : void
        {
            
        }
     private function createTower() : void {
            tower = new Tower(true);
            background.addChild(tower);
        }
     private function ｃreateHamButton() : void
        {
            hamButton = new Sprite();
            var graphics:Graphics = hamButton.graphics;
            graphics.beginFill(0xff88ff);
            graphics.drawCircle(10,10,10);
            hamButton.x = STAGE_WIDTH -20;
            hamButton.addEventListener(MouseEvent.MOUSE_DOWN, addHam); 
            addChild( hamButton );
        }
        private function addHam(event: MouseEvent) : void
        {
            debug.add("hamAddKey","down");
            hamster = new Hamster();
            hamster.createHamster();
            hamster.x = mouseX;
            hamster.y = mouseY - background.y;
            hamster.catchHamster();
            background.addChild(hamster);
            var body:b2Body = tower.createHamster(hamster);
            tower.jointMouse(body, mouseX, mouseY - background.y);
            background.addEventListener(MouseEvent.MOUSE_MOVE, moveHamMouse);
            background.addEventListener(MouseEvent.MOUSE_UP, releaseHam);
        }
        private function moveHamMouse(event:MouseEvent) : void
        {
            tower.moveMouse(mouseX,  mouseY - background.y);
        }
        private function releaseHam(event: MouseEvent) : void
        {
            background.removeEventListener(MouseEvent.MOUSE_MOVE, moveHamMouse);
            background.removeEventListener(MouseEvent.MOUSE_UP, releaseHam);
            tower.addWorld()
            hamster.releaseHamster();
            tower.releaseMouse();
            debug.add("hamReleaseKey","down");
        
        }
    }
 }
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.utils.Dictionary;
class Hamster extends Sprite 
{
    public static const SCALE_SMALL:int = 0;
    public static const SCALE_MEDIUM:int = 1;
    public static const SCALE_LARGE:int = 2;
    public static const STATUS_FALL:String = "statusFall";
    public static const STATUS_STOP:String = "statusStop";
    public static const STATUS_ZITABATA:String = "statusZitabata";
    public static const STATUS_WALK:String = "statusWalk";
    private var status:String;
    private var scale:int;
    private var _foundation:Boolean;
    private var _tower:int = -1;
    public function getScale() : int
    {
        return scale;
    }
    
    public function Hamster() : void
    {
        status = STATUS_STOP;
    }
    
    public function catchHamster() : void
    {
        startDrag();
        status = STATUS_ZITABATA;
    }
    
    public function releaseHamster() : void
    {
        stopDrag();
        status = STATUS_FALL;
    }
    public function createHamster() : void
    {
        scale = Math.floor(Math.random()*3);    
         graphics.beginFill(0xff8888);
         graphics.drawCircle(0,0,10);
    }
    public function set tower(val:int ) : void 
    {
        _tower= val;
    }
    
    public function get tower() : int
    {
        return _tower;
    }
        
    public function set foundation(val:Boolean ) : void 
    {
        _foundation = val;
    }
    
    public function get foundation() : Boolean
    {
        return foundation;
    }
}

class DebugTest extends Sprite
{
    private var barField:TextField;
    private var openField:TextField;
    private var debugField:TextField;
    private var dictionary:Dictionary;
    private var title:String;
    
    private static var instances:Object;

    public static function createShareDebug(title:String) : DebugTest 
    {
        if( !instances ) instances = new Object();
        
        if( instances[title] != undefined && 
               instances[title] != null) return instances[title];
               
        return (instances[title] = new DebugTest(title));
    }
    public function DebugTest(title:String) 
    {
    dictionary = new Dictionary(true);
    barField = new TextField();
    openField = new TextField();
    debugField = new TextField();
    barField.text = this.title = title;
    openField.text = "▲";    //    上三角
    barField.background = true;
    barField.backgroundColor = 0x00000;
    barField.textColor = 0xffffff;
    barField.x = 20;
    barField.height = 20;
    barField.addEventListener( MouseEvent.MOUSE_DOWN, startMove);
    barField.addEventListener( MouseEvent.MOUSE_UP, endMove);
    barField.border = true;
    barField.selectable= false;
    
    openField.background = true;
    openField.backgroundColor = 0x00000;
    openField.textColor = 0xffffff;
    openField.height = 20;
    openField.width = 20;
    openField.selectable= false;
    openField.border = true;
        openField.mouseEnabled = true;
    openField.addEventListener( MouseEvent.CLICK, switchVisible);

    debugField.border = true;
            
    debugField.y = 20;
    debugField.background = true;
    debugField.backgroundColor = 0xffffff;    
        
    addChild( barField );
    addChild( openField );
    addChild( debugField );
            
    update();
    }
   private function switchVisible(e:MouseEvent):void 
   {
        debugField.visible = !debugField.visible;

        if ( debugField.visible ) 
        {
        openField.text = "▲"
    }
        else
    {
        openField.text = "▼"
           }
        
    }
    private function endMove(e:MouseEvent):void 
    {
        stopDrag();
    }
   private function startMove(e:MouseEvent):void 
    {
        startDrag();
    }
    private function update():void
    {
        var w:Number = Math.max( barField.textWidth + 20, debugField.textWidth  ) + 4 ;
        barField.width = w - 20;
        debugField.width = w;
            
        debugField.height = debugField.textHeight + 4;
    }
    public function add(key:String, str:String) : void
    {
        dictionary[key] = str;
        debugField.text = "";
        for ( var s:String in dictionary )
    {
        debugField.appendText( s + "：" + dictionary[s] + "\n" );
    }
            
        update();
    }
        
    public function removeKey(key:String) : void
    {
        
        dictionary[key] = null;
        delete dictionary[key];
    
        update();
    }
    
    public function remove() : void 
    {
        if( instances ) 
        {
            instances[title] = null;
        }   
    }    
 }

import Box2D.Collision.b2ContactPoint;
import Box2D.Dynamics.b2ContactListener;
    
class ContactListener extends b2ContactListener {

    public var tower:Vector.<b2Body>;
    public function ContactListener() 
    {
    }
    public override function Add(point:b2ContactPoint):void 
    {
        var towerHitCheckDebug:DebugTest = DebugTest.createShareDebug("tower hitcheck");
        towerHitCheckDebug.add("><", "aaaa")
    var num:int = point.velocity.Length() / 10 + 1;
    if (num <= 1) 
        {
        }
        
    towerHitCheckDebug.add("velocity",num.toString());
    
    var obj1:b2Body = point.shape1.m_body;
    var obj2:b2Body = point.shape2.m_body;

        if(obj1 != null && obj2 != null)
        {
             towerHitCheckDebug.add("null", "not")
        }
        else
        {
             towerHitCheckDebug.add("null", "desu")
        }

    if(obj1.m_userData != null && obj2.m_userData != null /*&& point.id.key == 1 */)
    {
            if( false )
            {
        if(obj2.m_userData is Hamster && obj1.m_userData.id == "floor") 
        {
            if( tower.length == 0 )
            {
            var ham:Hamster = obj2.m_userData as Hamster;
            ham.foundation = true;
            tower.push(obj2);
                
                        ham.tower = tower.length;
            towerHitCheckDebug.add("foundation","foundation");
            }
        }
        else if( obj2.m_userData is Hamster && !obj2.m_userData.foundation )
        {
            towerHitCheckDebug.add("is not foundation", "><");
        }
            }
    }
    
    if(false && obj2.m_userData != null)
    {
        if( obj2.m_userData is Hamster && obj1.m_userData.id == "floor") 
        { 
         towerHitCheckDebug.add(obj2.m_userData.tower, "hamster!");   
             
         if(obj2.m_userData.tower != -1)
             {
                    towerHitCheckDebug.add("><", "hamster&tower");   
             }
                else
                {
                    towerHitCheckDebug.add(obj2.m_userData.tower, "notTower hamster!");   
                }
        }
        else
        {
         towerHitCheckDebug.add("><", "no");   
        }
    }
    }
} 
//import authoring.authObject;
import flash.display.Bitmap;
import flash.display.Graphics;
import flash.display.Loader;
import flash.display.MovieClip;
import flash.display.Sprite;
import flash.events.Event;
import flash.external.ExternalInterface;
import flash.net.URLRequest;
import flash.text.TextField;
import flash.utils.getTimer;
import flash.geom.Point;
import Box2D.Dynamics.Joints.b2MouseJoint;
import Box2D.Collision.Shapes.b2PolygonDef;
import Box2D.Collision.b2AABB;
import Box2D.Collision.Shapes.b2CircleDef;
import Box2D.Common.Math.b2Vec2;
import Box2D.Dynamics.b2Body;
import Box2D.Dynamics.b2BodyDef;
import Box2D.Dynamics.b2DebugDraw;
import Box2D.Dynamics.b2World;
import Box2D.Dynamics.Joints.b2MouseJointDef;
import Box2D.Dynamics.Contacts.b2ContactEdge;

internal class Tower extends Sprite
{
    private var _world:b2World;
    private var _gravity:b2Vec2;
    private var _doSleep:Boolean;
    private var _worldAABB:b2AABB;
    private var _body:b2BodyDef;
        private var _floor:b2Body;
    public static var SCALE:int = 100;
        private var _mouseJoint: b2MouseJoint;
        private var _topHamster:b2Body;
        private var _currentHamster:b2Body;
        private var _tower:Vector.<b2Body>;
   public function Tower(debugFlg:Boolean = false)
    {
            _worldAABB = new b2AABB();
            _worldAABB.lowerBound.Set( -500.0, -500.0);
            _worldAABB.upperBound.Set( 500.0, 500.0);
            _gravity = new b2Vec2(0.0, 5.0);
            _doSleep = true;
            _world = new b2World(_worldAABB, _gravity, _doSleep);
            _body = new b2BodyDef();
            _body.position.Set(0,0);
            createFloor();
            if ( debugFlg ) 
        {
            debug();
        }
            setContactListener();
     _tower = new Vector.<b2Body>;
            addEventListener(Event.ENTER_FRAME, enterFrame);
    }

        private function setContactListener() : void
        {
            var contactListener:ContactListener = new ContactListener();
        _world.SetContactListener(contactListener);
            contactListener.tower= _tower;
        }

        public function getTop() : Number
        {
            if( _topHamster != null)
            {
                return _topHamster.GetWorldCenter().y * SCALE;
            }
            
            return 0;
        }
       public function hitCheck() : void
        {

        }

        private function createFloor() : void
        {
            var floorBodyDef:b2BodyDef = new b2BodyDef();
             floorBodyDef.position.Set(0, 460/SCALE);
             
            var floorShapeDef:b2PolygonDef = new b2PolygonDef();
            floorShapeDef.SetAsBox(465/SCALE, 0.1);
            
            floorShapeDef.restitution = 0.1;
            var floor:b2Body = _world.CreateBody(floorBodyDef);
            floor..SetXForm(new b2Vec2(0 /SCALE ,0/SCALE), 0);
            floorShapeDef.userData = new Object;
            floorShapeDef.userData.id = "floor";
            
             floor.CreateShape(floorShapeDef);
             _floor = floor;
        }
    
    public function getWorldBody() :b2Body
    {
        return _world.CreateBody(_body);
    }

        public function jointMouse(body:b2Body,mouseX:int, mouseY:int) : void
        {
            var mouseJointDef : b2MouseJointDef = new b2MouseJointDef();
            mouseJointDef.body1 = _world.m_groundBody;
            mouseJointDef.body2 = body;
            mouseJointDef.target.Set(mouseX/ SCALE, mouseY / SCALE);
            mouseJointDef.maxForce = 300  * body.GetMass();
            mouseJointDef.timeStep = 30.0;
           
            _mouseJoint = _world.CreateJoint(mouseJointDef) as b2MouseJoint;
            
            body.SetMassFromShapes();
            body.WakeUp();
        }

        public function moveMouse(mouseX:int, mouseY:int) : void
        {
            if( _mouseJoint )
            {
                var p : b2Vec2 = new b2Vec2(mouseX/ SCALE, mouseY / SCALE);
                _mouseJoint.SetTarget(p);
            }
        }
        
        public function releaseMouse() : void
        {
            if( _mouseJoint )
            {
                _world.DestroyJoint(_mouseJoint);
                _mouseJoint = null;
                
            }
        }
    private function enterFrame(e:Event):void 
    {
        _world.Step(1 / 30, 10);
        for (var b:b2Body = _world.GetBodyList(); b; b = b.GetNext()) 
        {
                var ham:Hamster = b.GetUserData() as Hamster;
        if (ham){
            ham.x = b.GetWorldCenter().x * SCALE;
            ham.y = b.GetWorldCenter().y * SCALE;
            ham.rotation = b.GetAngle() * 180 / Math.PI;
            }           
               if (ham && ham.y > 460){
                    _world.DestroyBody(b);
                    removeChild(ham);
                    
                    if( (_mouseJoint != null) && (b == _mouseJoint.m_body2 ) )
                    {
                        _mouseJoint = null;
                    }
                }
        }

            var debug:DebugTest = DebugTest.createShareDebug("tower");
    }
   private function debug() : void
    {
        var dbgDraw:b2DebugDraw = new b2DebugDraw();
        
        dbgDraw.m_sprite = this;
        dbgDraw.m_drawScale = SCALE;
        dbgDraw.m_fillAlpha= 0.8;
        dbgDraw.m_lineThickness= 1.0;
        dbgDraw.m_alpha=1.0;
        dbgDraw.m_xformScale = 1.0;
        
        dbgDraw.m_drawFlags = b2DebugDraw.e_shapeBit;
        
        _world.SetDebugDraw(dbgDraw);
        
        trace("debug");
        
    }
       public function addWorld() : Boolean
        {
            _topHamster = _currentHamster;
            
            _currentHamster = null;
            return true;
        }

    public function createHamster( hamster:Hamster ) : b2Body
    {
        var debug:DebugTest = DebugTest.createShareDebug("tower");
        var b2body:b2Body = _world.CreateBody(_body);
        var boxShapeDef:b2PolygonDef= new b2PolygonDef();
        debug.add("step0", "ok");
        boxShapeDef.SetAsBox(0.4, 0.2);
        debug.add("step1", "ok");
        boxShapeDef.density = 8;
        boxShapeDef.restitution = 0.1;
        boxShapeDef.friction = 0.8;
        debug.add("step2", "ok");
        b2body.CreateShape(boxShapeDef);
        b2body.SetXForm(new b2Vec2(hamster.x /SCALE ,( hamster.y + 10)/SCALE), 0);
        b2body.m_userData = hamster;
        b2body.GetUserData().x = b2body.GetWorldCenter().x;
        b2body.GetUserData().y = b2body.GetWorldCenter().y;
        addChild(b2body.GetUserData());
        debug.add("step3", "ok");
        b2body.SetMassFromShapes();
        debug.add("step4", "ok");
        _currentHamster = b2body;
        return b2body;
    }    
    public function toRad( deg:Number ) : Number
    {
        return deg / 180 * (Math.PI)
    }    
}

