/**
 * Copyright poiasd ( http://wonderfl.net/user/poiasd )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dhaO
 */

package {

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.DropShadowFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFormat;

    [SWF (width = "465", height = "465", frameRate = "30")]

    public class TextTransform extends Sprite {
        
        private const STAGE_WIDTH:uint = 465;
        private const STAGE_HEIGHT:uint = 465;
        private const HALF_WIDTH:uint = STAGE_WIDTH >> 1;
        private const HALF_HEIGHT:uint = STAGE_HEIGHT >> 1;
        private var _text:String = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        private var _canvas:BitmapData;
        private var _textImgList:Vector.<BitmapData>;
        private var _particleList:Vector.<Particle>;
        private var _nextPos:Point = new Point ();
        private var _imgWidth:uint = 0;
        private var _imgHeight:uint = 0;
        private var _index:int = 0;
        
        public function TextTransform ():void {
            addChild (new Bitmap (createBackGround ()));
            
            _canvas = new BitmapData (STAGE_WIDTH, STAGE_HEIGHT, true, 0xFFFFFF);
            addChild (new Bitmap (_canvas));
            
            initText ();
            
            initParticles ();
            
            setParticles ();
        }
        
        private function createBackGround ():BitmapData {
            var tile:BitmapData = new BitmapData (4, 4, true, 0x000000);
            var color:uint = 0x20000000;
            for (var i:int = 0; i < 4; i++) {
                tile.setPixel32 (i, 3 - i, color);
            }
            color = 0x10000000;
            for (i = 0; i < 3; i++) {
                tile.setPixel32 (i, 2 - i, color);
                tile.setPixel32 (i + 1, 3 - i, color);
            }
            tile.setPixel32 (0, 0, color);
            tile.setPixel32 (3, 3, color);
            var shape:Shape = new Shape ();
            shape.graphics.beginBitmapFill (tile);
            shape.graphics.drawRect (0, 0, STAGE_WIDTH, STAGE_HEIGHT);
            var bg:BitmapData = new BitmapData (STAGE_WIDTH, STAGE_HEIGHT, false, 0xFFFFFF);
            bg.draw (shape);
            return bg;
        }
        
        private function initText ():void {
            var format:TextFormat = new TextFormat ();
            format.size = 100;
            format.color = 0x222222;
            
            var field:TextField = new TextField ();
            field.defaultTextFormat = format;
            field.autoSize = "left";
            
            _textImgList = new Vector.<BitmapData> ();
            var length:int = _text.length;
            var img:BitmapData;
            for (var i:int = 0; i < length; i++) {
                field.text = _text.charAt (i);
                img = createImageFromText (field);
                _textImgList [i] = img;
                (img.width > _imgWidth) ? _imgWidth = img.width : 0;
                (img.height > _imgHeight) ? _imgHeight = img.height : 0;
            }
            
            var imgPos:Point = new Point ();
            for (i = 0; i < length; i++) {
                img = new BitmapData (_imgWidth, _imgHeight, true, 0xFFFFFF);
                imgPos.x = _imgWidth - _textImgList [i].width >> 1;
                imgPos.y = _imgHeight - _textImgList [i].height >> 1;
                img.copyPixels (_textImgList [i], _textImgList [i].rect, imgPos);
                _textImgList [i] = img;
            }
        }
        
        private function createImageFromText (field:TextField):BitmapData {
            var data1:BitmapData = new BitmapData (field.width << 2, field.height << 2, true, 0xFFFFFF);
            var matrix:Matrix = new Matrix ();
            matrix.scale (4, 4);
            data1.draw (field, matrix);
            data1.applyFilter (data1, data1.rect, new Point (), new BlurFilter (4, 4, 3));
            
            var data2:BitmapData = new BitmapData (field.width << 1, field.height << 1, true, 0xFFFFFF);
            matrix = new Matrix ();
            matrix.scale (0.25, 0.25);
            data2.draw (data1, matrix);
            data2.applyFilter (data2, data2.rect, new Point (), new DropShadowFilter (6, 45, 0, 0.3));
            
            var rect:Rectangle = data2.getColorBoundsRect (0xFF000000, 0x00000000, false);
            data1 = new BitmapData (rect.width, rect.height, true, 0xFFFFFF);
            data1.copyPixels (data2, rect, new Point ());
            return data1;
        }
        
        private function initParticles ():void {
            _nextPos.x = STAGE_WIDTH - _imgWidth >> 2;
            _nextPos.y = STAGE_HEIGHT - _imgHeight >> 2;
            _particleList = new Vector.<Particle> (_imgWidth * _imgHeight, true);
            var img:BitmapData = _textImgList [_index];
            var p:Particle;
            for (var i:int = 0; i < _imgHeight; i++) {
                for (var j:int = 0; j < _imgWidth; j++) {
                    p = new Particle ();
                    p.nextX = _nextPos.x + j;
                    p.nextY = _nextPos.y + i;
                    p.nextColor = img.getPixel32 (j, i);
                    _particleList [i * _imgWidth + j] = p;
                }
            }
            _canvas.copyPixels (img, img.rect, _nextPos);
        }
        
        private function setParticles ():void {
            var dx:int = _nextPos.x;
            var dy:int = _nextPos.y;
            var pos:int = int (_nextPos.x / HALF_WIDTH) + int (_nextPos.y / HALF_HEIGHT) * 2;
            pos = (pos + int (Math.random () * 3) + 1) % 4;
            _nextPos.x = int (Math.random () * (HALF_WIDTH - _imgWidth)) + pos % 2 * HALF_WIDTH;
            _nextPos.y = int (Math.random () * (HALF_HEIGHT - _imgHeight)) + int (pos / 2) * HALF_HEIGHT;
            dx -= _nextPos.x;
            dy -= _nextPos.y;
            var img:BitmapData = _textImgList [(_index + 1) % _text.length];
            var p:Particle;
            for (var i:int = 0; i < _imgHeight; i++) {
                for (var j:int = 0; j < _imgWidth; j++) {
                    p = _particleList [i * _imgWidth + j];
                    p.x = p.nextX;
                    p.y = p.nextY;
                    p.vx = Math.random () * 10 - 5;
                    p.vy = Math.random () * 10 - 5;
                    p.color = p.nextColor;
                    p.nextX = _nextPos.x + j;
                    p.nextY = _nextPos.y + i;
                    p.nextColor = img.getPixel32 (j, i);
                    p.frameCount = ((dx > 0 ? j : _imgWidth - j) + (dy > 0 ? i : _imgHeight - i) >> 2) + int (Math.random () * 6 + 25);
                }
            }
            stage.addEventListener (MouseEvent.MOUSE_MOVE, onMouseMove);
        }
        
        private function onMouseMove (event:MouseEvent):void {
            if (_canvas.getPixel32 (stage.mouseX, stage.mouseY) > 0) {
                stage.addEventListener (Event.ENTER_FRAME, onEnterFrame);
                stage.removeEventListener (MouseEvent.MOUSE_MOVE, onMouseMove);
            }
        }
        
        private var _frame:int = 0;
        
        private function onEnterFrame (event:Event):void {
            _canvas.lock ();
            _canvas.fillRect (_canvas.rect, 0xFFFFFF);
            var count:int = 0;
            var length:Number = _particleList.length;
            var p:Particle;
            var color:uint;
            for (var i:int = 0; i < length; i++) {
                p = _particleList [i];
                if (_frame < p.frameCount >> 1){
                    p.x += p.vx;
                    p.y += p.vy;
                    color = p.color;
                }else if (_frame < p.frameCount) {
                    p.vx = (p.nextX - p.x) / (p.frameCount - _frame);
                    p.vy = (p.nextY - p.y) / (p.frameCount - _frame);
                    p.x += p.vx * 3;
                    p.y += p.vy * 3;
                    color = p.nextColor;
                }else {
                    p.x = p.nextX;
                    p.y = p.nextY;
                    color = p.nextColor;
                    count++;
                }
                _canvas.setPixel32 (p.x, p.y, color);
            }
            _canvas.unlock ();
            _frame++;
            if (count >= length) {
                _frame = 0;
                stage.removeEventListener (Event.ENTER_FRAME, onEnterFrame);
                _index = (_index < _text.length - 1) ? ++_index : 0;
                setParticles ();
            }
        }
        
    }
    
}

class Particle {
    
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var color:uint;
    public var nextX:Number;
    public var nextY:Number;
    public var nextColor:uint;
    public var frameCount:int;
    
}
