/**
 * Copyright Albert ( http://wonderfl.net/user/Albert )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dhUg
 */

//Sorry, WONDERFL didn't save the working copy of this, but an earlier one.

//Drag a block, and it start to snap to the closest axle
//release the block and it snap to the correct position

package
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    import flash.display.*;
    import flash.geom.*;

    public class DragSnap extends Sprite
    {
        public const NUM_POINTS:int = 50;
        public var pts:Vector.<Point> = new Vector.<Point>();
        protected var mc:Sprite;
        protected var startdragx:int;
        protected var startdragy:int;
        
        public function DragSnap()
        {
            var c:DragBlock;
            for(var i:int=0; i<NUM_POINTS; i++)
            {
                pts[i] = new Point(34*int(1+13*Math.random()), 34*int(1+13*Math.random()));
                c = new DragBlock(pts[i], Math.random()*0xAAAAAA);
                addChild(c);
                
                c.buttonMode = true;
                c.addEventListener(MouseEvent.MOUSE_DOWN, drag);
            }
            //draw();
        }
        
 
        protected function draw():void
        {
            /*graphics.clear();*/
        }
        
        protected function drag(event:MouseEvent):void
        {
            mc = event.currentTarget as Sprite;
            setChildIndex(mc,numChildren - 1); //http://www.foundation-flash.com/tutorials/changingdepths/
            stage.addEventListener(MouseEvent.MOUSE_UP, endDrag);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, move);
            startdragx=mc.x;
            startdragy=mc.y;
            move();
        }
        
        protected function dragvertically(dx:Number, dy:Number):Boolean
       {
           if (Math.abs(dx)<Math.abs(dy)) return true;
           return false
       }
 
        
        protected function endDrag(event:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_UP, endDrag);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, move);
            snap();
        }
        
        protected function move(event:MouseEvent=null):void
        {
            var vertical:Boolean=dragvertically(mouseX-startdragx, mouseY-startdragy);
            if (vertical)
            {             
                mc.x = startdragx;
                mc.y = mouseY;
            }
            else
            {             
                mc.x = mouseX;
                mc.y = startdragy;
            }
 
            draw();
        }
        
        protected function snap(event:MouseEvent=null):void
        {
            var vertical:Boolean=dragvertically(mouseX-startdragx, mouseY-startdragy);
            if (vertical)
            {             
                mc.x = startdragx;
                mc.y = int((mouseY+17)/34)*34;
            }
            else
            {             
                mc.x = int((mouseX+17)/34)*34;
                mc.y = startdragy;
            }
            draw();
        }        
    }
}

    import flash.display.Sprite;
    import flash.geom.Point;
    import flash.geom.Matrix;
    

class DragBlock extends Sprite
{
    protected var pnt:Point;
    public function DragBlock(p:Point, color:int)
    {
        myGradient(-12,-12,34,34,color);
        
        pnt = p;
        super.x = pnt.x;
        super.y = pnt.y;
    }
    
    override public function set x(value:Number):void
    {
        super.x = pnt.x = value;
    }
    
    override public function set y(value:Number):void
    {
        super.y = pnt.y = value;
    }
    
    protected function myGradient(x:int, y:int, w:int, h:int, color:int):void
    {
        var matrix:Matrix = new Matrix();
        var color3:int = 0xffffff - color; //
        var color2:int = color+((((((color3&0xff0000) >> 16)/4*3)<<16) + ((((color3&0x00ff00) >> 8)/4*3)<<8) + (color3&0x0000ff)/4*3));

        matrix.createGradientBox(w, h, 45 * Math.PI / 180, x, y);
        graphics.beginGradientFill("linear", [color2, color], [1.0, 1.0], [0, 255], matrix);            
        graphics.drawRoundRect(x,y,w,h,5,5);
        graphics.endFill();

        matrix.createGradientBox(w, h, 45 * Math.PI / 180, x, y);
        graphics.beginGradientFill("linear", [color, color2], [1.0, 1.0], [0, 255], matrix);
        graphics.drawRoundRect(x+7, y+7, w-14, h-14,3,3);
        graphics.endFill();
    }
}