/**
 * Copyright grapefrukt ( http://wonderfl.net/user/grapefrukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dhJ5
 */

package  {
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	
	/**
	 * ...
	 * @author Martin Jonasson (m@webbfarbror.se)
	 */
	public class CurveTest extends Sprite{

		private var _canvas:Sprite;
		private var _canvas2:Sprite;
		private var _output:TextField;
		private var _ratio:Number;
		private var _target:Number;
		
		public function CurveTest() {
			_canvas = new Sprite;
			_canvas.x = 10;
			_canvas.y = 10;
			addChild(_canvas);
			
			_canvas2 = new Sprite;
			_canvas.addChild(_canvas2);
			
			_output = new TextField;
			_output.x = 220;
			_output.y = 10;
			_output.defaultTextFormat = new TextFormat("Consolas", 11, 0x000000);
			_output.autoSize = TextFieldAutoSize.LEFT;
			addChild(_output);
			
			redraw(100, 100);
			
			stage.addEventListener(MouseEvent.CLICK, handleClick);
			stage.addEventListener(MouseEvent.CLICK, handleMove);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, handleMove);
			
			_canvas.scrollRect = new Rectangle(0, 0, 200, 200);
		}
		
		private function handleMove(e:MouseEvent):void {
			var clickX:Number = _canvas.mouseX;
			
			if (clickX < 0) clickX = 0;
			if (clickX > 200) clickX = 200;
			
			_output.text = _target.toFixed(2) 			+ ", " + (_target * _ratio).toFixed(2) + "\n" + 
							clickX.toFixed(2) 	+ ", " + (plot(clickX, _target, _ratio)).toFixed(2);
							
			_canvas2.graphics.clear();
			_canvas2.graphics.beginFill(0x0000ff);
			_canvas2.graphics.drawCircle(clickX, 200 - plot(clickX, _target, _ratio), 5);
			
		}
		
		private function handleClick(e:MouseEvent):void {
			redraw(_canvas.mouseX, 200 - _canvas.mouseY);
		}
		
		private function redraw(clickX:Number, clickY:Number):void {
			if (clickX < 0) clickX = 0;
			if (clickX > 200) clickX = 200;
			
			if (clickY < 0) clickY = 0;
			if (clickY > 200) clickY = 200;
			
			_canvas.graphics.clear();
			_canvas.graphics.beginFill(0xdddddd);
			_canvas.graphics.drawRect(0, 0, 200, 200);
			
			_canvas.graphics.beginFill(0xff00ff);
			_canvas.graphics.drawCircle(clickX, 200 - clickY, 5);
			
			_ratio = clickY / clickX;
			_target = clickX;
			
			_canvas.graphics.endFill();
			_canvas.graphics.lineStyle(2, 0x00ff00, 1, true);
			
			
			for (var i:int = 0; i < 200; i++) {
				if (i == 0) {
					_canvas.graphics.moveTo(i, 200 - plot(i, _target, _ratio));
				} else {
					_canvas.graphics.lineTo(i, 200 - plot(i, _target, _ratio));
				}
			}
			
		}
		
		private function plot(x:Number, target:Number, ratio:Number):Number{
			return x * x / target * ratio;
		}
		
	}

}