/**
 * Copyright usami ( http://wonderfl.net/user/usami )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dhHC
 */

package{
    
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.display.Bitmap;
    import flash.display.BitmapData;

    
    import Box2D.Dynamics.*;
    import Box2D.Collision.*;
    import Box2D.Collision.Shapes.*;
    import Box2D.Common.Math.*;
    
    public class BoxTest extends Sprite{
        
        private var loader:Loader;
        public var m_world:b2World;
        public var m_iterations:int = 10;
        public var m_timeStep:Number = 1.0 / 30.0;
        
        private var body:b2Body;
        private var bodyDef:b2BodyDef;
        private var boxDef:b2PolygonDef;
        private var circleDef:b2CircleDef;
        //-----------------------------------------------------
        //コンストラクタ
        public function BoxTest(){

            var url:String = "http://assets.wonderfl.net/images/related_images/d/d4/d474/d4746c02ff7960216434ba3d995d8c9cf8dddafc"
            loader = new Loader();
            loader.load(new URLRequest(url), new LoaderContext(true));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompleteHandler);
        }
        //-----------------------------------------------------
        //画像ロード完了
        private function loadCompleteHandler(e:Event):void{
            // Add event for main loop
            addEventListener(Event.ENTER_FRAME, Update, false, 0, true);
            
            
            // シミュレーションする座標の範囲を指定する
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100.0, -100.0);
            worldAABB.upperBound.Set(100.0, 100.0);
            
            var gravity:b2Vec2 = new b2Vec2(0.0, 10.0);// 重力を定義する
            var doSleep:Boolean = true;// 世界のインスタンスを作成する
            m_world = new b2World(worldAABB, gravity, doSleep);// 世界を生成
            
            // Add ground body :物体の定義を作る 
            bodyDef = new b2BodyDef();
            
            
            setWall(-1, 10, 1, 10);
            setWall(17, 10, 1, 10);
            setWall(10, 15, 10, 2);
            
            // Add some objects
            for (var i:int = 1; i < 10; i++){
                bodyDef = new b2BodyDef();
                bodyDef.position.x = Math.random() * 10+4;
                bodyDef.position.y = Math.random() * 10;
                var rX:Number = Math.random() + 0.5;
                var rY:Number = Math.random() + 0.5;

                boxDef = new b2PolygonDef();
                var sp:Sprite = getKani();
                bodyDef.userData = sp;
                boxDef.SetAsBox(1, 1);
                boxDef.density = 1.0;//密度
                boxDef.friction = 0.5;//摩擦
                boxDef.restitution = 0.2;//跳ね返り
                
                bodyDef.userData.width = sp.width; 
                bodyDef.userData.height =  sp.height; 
                body = m_world.CreateBody(bodyDef);//物体を作る
                body.CreateShape(boxDef);//形を物体に追加する 

                body.SetMassFromShapes();//重さを計算する 
                addChild(bodyDef.userData);
            }
        }
        //-----------------------------------------------------
        /**
         * ハンドラ
         */
        // EnterFrame
        private function Update(e:Event):void{
            
            m_world.Step(m_timeStep, m_iterations);
            
            // Go through body list and update sprite positions/rotations
            for (var bb:b2Body = m_world.m_bodyList; bb; bb = bb.m_next){
                if (bb.m_userData is Sprite){
                    bb.m_userData.x = bb.GetPosition().x * 30;
                    bb.m_userData.y = bb.GetPosition().y * 30;
                    bb.m_userData.rotation = bb.GetAngle() * (180/Math.PI);
                }
            }
            
        }
        //-----------------------------------------------------
        //壁を配置
        private function setWall(_x:Number,_y:Number,_w:Number,_h:Number):void {
            
            //bodyDef.angle = 0.1;
            
            bodyDef.position.Set(_x, _y);
            boxDef = new b2PolygonDef();
            boxDef.SetAsBox(_w, _h);
            boxDef.friction = 0.01;//摩擦
            boxDef.density = 0;//密度
            
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(0x999999);
            sp.graphics.drawRect( -5, -5, 10, 10);
            bodyDef.userData = sp;
            bodyDef.userData.width = 30 * 2 * _w;
            bodyDef.userData.height = 30 * 2 * _h;
            addChild(bodyDef.userData);
            
            body = m_world.CreateBody(bodyDef);//物体を作る
            body.CreateShape(boxDef);//形を物体に追加する 
            //body.CreateShape(circleDef);
            body.SetMassFromShapes();
        }
        //カニSpriteを返す
        private function getKani():Sprite {
            var myBitmapData:BitmapData = new BitmapData(loader.width, loader.height, true, 0x00000000);
            myBitmapData.draw(loader);
            var bmp:Bitmap = new Bitmap(myBitmapData);
            var sp:Sprite = new Sprite();
            
            //sp.graphics.beginFill(0x999999);
            //sp.graphics.drawRect(-bmp.width * 0.5, -bmp.height * 0.5, bmp.width, bmp.height);
            
            bmp.x = -bmp.width * 0.5;
            bmp.y = -bmp.height * 0.5;
            sp.addChild(bmp);
            return sp;
        }
        //-----------------------------------------------------
    }

}