/**
 * Copyright n.otsu1029 ( http://wonderfl.net/user/n.otsu1029 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dgXI
 */

// forked from Hakuhin's Pixel Bender (線状にワイプするフィルタ)
// -------------------------------------------------
//
// 線状にワイプするフィルタ
// 
// フィルタは複数適応できるので
// 単純な動きを組み合わせて新しい演出を作っています。
//
// -------------------------------------------------
package {
    import flash.events.*;
    import flash.display.*;
    import flash.net.*;
    import flash.text.*;
    import flash.utils.*;
    import flash.system.*;
    import flash.geom.*;
    import flash.filters.*;
    import flash.ui.*;

    public class Main extends Sprite {
        public function Main() {

 

// -------------------------------------------------
// コンストラクタ
// -------------------------------------------------

// フレームレート
stage.frameRate = 60;

// 100%表示
stage.scaleMode = StageScaleMode.NO_SCALE;

// 左上
stage.align = StageAlign.TOP_LEFT;
stage.align = "TL";

// スプライトを作成
var sprite:Sprite = new Sprite();
addChild(sprite);


// 画像のURL
var graphic_url:Array = [
    "http://actionscript.web.officelive.com/wonderfl/bg000.jpg",
    "http://actionscript.web.officelive.com/wonderfl/bg001.jpg",
    "http://actionscript.web.officelive.com/wonderfl/bg002.jpg",
];

// リソース読み込み開始
load(load_complete_func,graphic_url);

// 読み込み終了
function load_complete_func():void{
    // 初期化へ
    init();
}

// リソースを格納する入れ物
var loader_container : Array = new Array();


// -------------------------------------------------
// 読み込み
// -------------------------------------------------
function load(complete_func:Function,url_array:Array):void{

    // URLを取り出す
    var url : String = url_array.shift();

    // URLが無くなればコールバック関数を呼び出して終了
    if(!url){
        // 読み込み終了
        complete_func();
        return;
    }

    // ローダー
    var loader_obj : Loader = new Loader();

    // 読み込み開始
    loader_obj.load(new URLRequest(url));

    // 読み込み終了
    var info : LoaderInfo = loader_obj.contentLoaderInfo;
    info.addEventListener (Event.INIT,LoaderInfoInitFunc);
    function LoaderInfoInitFunc (event : Event):void {

        // コンテナに格納
        loader_container.push(loader_obj);
    
        // 再帰読み込み
        load(complete_func,url_array);
    }
}


// -------------------------------------------------
// 初期化
// -------------------------------------------------
function init():void{

    // ステージサイズ
    var w:uint;
    var h:uint;
    
    // リサイズ時にフィット
    stage.addEventListener(Event.RESIZE,ResizeFunc);
    function ResizeFunc(e:Event):void{
        w = stage.stageWidth;
        h = stage.stageHeight;
        
        sprite.width = w;
        sprite.height = h;
    }
    ResizeFunc(null);

    // シェーダバイトコード
    var binary_h : ByteArray = LineWipeHorizontalFilterGetByteArray();
    var binary_v : ByteArray = LineWipeVerticalFilterGetByteArray();
    
    // 水平方向シェーダ作成
    var shader_h:Shader = new Shader();
    shader_h.byteCode = binary_h;
    var filter_h:ShaderFilter = new ShaderFilter(shader_h); 

    // 垂直方向シェーダ作成
    var shader_v:Shader = new Shader();
    shader_v.byteCode = binary_v;
    var filter_v:ShaderFilter = new ShaderFilter(shader_v); 

    // パラメータアクセス用
    var data_h : ShaderData  = shader_h.data;
    var data_v : ShaderData  = shader_v.data;
    var param : ShaderParameter;

    // パラメータ
    var offset_h:Number = 0;    // オフセット（横）
    var width_h:Number = 20;    // 幅（横）
    var offset_v:Number = 0;    // オフセット（縦）
    var width_v:Number = 50;    // 幅（縦）
    
    // 水平方向フィルタのパラメータ更新
    function LineWipeHorizontalFilterUpdate():void{

        // オフセット
        param = data_h.offset;
        param.value = [offset_h];

        // 幅
        param = data_h.width;
        param.value = [width_h];
    }

    // 垂直方向フィルタのパラメータ更新
    function LineWipeVerticalFilterUpdate():void{

        //  オフセット
        param = data_v.offset;
        param.value = [offset_v];

        // 幅
        param = data_v.width;
        param.value = [width_v];
    }


    // テキスト表示
    var tf : TextField = new TextField();
    tf.x = 5;
    tf.y = 5;
    tf.width = 250;
    tf.height = 30;
    tf.border = true;
    tf.background = true;
    tf.alpha = 0.9;
    
    // 書式
    var format : TextFormat = new TextFormat();
    format.font = "ＭＳ ゴシック";
    tf.defaultTextFormat = format;

    addChild(tf);
    addEventListener(Event.ENTER_FRAME,function(e:Event):void{
        var str:String = "";
        str += "横方向幅:" + width_h + "　(上下キーで変更)\n";
        str += "縦方向幅:" + width_v + "　(左右キーで変更)\n";

        tf.text = str;
    });
    
    
    // キー操作
    stage.addEventListener(KeyboardEvent.KEY_DOWN, KeyDown);
    function KeyDown(event:KeyboardEvent):void{
        if(event.keyCode == Keyboard.UP)        width_h -= 1;
        if(event.keyCode == Keyboard.DOWN)        width_h += 1;
        if(event.keyCode == Keyboard.LEFT)        width_v -= 1;
        if(event.keyCode == Keyboard.RIGHT)        width_v += 1;

        if(width_h < 0.0)    width_h = 0.0;
        if(width_v < 0.0)    width_v = 0.0;
    };


    // -------------------------------------------------
    // 実行
    // -------------------------------------------------
    var WITE_TIME : uint = 30;    // 待機時間
    var WIPE_TIME : uint = 90;    // ワイプ時間

    // ワーク
    var obj : Object = new Object();
    obj.exec = horizontal_wait_init;    // 関数参照
    obj.resource_idx = 0;            // リソース参照番号

    addEventListener(Event.ENTER_FRAME,function(e:Event):void{
        obj.exec(obj);
    });

    // -------------------------------------------------
    // 横待機
    // -------------------------------------------------
    function horizontal_wait_init(obj:Object):void{
        obj.frame = WITE_TIME;
        
        // 表示リストを外す
        ContainerRemoveChildAll(sprite);
        
        // リソース参照を１つ進める
        resource_next(obj);
        
        // リソースを配置
        resource_attach(obj);
        
        // フィルタを無効化
        resource_filter_disable(obj);
            
        // 非表示
        loader_container[obj.resource_idx].visible = false;

        // リサイズ
        ResizeFunc(null);
        
        obj.exec = horizontal_wait_exec;
        obj.exec(obj);
    }
    function horizontal_wait_exec(obj:Object):void{
        obj.frame -= 1;
        if(obj.frame < 0){
            obj.exec = horizontal_wipe_init;
        }
    }

    // -------------------------------------------------
    // 横移動
    // -------------------------------------------------
    function horizontal_wipe_init(obj:Object):void{
        obj.frame = WIPE_TIME;
        
        // 表示
        loader_container[obj.resource_idx].visible = true;
        
        obj.exec = horizontal_wipe_exec;
        obj.exec(obj);
    }
    function horizontal_wipe_exec(obj:Object):void{        
        var d : Number = obj.frame / WIPE_TIME;
        offset_h = w * (d * d * d);
        
        // フィルタを適応
        LineWipeHorizontalFilterUpdate();
        loader_container[obj.resource_idx].filters = [filter_h];

        obj.frame -= 1;
        if(obj.frame < 0){
            obj.exec = vertical_wait_init;
        }
    }

    // -------------------------------------------------
    // 縦待機
    // -------------------------------------------------
    function vertical_wait_init(obj:Object):void{
        obj.frame = WITE_TIME;

        // 表示リストを外す
        ContainerRemoveChildAll(sprite);
        
        // リソース参照を１つ進める
        resource_next(obj);
        
        // リソースを配置
        resource_attach(obj);
        
        // フィルタを無効化
        resource_filter_disable(obj);
            
        // 非表示
        loader_container[obj.resource_idx].visible = false;

        // リサイズ
        ResizeFunc(null);

        obj.exec = vertical_wait_exec;
        obj.exec(obj);
    }
    function vertical_wait_exec(obj:Object):void{
        obj.frame -= 1;
        if(obj.frame < 0){
            obj.exec = vertical_wipe_init;
        }
    }

    // -------------------------------------------------
    // 縦移動
    // -------------------------------------------------
    function vertical_wipe_init(obj:Object):void{
        obj.frame = WIPE_TIME;

        // 表示
        loader_container[obj.resource_idx].visible = true;

        obj.exec = vertical_wipe_exec;
        obj.exec(obj);
    }
    function vertical_wipe_exec(obj:Object):void{
        var d : Number = obj.frame / WIPE_TIME;
        offset_v = h * (d * d * d);

        // フィルタを適応
        LineWipeVerticalFilterUpdate();
        loader_container[obj.resource_idx].filters = [filter_v];

        obj.frame -= 1;
        if(obj.frame < 0){
            obj.exec = hv_wait_init;
        }
    }

    // -------------------------------------------------
    // 横縦待機
    // -------------------------------------------------
    function hv_wait_init(obj:Object):void{
        obj.frame = WITE_TIME;

        // 表示リストを外す
        ContainerRemoveChildAll(sprite);
        
        // リソース参照を１つ進める
        resource_next(obj);
        
        // リソースを配置
        resource_attach(obj);
        
        // フィルタを無効化
        resource_filter_disable(obj);
            
        // 非表示
        loader_container[obj.resource_idx].visible = false;

        // リサイズ
        ResizeFunc(null);

        obj.exec = hv_wait_exec;
        obj.exec(obj);
    }
    function hv_wait_exec(obj:Object):void{
        obj.frame -= 1;
        if(obj.frame < 0){
            obj.exec = hv_wipe_init;
        }
    }

    // -------------------------------------------------
    // 横縦移動
    // -------------------------------------------------
    function hv_wipe_init(obj:Object):void{
        obj.frame = WIPE_TIME;

        // 表示
        loader_container[obj.resource_idx].visible = true;

        obj.exec = hv_wipe_exec;
        obj.exec(obj);
    }
    function hv_wipe_exec(obj:Object):void{
        var d : Number = obj.frame / WIPE_TIME;
        offset_h = h * (d * d * d);
        offset_v = h * (d * d * d);

        // フィルタを適応
        LineWipeHorizontalFilterUpdate();
        LineWipeVerticalFilterUpdate();
        loader_container[obj.resource_idx].filters = [filter_h , filter_v];

        obj.frame -= 1;
        if(obj.frame < 0){
            obj.exec = vh_wait_init;
        }
    }

    // -------------------------------------------------
    // 縦横待機
    // -------------------------------------------------
    function vh_wait_init(obj:Object):void{
        obj.frame = WITE_TIME;

        // 表示リストを外す
        ContainerRemoveChildAll(sprite);
        
        // リソース参照を１つ進める
        resource_next(obj);
        
        // リソースを配置
        resource_attach(obj);
        
        // フィルタを無効化
        resource_filter_disable(obj);
            
        // 非表示
        loader_container[obj.resource_idx].visible = false;

        // リサイズ
        ResizeFunc(null);

        obj.exec = vh_wait_exec;
        obj.exec(obj);
    }
    function vh_wait_exec(obj:Object):void{
        obj.frame -= 1;
        if(obj.frame < 0){
            obj.exec = vh_wipe_init;
        }
    }

    // -------------------------------------------------
    // 縦横移動
    // -------------------------------------------------
    function vh_wipe_init(obj:Object):void{
        obj.frame = WIPE_TIME;

        // 表示
        loader_container[obj.resource_idx].visible = true;

        obj.exec = vh_wipe_exec;
        obj.exec(obj);
    }
    function vh_wipe_exec(obj:Object):void{
        var d : Number = obj.frame / WIPE_TIME;
        offset_h = h * (d * d * d);
        offset_v = h * (d * d * d);

        // フィルタを適応
        LineWipeHorizontalFilterUpdate();
        LineWipeVerticalFilterUpdate();
        loader_container[obj.resource_idx].filters = [filter_v,filter_h];

        obj.frame -= 1;
        if(obj.frame < 0){
            obj.exec = horizontal_wait_init;
        }
    }

    // -------------------------------------------------
    // スプライトをセット
    // -------------------------------------------------
    function resource_attach(obj:Object):void{
        // 前面配置
        var idx:int = obj.resource_idx;
        sprite.addChildAt(loader_container[idx],0);
        
        
        // 背面配置
        idx --;
        if(idx < 0)    idx += loader_container.length;
        sprite.addChildAt(loader_container[idx],0);        
    }

    // -------------------------------------------------
    // リソース参照カウント
    // -------------------------------------------------
    function resource_next(obj:Object):void{
        obj.resource_idx ++;
        if(obj.resource_idx >= loader_container.length)    obj.resource_idx = 0;
    }
    
    // -------------------------------------------------
    // フィルタを無効化
    // -------------------------------------------------
    function resource_filter_disable(obj:Object):void{
        var i:int = 0;
        var num:int = loader_container.length;
        for(i=0;i<num;i++){
            loader_container[i].filters = null;
        }
    }

    // -------------------------------------------------
    // 表示リストをすべて外す
    // -------------------------------------------------
    function ContainerRemoveChildAll(container:DisplayObjectContainer):void{
        while(true){
            if(!container.numChildren)    return;
            container.removeChild(container.getChildAt(0));
        }
    }

}
    

// -------------------------------------------------
// シェーダバイトコード(水平方向)
// -------------------------------------------------
function LineWipeHorizontalFilterGetByteArray():ByteArray{

    var a:ByteArray = new ByteArray();
    var f:Function;

    f = a.writeUnsignedInt;
    f(0xa5010000); f(0x00a41800); f(0x4c696e65); f(0x57697065); 
    f(0x486f7269); f(0x7a6f6e74); f(0x616c4669); f(0x6c746572); 
    f(0xa00c6e61); f(0x6d657370); f(0x61636500); f(0x6c696e65); 
    f(0x20776970); f(0x6520686f); f(0x72697a6f); f(0x6e74616c); 
    f(0x00a00c76); f(0x656e646f); f(0x72004861); f(0x6b756869); 
    f(0x6e00a008); f(0x76657273); f(0x696f6e00); f(0x0100a00c); 
    f(0x64657363); f(0x72697074); f(0x696f6e00); f(0x90fc8ff3); 
    f(0x82c9838f); f(0x83438376); f(0x82b382b9); f(0x82e98374); 
    f(0x8342838b); f(0x835e00a1); f(0x01020000); f(0x0c5f4f75); 
    f(0x74436f6f); f(0x726400a3); f(0x00047372); f(0x6300a102); 
    f(0x0401000f); f(0x64737400); f(0xa1010100); f(0x00026f66); 
    f(0x66736574); f(0x00a20164); f(0x65666175); f(0x6c745661); 
    f(0x6c756500); f(0x00000000); f(0xa20c6465); f(0x73637269); 
    f(0x7074696f); f(0x6e00838f); f(0x83438376); f(0x82cc8349); 
    f(0x8374835a); f(0x83628367); f(0x88ca9275); f(0x00a10101); 
    f(0x00000177); f(0x69647468); f(0x00a2016d); f(0x696e5661); 
    f(0x6c756500); f(0x3f800000); f(0xa2016465); f(0x6661756c); 
    f(0x7456616c); f(0x75650041); f(0x200000a2); f(0x0c646573); 
    f(0x63726970); f(0x74696f6e); f(0x00838f83); f(0x43837682); 
    f(0xcc959d00); f(0x1d0200c1); f(0x00001000); f(0x1d020020); 
    f(0x02004000); f(0x04020010); f(0x0000c000); f(0x03020010); 
    f(0x02008000); f(0x1a030080); f(0x0200c000); f(0x1d020010); 
    f(0x03000000); f(0x32030080); f(0x40000000); f(0x1d030040); 
    f(0x0200c000); f(0x08030040); f(0x03000000); f(0x1e018080); 
    f(0x03004000); f(0x32018040); f(0x00000000); f(0x28018080); 
    f(0x01804000); f(0x1d018020); f(0x00800000); f(0x34000000); 
    f(0x01808000); f(0x1d030080); f(0x00008000); f(0x35000000); 
    f(0x00000000); f(0x32030040); f(0x00000000); f(0x02030040); 
    f(0x00008000); f(0x1d030080); f(0x03004000); f(0x36000000); 
    f(0x00000000); f(0x01020080); f(0x03000000); f(0x310400f1); 
    f(0x02001000); f(0x1d0100f3); f(0x04001b00); 

    return a;

}






// -------------------------------------------------
// シェーダバイトコード（垂直方向）
// -------------------------------------------------
function LineWipeVerticalFilterGetByteArray():ByteArray{

    var a:ByteArray = new ByteArray();
    var f:Function;

    f = a.writeUnsignedInt;
    f(0xa5010000); f(0x00a41600); f(0x4c696e65); f(0x57697065); 
    f(0x56657274); f(0x6963616c); f(0x46696c74); f(0x6572a00c); 
    f(0x6e616d65); f(0x73706163); f(0x65006c69); f(0x6e652077); 
    f(0x69706520); f(0x76657274); f(0x6963616c); f(0x00a00c76); 
    f(0x656e646f); f(0x72004861); f(0x6b756869); f(0x6e00a008); 
    f(0x76657273); f(0x696f6e00); f(0x0100a00c); f(0x64657363); 
    f(0x72697074); f(0x696f6e00); f(0x908292bc); f(0x95fb8cfc); 
    f(0x82c990fc); f(0x8ff382c9); f(0x838f8343); f(0x837682b3); 
    f(0x82b982e9); f(0x83748342); f(0x838b835e); f(0x00a10102); 
    f(0x00000c5f); f(0x4f757443); f(0x6f6f7264); f(0x00a30004); 
    f(0x73726300); f(0xa1020401); f(0x000f6473); f(0x7400a101); 
    f(0x01000002); f(0x6f666673); f(0x657400a2); f(0x01646566); 
    f(0x61756c74); f(0x56616c75); f(0x65000000); f(0x0000a20c); 
    f(0x64657363); f(0x72697074); f(0x696f6e00); f(0x838f8343); 
    f(0x837682cc); f(0x83498374); f(0x835a8362); f(0x836788ca); 
    f(0x927500a1); f(0x01010000); f(0x01776964); f(0x746800a2); 
    f(0x016d696e); f(0x56616c75); f(0x65003f80); f(0x0000a201); 
    f(0x64656661); f(0x756c7456); f(0x616c7565); f(0x00412000); 
    f(0x00a20c64); f(0x65736372); f(0x69707469); f(0x6f6e0083); 
    f(0x8f834383); f(0x7682cc95); f(0x9d001d02); f(0x00c10000); 
    f(0x10001d02); f(0x00200200); f(0x00000402); f(0x00100000); 
    f(0xc0000302); f(0x00100200); f(0x80001a03); f(0x00800200); 
    f(0xc0001d02); f(0x00100300); f(0x00003203); f(0x00804000); 
    f(0x00001d03); f(0x00400200); f(0xc0000803); f(0x00400300); 
    f(0x00001e01); f(0x80800300); f(0x40003201); f(0x80400000); 
    f(0x00002801); f(0x80800180); f(0x40001d01); f(0x80200080); 
    f(0x00003400); f(0x00000180); f(0x80001d03); f(0x00800000); 
    f(0x80003500); f(0x00000000); f(0x00003203); f(0x00400000); 
    f(0x00000203); f(0x00400000); f(0x80001d03); f(0x00800300); 
    f(0x40003600); f(0x00000000); f(0x00000102); f(0x00400300); 
    f(0x00003104); f(0x00f10200); f(0x10001d01); f(0x00f30400); 
    
    f = a.writeShort;
    f(0x1b00);

    return a;
}


        }
    }
}




// ↓ pbk ファイルのコード
/* -----------------------------------------------------------------------------
    パラメータ
    offset            ワイプのオフセット位置
    width            ワイプの幅
 ----------------------------------------------------------------------------- */
/*
<languageVersion : 1.0;>
kernel LineWipeHorizontalFilter<
    namespace : "line wipe horizontal";
    vendor : "Hakuhin";
    version : 1;
    description : "線状にワイプさせるフィルタ";
>{
    input image4 src;    // 入力イメージ
    output pixel4 dst;    // 出力ピクセル


    // -------------------------------------
    // パラメータ
    // -------------------------------------
    parameter float offset<
        defaultValue:float(0.0);
        description : "ワイプのオフセット位置";
    >;
    parameter float width<
        minValue:float(1.0);
        defaultValue:float(10.0);
        description : "ワイプの幅";
    >;


    // -------------------------------------
    // ピクセルごとに実行される関数
    // -------------------------------------
    void evaluatePixel(){

        // ピクセルの位置を取得
        float2 pos = outCoord();

        // 原点からの長さを求める
        float distance = pos.y;
        
        // 周期に丸める
        float d = floor(distance / width);
        
        // 移動方向を調べる
        float x;
        if(int(mod(d,2.0)) == 0)    x = offset;
        else                        x =-offset;

        // オフセットを取得して座標にセット
        pos.x += x;

        // ソースイメージからピクセルカラーを取得して出力
        dst = sampleLinear(src,pos);
    }
}
*/


/* -----------------------------------------------------------------------------
    パラメータ
    offset            ワイプのオフセット位置
    width            ワイプの幅
 ----------------------------------------------------------------------------- */
/*
<languageVersion : 1.0;>
kernel LineWipeVerticalFilter<
    namespace : "line wipe vertical";
    vendor : "Hakuhin";
    version : 1;
    description : "垂直方向に線状にワイプさせるフィルタ";
>{
    input image4 src;    // 入力イメージ
    output pixel4 dst;    // 出力ピクセル


    // -------------------------------------
    // パラメータ
    // -------------------------------------
    parameter float offset<
        defaultValue:float(0.0);
        description : "ワイプのオフセット位置";
    >;
    parameter float width<
        minValue:float(1.0);
        defaultValue:float(10.0);
        description : "ワイプの幅";
    >;


    // -------------------------------------
    // ピクセルごとに実行される関数
    // -------------------------------------
    void evaluatePixel(){

        // ピクセルの位置を取得
        float2 pos = outCoord();

        // 原点からの長さを求める
        float distance = pos.x;
        
        // 周期に丸める
        float d = floor(distance / width);
        
        // 移動方向を調べる
        float y;
        if(int(mod(d,2.0)) == 0)    y = offset;
        else                        y =-offset;

        // オフセットを取得して座標にセット
        pos.y += y;

        // ソースイメージからピクセルカラーを取得して出力
        dst = sampleLinear(src,pos);
    }
}
*/



// -------------------------------------------------
// 外部画像をサムネイルとしてキャプチャ
// -------------------------------------------------
import flash.net.*;
import flash.events.*;
import flash.display.*;
import flash.geom.*;
function ThumbnailCapture(url:String,time:uint,stage:Stage):void{

    // キャプチャタイミング
    Wonderfl.capture_delay( time );

    
    // スプライト作成
    var sprite : Sprite = new Sprite();

    // ステージ最前面に配置
    stage.addChildAt(sprite,stage.numChildren);
    
    // ローダー
    var loader_obj : Loader = new Loader();
    loader_obj.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

        // メモリからインスタンス化
        var loader_memory : Loader = new Loader();
        loader_memory.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

            // キャプチャ
            var bmp : BitmapData = new BitmapData(loader_memory.width,loader_memory.height,true,0);
            sprite.addChild(loader_memory);
            bmp.draw(sprite);
            sprite.removeChild(loader_memory);
            loader_memory.unload();
            loader_obj.unload();
            loader_memory = null;
            loader_obj = null;
            
            
            // 画像を配置
            var bmp_obj : Bitmap = new Bitmap(bmp);
            bmp_obj .width = stage.stageWidth;
            bmp_obj .height = stage.stageHeight;
            stage.addChild(bmp_obj );
            
        });
        
        // 読み込み開始
        loader_memory.loadBytes(loader_obj.contentLoaderInfo.bytes);
    });
    
    // 読み込み開始
    loader_obj.load(new URLRequest(url));
}