/**
 * Copyright Diablo404 ( http://wonderfl.net/user/Diablo404 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dgR4
 */

// forked from littlepad's Draw Lines
package {
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.Stage;
    import flash.events.Event;
    import flash.display.Sprite;
    
    [SWF(widht="1280", height="720", backgroundColor="0xFFFFFF")]
    
    public class DrawLines extends Sprite {    
        public function DrawLines() {  
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            addEventListener(Event.ADDED_TO_STAGE, init)
        }
        
        private function init(e:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            addChild(new Balls());
            addChild(new Balls());
            addChild(new Balls());
        }

    }
}

import flash.display.Stage;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.events.Event;
import flash.display.Sprite;

internal class Balls extends Sprite {
    private var _bmd:BitmapData;
    private var _ball1:Ball;
    private var _ball2:Ball;
    public function Balls() {
        addEventListener(Event.ADDED_TO_STAGE, init)
    }

    private function init(e:Event):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        
        _bmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
        addChild(new Bitmap(_bmd));
        
        _ball1 = new Ball();
        _ball2 = new Ball();
        
        _ball1.x = uint(Math.random() * stage.stageWidth);
        _ball1.y = uint(Math.random() * stage.stageHeight);
        _ball2.x = uint(Math.random() * stage.stageWidth);
        _ball2.y = uint(Math.random() * stage.stageHeight);
        
        addChild(_ball1);
        addChild(_ball2);
        
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    private function onEnterFrame(e:Event):void {
        var s:Sprite = new Sprite();
        s.graphics.lineStyle(1, 0, .1);
        s.graphics.moveTo(_ball1.x, _ball1.y);
        s.graphics.lineTo(_ball2.x, _ball2.y);
        s.graphics.endFill();
        _bmd.draw(s);
    }

}

internal class Ball extends Sprite {
    private var _vectorX:int = 1;
    private var _vectorY:int = 1;
    private var _vX:Number = 5;
    private var _vY:Number = 5;
    public function Ball() {
        addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        
        this.graphics.beginFill(0);
        this.graphics.drawCircle(0, 0, 2);
        this.graphics.endFill();
        
        if(Math.random() * 2 - 1 < 0) _vectorX = -1;
        if(Math.random() * 2 - 1 < 0) _vectorY = -1;
        
        _vX *= Math.random();
        _vY *= Math.random();
        
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    private function onEnterFrame(e:Event):void {
        this.x += _vX * _vectorX;
        this.y += _vY * _vectorY;
        if(this.x < 0 || this.x > stage.stageWidth) _vectorX *= -1;
        if(this.y < 0 || this.y > stage.stageHeight) _vectorY *= -1;
    }

}
