/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dfup
 */

package {
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.display.Bitmap;
    import flash.geom.Rectangle;
    import flash.system.LoaderContext;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.easing.*;
    
    [SWF(backgroundColor="#ffffff", width="465", height="465", frameRate="30")]
    
    public class FlashTest extends Sprite {
        private var loader:Loader;
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private static var filePath:String = "e/ef/ef33/ef332d0347b2d07b664eef52f6b4302890550a8f";
        private var logo:Bitmap;
        private var sand:SandEffect;
        
        public function FlashTest() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();            
        }
        
        private function init():void {
            var rect:Rectangle = new Rectangle(0, 0, 400, 200);
            var area:Rectangle = new Rectangle(0, 50, 400, 100);
            sand = new SandEffect(rect, area, 200);
            addChild(sand);
            sand.x = 32;
            sand.y = 132;
            
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, initialize, false, 0, true);
            loader.load(new URLRequest(basePath + filePath), new LoaderContext(true));
        }
        
        private function initialize(evt:Event):void {
            loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, initialize);
            logo = Bitmap(loader.content);
            addChild(logo);
            logo.x = 32;
            logo.y = 182;
            logo.alpha = 0;
            logo.visible = false;
            
            sand.search(logo);
            sand.addEventListener(Event.COMPLETE, complete, false, 0, true);
            sand.start();
        }
        
        private function complete(evt:Event):void {
            sand.removeEventListener(Event.COMPLETE, complete);
            var itween:ITween = BetweenAS3.parallel(
                BetweenAS3.to(logo, {alpha:1, visible:1}, 0.4, Linear.easeNone),
                BetweenAS3.delay(BetweenAS3.to(sand, {alpha:0, visible:0}, 0.4, Linear.easeNone), 0.2)
            );
            itween.play();
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.display.DisplayObject;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.*;

class SandEffect extends Sprite {
    private var rect:Rectangle;
    private var area:Rectangle;
    private var offset:uint;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var detection:DetectPixels;
    private var target:DisplayPixels;
    private var threshold:uint = 0x80000000;
    private var maps:Array;
    private var dots:Array;
    private var itween:ITween;
    private var tweens:Array;
    private static var uint:uint = 10;
    
    public function SandEffect(r:Rectangle, a:Rectangle, o:uint = 0) {
        rect = r;
        area = a;
        offset = o;
        init();
    }
    
    private function init():void {
        bitmapData = new BitmapData(rect.width + offset, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
    }
    public function search(t:DisplayObject):void {
        target = t;
        detection = new DetectPixels(1);
        detection.search(target, rect, threshold);
        maps = detection.pixels();
        plot(maps);
    }
    private function plot(maps:Array):void {
        dots = new Array();
        tweens = new Array();
        for(var n:uint=0; n < maps.length; n++) {
            var point:Object = maps[n];
            var dot:SandDot = new SandDot(point.color);
            dot.alpha = 0;
            dot.x = dot.px = area.x + point.x + offset - Math.random()*50;
            dot.y = dot.py = area.y + point.y + (Math.random() - 0.5)*100;
            dot.tx = area.x + point.x;
            dot.ty = area.y + point.y;
            dot.cx = (dot.px + dot.tx)/2 + (Math.random() - 0.5)*100;
        }

    }




}
