/**
 * Copyright mezumona ( http://wonderfl.net/user/mezumona )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dffe
 */

/**
 * 
 */
package
{
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    public class PushPopSpeedTest extends Sprite
    {
   
        public static const LOOP_TIME:int = 24;
        private var textField_:TextField = new TextField();
        private var waiter_:Timer = new Timer(3000);

        public function PushPopSpeedTest()
        {
            if (stage) init();
            else       addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(event:Event = null):void
        {
            textField_.autoSize = TextFieldAutoSize.LEFT;
            textField_.defaultTextFormat = new TextFormat("_typewriter", 12);
            addChild(textField_);
            trace("メソッドを呼ぶVectorループの速度比較");
            trace("試行回数:", LOOP_TIME);
            trace("----");
            waiter_.addEventListener(TimerEvent.TIMER, waiterTimerHandler);
            waiter_.start();
        }


        private function trace(...rest):void
        {
            textField_.appendText(rest.join(" ").concat("\n"));
        }

        private var testCases_:Vector.<Class> = new <Class>[
            ForLoopWIthNormalMethod,
            ForEachLoopWithNormalMethod,
            ForLoopWithDefaultArgs,
            ForEachLoopWithDefaultArgs,
            ForEachMethod,
            ForEachMethodWithDefaultArgs,
            ForEachMethodWithWrappedMethod,
        ];

        private var repeatCount_:int = 0;
        private function waiterTimerHandler(event:TimerEvent):void
        {
            if (repeatCount_ < testCases_.length) {
                var testingCase:ITestCase = ITestCase(new testCases_[repeatCount_]());
                trace(testingCase.name, testingCase.exec(LOOP_TIME), "ms");
                
                // また 3 秒後
                waiter_.reset();
                waiter_.start();
                ++repeatCount_;
            }
            // 終了
            else {
                trace("終了。");
                waiter_.stop();
                waiter_.removeEventListener(TimerEvent.TIMER, waiterTimerHandler);
                waiter_ = null;
            }
        }
    }
}



/**
 * テストを実行する時に簡単にできるようにするためのインターフェイスです.
 */
internal interface ITestCase
{
    function get name():String;
    function exec(repeat:int):int;
}



internal const TARGET_VECTOR:Vector.<String> = new <String>[
    "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z",
//    "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z",
//    "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "+", "/", "="
];
TARGET_VECTOR.fixed = true;



import flash.utils.getTimer;
/**
 * 
 */
internal class ForLoopWIthNormalMethod implements ITestCase
{
    public function get name():String { return "for (normalArg)      :"; }
    public function exec(repeat:int):int
    {
        var target:Vector.<String> = TARGET_VECTOR;

        const startTime:int = getTimer();
        while (repeat--) {
            const length:int = target.length;
            for (var i:int = 0; i < length; ++i) hoge(target[i]);
        }
        return getTimer() - startTime;
    }

    private function hoge(item:String):void
    {
        trace(item.charCodeAt());
    }

}



import flash.utils.getTimer;
/**
 * 
 */
internal class ForEachLoopWithNormalMethod implements ITestCase
{
    public function get name():String { return "for each (normalArg) :"; }
    public function exec(repeat:int):int
    {
        var target:Vector.<String> = TARGET_VECTOR;

        const startTime:int = getTimer();
        while (repeat--) {
            for each (var item:String in target) hoge(item);
        }
        return getTimer() - startTime;
    }

    private function hoge(item:String):void
    {
        trace(item.charCodeAt());
    }

}



import flash.utils.getTimer;
/**
 * 
 */
internal class ForLoopWithDefaultArgs implements ITestCase
{
    public function get name():String { return "for (defaultArg)     :"; }
    public function exec(repeat:int):int
    {
        var target:Vector.<String> = TARGET_VECTOR;

        const startTime:int = getTimer();
        while (repeat--) {
            const length:int = target.length;
            for (var i:int = 0; i < length; ++i) hoge(target[i]);
        }
        return getTimer() - startTime;
    }

    private function hoge(item:String, index:int = 0, vec:Vector.<String> = null):void
    {
        trace(item.charCodeAt());
    }

}



import flash.utils.getTimer;
/**
 * 
 */
internal class ForEachLoopWithDefaultArgs implements ITestCase
{
    public function get name():String { return "for each (defaultArg):"; }
    public function exec(repeat:int):int
    {
        var target:Vector.<String> = TARGET_VECTOR;

        const startTime:int = getTimer();
        while (repeat--) {
            for each (var item:String in target) hoge(item);
        }
        return getTimer() - startTime;
    }

    private function hoge(item:String, index:int = 0, vec:Vector.<String> = null):void
    {
        trace(item.charCodeAt());
    }

}



import flash.utils.getTimer;
/**
 * 
 */
internal class ForEachMethod implements ITestCase
{
    public function get name():String { return "forEach()            :"; }
    public function exec(repeat:int):int
    {
        var target:Vector.<String> = TARGET_VECTOR;

        const startTime:int = getTimer();
        while (repeat--) {
            target.forEach(hoge);
        }
        return getTimer() - startTime;
    }

    private function hoge(item:String, index:int, vec:Vector.<String>):void
    {
        trace(item.charCodeAt());
    }

}



import flash.utils.getTimer;
/**
 * 
 */
internal class ForEachMethodWithDefaultArgs implements ITestCase
{
    public function get name():String { return "forEach() DefaultArg :"; }
    public function exec(repeat:int):int
    {
        var target:Vector.<String> = TARGET_VECTOR;

        const startTime:int = getTimer();
        while (repeat--) {
            target.forEach(hoge);
        }
        return getTimer() - startTime;
    }

    private function hoge(item:String, index:int = 0, vec:Vector.<String> = null):void
    {
        trace(item.charCodeAt());
    }

}



import flash.utils.getTimer;
/**
 * 
 */
internal class ForEachMethodWithWrappedMethod implements ITestCase
{
    public function get name():String { return "forEach() Wrapped    :"; }
    public function exec(repeat:int):int
    {
        var target:Vector.<String> = TARGET_VECTOR;

        const startTime:int = getTimer();
        while (repeat--) {
            target.forEach(wrapper);
        }
        return getTimer() - startTime;
    }

    private function wrapper(item:String, index:int, vec:Vector.<String>):void
    {
        hoge(item);
    }


    private function hoge(item:String):void
    {
        trace(item.charCodeAt());
    }

}
