/**
 * Copyright hi.kurosawa ( http://wonderfl.net/user/hi.kurosawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dfOw
 */

package {
    //------------------------------------------
    //ジュリア集合の画像のスライドショー(顔に見えるところ)
    // URL:http://programmingatelier.net/
    //------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.utils.setTimeout;
    import flash.display.StageScaleMode; 
    import flash.display.StageAlign;
    
    public class face extends Sprite {
        //それなりの画像が出来る位置（中心）と幅（d*2）
        public var arrItiData:Array = new Array(
            {a:-1,af:false,b:0.16,bf:true,x:-0.0786869806094183,y:-0.660245225251494,d:0.00812417031790732},
            {a:-0.975,af:false,b:0.19,bf:true,x:0.356850545870331,y:-0.138256656084333,d:5.10529877688104E-05},
            {a:-0.97,af:false,b:0.205,bf:true,x:-0.0920141419081966,y:-0.747783409951863,d:0.000402038387371409},
            {a:-0.99,af:false,b:0.175,bf:true,x:-0.309790097740747,y:0.376310847620574,d:0.00560807562890562},
            {a:-0.985,af:false,b:0.215,bf:true,x:-0.101788338191423,y:-0.687514705788675,d:0.0217514821693002},
            {a:-0.985,af:false,b:0.18,bf:true,x:-0.248880441958234,y:-0.361206846401956,d:0.00411181137415883},
            {a:-1,af:false,b:0.18,bf:true,x:-0.159666415486736,y:-0.747367117912291,d:0.000843121446374841},
            {a:-0.97,af:false,b:0.27,bf:true,x:-0.712116591666667,y:-0.542063608333333,d:2.91666666666667E-06},
            {a:-0.73,af:false,b:-0.09,bf:true,x:1.48943846792533,y:-0.0219076933973333,d:4.97777777777778E-07},
            {a:-0.08,af:false,b:0.67,bf:true,x:0.428917596187533,y:-0.143679233869056,d:3.88544205791062E-06},
            {a:-0.79,af:false,b:0.87,bf:true,x:-0.950610595703125,y:-0.457524169921875,d:4.2724609375E-05},
            {a:-0.37,af:true,b:-0.1,bf:false,x:0.73168253968254,y:0.411079365079365,d:0.0793650793650794},
            {a:-0.4,af:true,b:-0.1,bf:false,x:0.3878,y:-0.73346,d:0.00411764705882353},
            {a:-0.16,af:false,b:0.78,bf:true,x:-0.499489169060532,y:-0.70723088365378,d:1.57343038260565E-05},
            {a:0.28,af:false,b:0.49,bf:true,x:0.553,y:0.4445,d:0.0875},
            {a:0.26,af:false,b:0.49,bf:true,x:0.384854762140692,y:0.153292925381524,d:0.00561266691814835},
            {a:-0.73,af:false,b:0.84,bf:true,x:0.00580931282669699,y:-0.0287972957321622,d:1.4808713583386E-08},
            {a:-0.79,af:false,b:0.87,bf:true,x:0.0135396671156815,y:0.00628131458801653,d:8.5738411454327E-06},
            {a:-0.73,af:false,b:0.84,bf:true,x:0.00580802801303147,y:-0.0288012322501576,d:4.529017982537E-06},
            {a:-0.14,af:false,b:0.65,bf:true,x:0.0730688,y:0.3550176,d:0.0005376},
            {a:0.29,af:false,b:-0.69,bf:true,x:-0.315738831996918,y:1.09218217039108,d:8.34465026855469E-08},
            {a:0.3,af:false,b:-0.7,bf:true,x:-0.485357638888889,y:0.718885416666667,d:0.0607638888888889},
            {a:0.3,af:false,b:-0.73,bf:true,x:-0.0767589699074074,y:0.0765726273148148,d:0.00263732156635803},
            {a:-0.02,af:true,b:0.29,bf:false,x:-0.686518518518519,y:-0.672518518518518,d:0.0518518518518518},
            {a:-0.28,af:true,b:0.14,bf:false,x:-0.741751156561967,y:-0.519210129047967,d:0.00852203554906258},
            {a:-0.44,af:true,b:0.12,bf:false,x:0.847196392746914,y:0.527164245756173,d:0.00694444444444445},
            {a:-0.44,af:true,b:0.12,bf:false,x:0.853446392746913,y:0.53508091242284,d:0.0416666666666667},
            {a:0.56,af:false,b:-0.88,bf:true,x:-0.1708,y:-0.39452,d:0.028},
            {a:0.25,af:false,b:-0.59,bf:true,x:0.99099182441701,y:-0.551221801554641,d:0.00276543209876543},
            {a:0.25,af:false,b:-0.51,bf:true,x:-0.757149538075621,y:0.117366720261758,d:1.9076063862162E-05},
            {a:0.2,af:false,b:-0.5,bf:true,x:-0.107664157881092,y:0.642703053150237,d:5.21016460161122E-07},
            {a:0.23,af:false,b:-0.55,bf:true,x:0.528524151753419,y:-0.520316808130065,d:5.91081917885445E-09},
            {a:0.23,af:false,b:-0.5,bf:true,x:0.564803446840934,y:-0.420579811642332,d:3.25228023755863E-08},
            {a:0.19,af:false,b:-0.49,bf:true,x:0.936486943215174,y:-0.406679415865717,d:0.0004788651327501},
            {a:-0.07,af:false,b:0.67,bf:true,x:-0.0743949395960297,y:-0.503823668598317,d:0.000561236096311108},
            {a:-0.2,af:false,b:0.67,bf:true,x:0.453784876895603,y:0.738234871398657,d:4.77484718430787E-05},
            {a:-0.2,af:false,b:0.67,bf:true,x:-0.0278100161885772,y:0.892654847689179,d:0.000674781108720115},
            {a:-0.38,af:false,b:-0.1,bf:true,x:-0.0110708660991143,y:0.930115111809634,d:7.08121815054211E-05},
             {a:-0.23,af:false,b:0.7,bf:true,x:0.47171163924666,y:0.612250066248465,d:1.31001603462992E-08},
            {a:-0.22,af:false,b:0.71,bf:true,x:-0.0379714168285803,y:-0.145918602226637,d:1.27522200875015E-06},
            {a:0.65,af:true,b:-1,bf:true,x:0.302882193213166,y:-1.07794721483921,d:0.00182229445394427},
            {a:-0.21,af:false,b:0.69,bf:true,x:-0.0696973513094474,y:-0.0432558610593465,d:8.52585058300345E-06},
            {a:-0.19,af:false,b:0.75,bf:true,x:-0.146859455511026,y:0.245847827374489,d:0.00345487927664699},
            {a:-1,af:true,b:0.02,bf:true,x:-0.115962,y:-0.48083,d:0.0014},
            {a:0.36,af:true,b:-0.53,bf:true,x:0.589714285714286,y:-1.09485714285714,d:0.142857142857143},
            {a:-0.5,af:true,b:0.07,bf:true,x:0.81886,y:-0.413326666666667,d:0.00466666666666667},
            {a:-0.5,af:true,b:0.07,bf:true,x:-0.746556912096168,y:-0.23908311419985,d:0.00253568745304282},
            {a:-0.05,af:true,b:0.27,bf:true,x:-0.125283094483333,y:-0.851665315532477,d:0.0117831470025021},
            {a: -0.09, af:false, b:0.66, bf:true, x: -0.426435131502669, y: -0.772992427582228, d:0.00561266691814835 },
            {a:-0.1,af:false,b:0.65,bf:true,x:-0.428288,y:-0.75824,d:0.00746666666666666},
            {a:0,af:false,b:0.89,bf:true,x:0.00104170433184471,y:-0.877516079788317,d:0.00675821799307959}


        );
        //ジュリア集合の描画エリア
        private var bdMandelbrot:BitmapData;
        public var arrColor:Array;    //グラデーションカラー
        public var uintHassan:uint;    //発散しない時のカラー
        private var intBMw:Number;    //描画サイズ
        private var intBMh:Number;
        private var iloop:int;        //描画状態(0～39)
        private var iTyp:int;        //画像の切り替え時のエフェクト
        private    var xMin:Number;    //ジュリア集合の左上の座標値
        private    var yMin:Number;
        private    var Step:Number;    //ジュリア集合の1ピクセルの値
        private const intKurikaesi:Number = 256;    //最大繰り返し数
        private var numA:Number;
        private var numB:Number;
        private var bolA:Boolean;
        private var bolB:Boolean;

        public function face():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //下の2行を加えるとHTMLで定義したサイズで表示
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align =StageAlign.TOP_LEFT;
            intBMw = stage.stageWidth;    //描画サイズ取得
            intBMh = stage.stageHeight;
            //描画エリアの作成
            bdMandelbrot = new BitmapData(intBMw, intBMh, false, 0xffffff);
            var bm:Bitmap = new Bitmap(bdMandelbrot);
            stage.addChild(bm);
            bm.x = (intBMw-stage.width)/2;
            bm.y = (intBMh-stage.height)/2;
            fncDispSt();        //描画開始
        }
        //描画開始
        private function fncDispSt():void {
            iloop = 0;        //描画位置クリア
            fncSerColor();    //グラデーションカラー
            uintHassan = 0x000000;    //発散しない時のカラー
            //それなりの画像が出来る位置テーブルの選択
            var intItiData:int = getIntRand(0, arrItiData.length - 1);
            var d:Number = arrItiData[intItiData].d;
            numA= arrItiData[intItiData].a;
            numB= arrItiData[intItiData].b;
            bolA= arrItiData[intItiData].af;
            bolB= arrItiData[intItiData].bf;
            //ジュリア集合の1ピクセルの値
            if (intBMh < intBMw) {
                Step = arrItiData[intItiData].d / intBMh;
            } else {
                Step = arrItiData[intItiData].d / intBMw;
            }
            Step = getNumRand(Step* 1.7  , Step * 2.0 );
            //ジュリア集合上の開始位置を決める
            xMin = arrItiData[intItiData].x - d  + getNumRand(0,  2*d-intBMw*Step);
            yMin = arrItiData[intItiData].y - d  + getNumRand(0,  2*d-intBMh*Step);
            
            //画像の切り替え時のエフェクトを指定
            iTyp = getIntRand(0, 5);
            //繰り返しイベントにジュリア集合の描画追加
            this.addEventListener(Event.ENTER_FRAME, fncMandelbroDisp);
        }
        //ジュリア集合の描画(1/40分描画、40回繰り返し）
        private function fncMandelbroDisp(e:*):void {
            var bolEnd:Boolean = false
            var bmItiY:int;
            var bmItiX:int;
            var a:Number;
            var b:Number;
            var xx:int;
            var yy:int;
            //描画時エフェクトする。
            switch (iTyp) {
            case 0 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, bmItiY, fncGetColor(a, -b));
                    }
                }
                break;
            case 1 :
                for (bmItiY = 0; bmItiY < intBMh; bmItiY++) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = iloop; bmItiX < intBMw; bmItiX+=40) {
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, bmItiY, fncGetColor(a, -b));
                    }
                }
                break;
            case 2 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY + bmItiX;
                        yy = yy % intBMh;
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, -b));
                    }
                }
                break;
            case 3 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY +intBMw- bmItiX;
                        yy = yy % intBMh;
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, -b));
                    }
                }
                break;
            case 4 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY;
                        if ((bmItiX % 60) < 30) { yy += 30; }
                        if (yy >= intBMh) { yy -= intBMh; }
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, -b));
                    }
                }
                break;
            case 5 :
                for (bmItiY = 0; bmItiY < intBMh; bmItiY++) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = iloop; bmItiX < intBMw; bmItiX+=40) {
                        xx = bmItiX;
                        if ((bmItiY % 60) < 30) { xx += 30; }
                        if (xx >= intBMw) { xx -= intBMw; }
                        a = xMin + xx * Step;
                        bdMandelbrot.setPixel(xx, bmItiY, fncGetColor(a, -b));
                    }
                }
                break;
            }
            if (iloop >= 39) { bolEnd = true; }
            iloop++;            
            
            if(bolEnd == true) {
                this.removeEventListener(Event.ENTER_FRAME,fncMandelbroDisp);
                var setIDName:Number = setTimeout(fncDispSt, 3000);    //3秒後に実行
            }
        }
        //ジュリア集合の1点でのカラー
        private function fncGetColor(a:Number, b:Number):uint {
            var uiCol:uint = uintHassan;    //発散しないときのカラー
            var x:Number=a;
            var y:Number=b;
            var i:int = 0;
            for(i=0;i<=intKurikaesi;i++){    //最大繰り返し数繰り返し
                var x2:Number=x*x;
                var y2:Number=y*y;
                var zx:Number=x2-y2+numA;
                var zy:Number=2*x*y+numB;
                x=zx;
                y = zy;
                                if (bolA == true) {
                    x = Math.abs(zx);
                }
                if (bolB == true) {
                    y = Math.abs(zy);
                }

                if (x2 + y2 >= 4) {
                    var id:int = i % arrColor.length;
                    uiCol= arrColor[id];
                    break;
                }
            }
            return uiCol;
        }
        //グラデーションカラー取得
        private function fncSerColor():void {
            var arrCl0:Array;
            var arrCl1:Array;
            var icflg:uint = 0;
            while (icflg == 0) {    //256階調異なるRGBがあるか？
                icflg = 0;
                arrCl0 = new Array();
                arrCl1 = new Array();
                for (var ino:int = 0; ino < 3; ino++) {    //2色RGBの各値を求める
                    var icf:int = getIntRand(0, 2);
                    //var icf:int = getIntRand(1, 2);
                    icflg += icf;
                    if (icf == 1) {            //明－＞暗
                        arrCl0.push(255);
                        arrCl1.push(0);
                    } else if (icf == 2) {    //暗ー＞明
                        arrCl0.push(0);
                        arrCl1.push(255);
                    } else {                //適当
                        var icf2:int = getIntRand(0, 3);
                        if (icf2 == 0) {
                            arrCl0.push(0);
                            arrCl1.push(127);
                        } else if (icf2 == 1) {
                            arrCl0.push(127);
                            arrCl1.push(0);
                        } else if (icf2 == 2) {
                            arrCl0.push(255);
                            arrCl1.push(127);
                        } else {
                            arrCl0.push(127);
                            arrCl1.push(255);
                        }
                    }
                }
            }
            arrColor = new Array();
            var icoln:int = 32;// getIntRand(16, 32);    //intKurikaesi;
            var i:int;
            var ir:uint;
            var ig:uint;
            var ib:uint;
            for(i = 0; i < icoln; i++) {    //グラデーションカラー作成
                ir = arrCl0[0] + (arrCl1[0] - arrCl0[0]) * i / icoln;
                ig = arrCl0[1] + (arrCl1[1] - arrCl0[1]) * i / icoln;
                ib = arrCl0[2] + (arrCl1[2] - arrCl0[2]) * i / icoln;
                arrColor.push(ir * 256 * 256 + ig * 256 + ib);
            }
            for(i = 1; i < icoln-1; i++) {    //グラデーションカラー作成
                ir = arrCl0[0] + (arrCl1[0] - arrCl0[0]) * (icoln-i) / icoln;
                ig = arrCl0[1] + (arrCl1[1] - arrCl0[1]) * (icoln-i) / icoln;
                ib = arrCl0[2] + (arrCl1[2] - arrCl0[2]) * (icoln-i) / icoln;
                arrColor.push(ir * 256 * 256 + ig * 256 + ib);
            }
        }
        //乱数
        private function getIntRand(intMin:int, intMax:int):int {
                return intMin + Math.floor(Math.random() * (intMax + 1 - intMin));
        }
        private function getNumRand(numMin:Number, numMax:Number):Number {
                return numMin + Math.random() * (numMax  - numMin);
        }
    }
}